/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.sorting;

import com.mware.ge.GeObject;
import com.mware.ge.query.SortDirection;
import com.mware.ge.sorting.SortingStrategy;
import com.mware.ge.values.storable.Value;

public class LengthOfStringSortingStrategy
implements SortingStrategy {
    private final String propertyName;

    public LengthOfStringSortingStrategy(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public int compare(GeObject o1, GeObject o2, SortDirection direction) {
        int length1 = this.getLength(o1, direction);
        int length2 = this.getLength(o2, direction);
        int result = Integer.compare(length1, length2);
        if (direction == SortDirection.DESCENDING) {
            result = -result;
        }
        return result;
    }

    private int getLength(GeObject o, SortDirection direction) {
        int length = direction == SortDirection.ASCENDING ? Integer.MAX_VALUE : 0;
        for (Value propertyValue : o.getPropertyValues(this.propertyName)) {
            int valueLength = propertyValue.toString().length();
            if (direction == SortDirection.ASCENDING) {
                length = Math.min(valueLength, length);
                continue;
            }
            length = Math.max(valueLength, length);
        }
        return length;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

