/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mware.core.cache.CacheOptions;
import com.mware.core.cache.CacheService;
import com.mware.core.cache.InMemoryCacheService;
import com.mware.core.util.StreamUtil;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.EdgeBuilder;
import com.mware.ge.EdgeBuilderBase;
import com.mware.ge.EdgeElementLocation;
import com.mware.ge.Element;
import com.mware.ge.ElementId;
import com.mware.ge.ElementType;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.FetchHints;
import com.mware.ge.FetchHintsBuilder;
import com.mware.ge.GeException;
import com.mware.ge.GeMissingFetchHintException;
import com.mware.ge.GeObjectType;
import com.mware.ge.Graph;
import com.mware.ge.GraphBaseWithSearchIndex;
import com.mware.ge.GraphMetadataEntry;
import com.mware.ge.GraphMetadataStore;
import com.mware.ge.IdRange;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.event.AddEdgeEvent;
import com.mware.ge.event.AddExtendedDataEvent;
import com.mware.ge.event.AddPropertyEvent;
import com.mware.ge.event.AddVertexEvent;
import com.mware.ge.event.DeleteEdgeEvent;
import com.mware.ge.event.DeleteExtendedDataEvent;
import com.mware.ge.event.DeleteExtendedDataRowEvent;
import com.mware.ge.event.DeletePropertyEvent;
import com.mware.ge.event.DeleteVertexEvent;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.event.MarkHiddenEdgeEvent;
import com.mware.ge.event.MarkHiddenPropertyEvent;
import com.mware.ge.event.MarkHiddenVertexEvent;
import com.mware.ge.event.MarkVisibleEdgeEvent;
import com.mware.ge.event.MarkVisiblePropertyEvent;
import com.mware.ge.event.MarkVisibleVertexEvent;
import com.mware.ge.event.SoftDeleteEdgeEvent;
import com.mware.ge.event.SoftDeletePropertyEvent;
import com.mware.ge.event.SoftDeleteVertexEvent;
import com.mware.ge.id.NameSubstitutionStrategy;
import com.mware.ge.id.SimpleNameSubstitutionStrategy;
import com.mware.ge.mutation.AlterPropertyVisibility;
import com.mware.ge.mutation.ExtendedDataDeleteMutation;
import com.mware.ge.mutation.ExtendedDataMutation;
import com.mware.ge.mutation.PropertyDeleteMutation;
import com.mware.ge.mutation.PropertySoftDeleteMutation;
import com.mware.ge.mutation.SetPropertyMetadata;
import com.mware.ge.property.MutableProperty;
import com.mware.ge.property.PropertyDescriptor;
import com.mware.ge.search.IndexHint;
import com.mware.ge.security.ColumnVisibility;
import com.mware.ge.serializer.GeSerializer;
import com.mware.ge.store.StorableEdge;
import com.mware.ge.store.StorableEdgeBuilderByVertexId;
import com.mware.ge.store.StorableElement;
import com.mware.ge.store.StorableGraph;
import com.mware.ge.store.StorableGraphConfiguration;
import com.mware.ge.store.StorableVertex;
import com.mware.ge.store.StorableVertexBuilder;
import com.mware.ge.store.mutations.ElementMutationBuilder;
import com.mware.ge.store.mutations.StoreMutation;
import com.mware.ge.store.util.StorableKeyHelper;
import com.mware.ge.store.util.StreamingPropertyValueStorageStrategy;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.util.IncreasingTime;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.Preconditions;
import com.mware.ge.util.StreamUtils;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.StreamingPropertyValueRef;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractStorableGraph<V extends StorableVertex, E extends StorableEdge>
extends GraphBaseWithSearchIndex
implements StorableGraph<V, E> {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(AbstractStorableGraph.class);
    private static final String METADATA_GRAPH_VERSION_KEY = "graph.version";
    private static final Integer METADATA_GRAPH_VERSION = 3;
    private static final String METADATA_SERIALIZER = "graph.serializer";
    private static final String METADATA_STREAMING_PROPERTY_VALUE_DATA_WRITER = "graph.streamingPropertyValueStorageStrategy";
    private final String VERTEX_CACHE_NAME = "v";
    private final String EDGE_CACHE_NAME = "e";
    protected static String verticesTableName;
    protected static String historyVerticesTableName;
    protected static String edgesTableName;
    protected static String historyEdgesTableName;
    protected static String extendedDataTableName;
    protected static String dataTableName;
    protected static String metadataTableName;
    protected final Queue<GraphEvent> graphEventQueue = new LinkedList<GraphEvent>();
    protected final ElementMutationBuilder elementMutationBuilder;
    protected NameSubstitutionStrategy nameSubstitutionStrategy;
    private Integer graphVersion;
    protected final StreamingPropertyValueStorageStrategy streamingPropertyValueStorageStrategy;
    protected final GeSerializer geSerializer;
    protected final boolean cacheEnabled;
    private boolean foundGeSerializerMetadata;
    private boolean foundStreamingPropertyValueStorageStrategyMetadata;
    private final boolean historyInSeparateTable;
    protected GraphMetadataStore graphMetadataStore;
    protected final CacheService elementCacheService;
    protected final CacheOptions elementCacheOptions;

    protected AbstractStorableGraph(StorableGraphConfiguration config) {
        super(config);
        this.historyInSeparateTable = config.isHistoryInSeparateTable();
        this.nameSubstitutionStrategy = new SimpleNameSubstitutionStrategy();
        verticesTableName = AbstractStorableGraph.getVerticesTableName(this.getConfiguration().getTableNamePrefix());
        edgesTableName = AbstractStorableGraph.getEdgesTableName(this.getConfiguration().getTableNamePrefix());
        extendedDataTableName = AbstractStorableGraph.getExtendedDataTableName(this.getConfiguration().getTableNamePrefix());
        dataTableName = AbstractStorableGraph.getDataTableName(this.getConfiguration().getTableNamePrefix());
        metadataTableName = AbstractStorableGraph.getMetadataTableName(this.getConfiguration().getTableNamePrefix());
        if (this.isHistoryInSeparateTable()) {
            historyVerticesTableName = AbstractStorableGraph.getHistoryVerticesTableName(this.getConfiguration().getTableNamePrefix());
            historyEdgesTableName = AbstractStorableGraph.getHistoryEdgesTableName(this.getConfiguration().getTableNamePrefix());
        } else {
            historyVerticesTableName = null;
            historyEdgesTableName = null;
        }
        this.geSerializer = config.createSerializer(this);
        this.streamingPropertyValueStorageStrategy = config.createStreamingPropertyValueStorageStrategy(this);
        this.cacheEnabled = config.isElementCacheEnabled();
        this.elementCacheService = new InMemoryCacheService();
        this.elementCacheOptions = new CacheOptions().setMaximumSize(Long.valueOf(config.getElementCacheSize()));
        this.elementMutationBuilder = new ElementMutationBuilder(this.streamingPropertyValueStorageStrategy, this, this.geSerializer){

            @Override
            protected void saveVertexMutation(StoreMutation m) {
                AbstractStorableGraph.this.addMutations(GeObjectType.VERTEX, m);
            }

            @Override
            protected void saveEdgeMutation(StoreMutation m) {
                AbstractStorableGraph.this.addMutations(GeObjectType.EDGE, m);
            }

            @Override
            protected void saveExtendedDataMutation(ElementType elementType, StoreMutation m) {
                AbstractStorableGraph.this.addMutations(GeObjectType.EXTENDED_DATA, m);
            }

            @Override
            protected NameSubstitutionStrategy getNameSubstitutionStrategy() {
                return AbstractStorableGraph.this.getNameSubstitutionStrategy();
            }

            @Override
            public void saveDataMutation(StoreMutation m) {
                AbstractStorableGraph.this.addMutations(GeObjectType.STREAMING_DATA, m);
            }

            @Override
            protected StreamingPropertyValueRef saveStreamingPropertyValue(String rowKey, Property property, StreamingPropertyValue propertyValue) {
                StreamingPropertyValueRef streamingPropertyValueRef = super.saveStreamingPropertyValue(rowKey, property, propertyValue);
                ((MutableProperty)property).setValue(streamingPropertyValueRef.toStreamingPropertyValue(AbstractStorableGraph.this, property.getTimestamp()));
                return streamingPropertyValueRef;
            }
        };
    }

    @Override
    protected void setup() {
        super.setup();
        if (this.graphVersion == null) {
            this.setMetadata(METADATA_GRAPH_VERSION_KEY, METADATA_GRAPH_VERSION);
        } else if (!METADATA_GRAPH_VERSION.equals(this.graphVersion)) {
            throw new GeException("Invalid accumulo graph version. Expected " + METADATA_GRAPH_VERSION + " found " + this.graphVersion);
        }
    }

    @Override
    protected void setupGraphMetadata() {
        this.foundGeSerializerMetadata = false;
        super.setupGraphMetadata();
        if (!this.foundGeSerializerMetadata) {
            this.setMetadata(METADATA_SERIALIZER, this.geSerializer.getClass().getName());
        }
        if (!this.foundStreamingPropertyValueStorageStrategyMetadata) {
            this.setMetadata(METADATA_STREAMING_PROPERTY_VALUE_DATA_WRITER, this.streamingPropertyValueStorageStrategy.getClass().getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void setupGraphMetadata(GraphMetadataEntry graphMetadataEntry) {
        super.setupGraphMetadata(graphMetadataEntry);
        if (graphMetadataEntry.getKey().equals(METADATA_GRAPH_VERSION_KEY)) {
            if (!(graphMetadataEntry.getValue() instanceof Integer)) throw new GeException("Invalid accumulo version in metadata. " + graphMetadataEntry);
            this.graphVersion = (Integer)graphMetadataEntry.getValue();
            LOGGER.info("%s=%s", METADATA_GRAPH_VERSION_KEY, this.graphVersion);
            return;
        } else if (graphMetadataEntry.getKey().equals(METADATA_SERIALIZER)) {
            this.validateClassMetadataEntry(graphMetadataEntry, this.geSerializer.getClass());
            this.foundGeSerializerMetadata = true;
            return;
        } else {
            if (!graphMetadataEntry.getKey().equals(METADATA_STREAMING_PROPERTY_VALUE_DATA_WRITER)) return;
            this.validateClassMetadataEntry(graphMetadataEntry, this.streamingPropertyValueStorageStrategy.getClass());
            this.foundStreamingPropertyValueStorageStrategyMetadata = true;
        }
    }

    private void validateClassMetadataEntry(GraphMetadataEntry graphMetadataEntry, Class expectedClass) {
        String foundClassName;
        if (!(graphMetadataEntry.getValue() instanceof String)) {
            LOGGER.error("Invalid " + graphMetadataEntry.getKey() + " expected string found " + graphMetadataEntry.getValue().getClass().getName(), new Object[0]);
        }
        if (!(foundClassName = (String)graphMetadataEntry.getValue()).equals(expectedClass.getName())) {
            LOGGER.error("Invalid " + graphMetadataEntry.getKey() + " expected " + foundClassName + " found " + expectedClass.getName(), new Object[0]);
        }
    }

    @Override
    public StorableVertexBuilder prepareVertex(String vertexId, Long timestamp, Visibility visibility, String conceptType) {
        if (vertexId == null) {
            vertexId = this.getIdGenerator().nextId();
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        final long timestampLong = timestamp;
        final String finalVertexId = vertexId;
        return new StorableVertexBuilder(finalVertexId, conceptType, visibility, this.elementMutationBuilder){

            @Override
            public Vertex save(Authorizations authorizations) {
                this.getElementMutationBuilder().saveVertexBuilder(AbstractStorableGraph.this, this, timestampLong);
                StorableVertex vertex = this.createVertex(authorizations);
                if (this.getIndexHint() != IndexHint.DO_NOT_INDEX) {
                    AbstractStorableGraph.this.getSearchIndex().addElement(AbstractStorableGraph.this, vertex, authorizations);
                    AbstractStorableGraph.this.getSearchIndex().addElementExtendedData(AbstractStorableGraph.this, vertex, this.getExtendedData(), authorizations);
                    for (ExtendedDataDeleteMutation m : this.getExtendedDataDeletes()) {
                        AbstractStorableGraph.this.getSearchIndex().deleteExtendedData(AbstractStorableGraph.this, vertex, m.getTableName(), m.getRow(), m.getColumnName(), m.getKey(), m.getVisibility(), authorizations);
                    }
                }
                if (AbstractStorableGraph.this.hasEventListeners()) {
                    AbstractStorableGraph.this.queueEvent(new AddVertexEvent(AbstractStorableGraph.this, vertex));
                    AbstractStorableGraph.this.queueEvents(vertex, this.getProperties(), this.getPropertyDeletes(), this.getPropertySoftDeletes(), this.getExtendedData(), this.getExtendedDataDeletes());
                }
                if (AbstractStorableGraph.this.cacheEnabled) {
                    AbstractStorableGraph.this.elementCacheService.put("v", finalVertexId, vertex, AbstractStorableGraph.this.elementCacheOptions);
                }
                return vertex;
            }

            @Override
            protected StorableVertex createVertex(Authorizations authorizations) {
                Iterable<Visibility> hiddenVisibilities = null;
                String conceptType = this.getConceptType();
                if (this.getNewConceptType() != null) {
                    conceptType = this.getNewConceptType();
                }
                return new StorableVertex(AbstractStorableGraph.this, this.getId(), conceptType, null, this.getVisibility(), this.getProperties(), this.getPropertyDeletes(), this.getPropertySoftDeletes(), hiddenVisibilities, this.getExtendedDataTableNames(), timestampLong, FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
            }
        };
    }

    @Override
    public void saveProperties(StorableElement element, Iterable<Property> properties, Iterable<PropertyDeleteMutation> propertyDeletes, Iterable<PropertySoftDeleteMutation> propertySoftDeletes) {
        String elementRowKey = element.getId();
        StoreMutation m = new StoreMutation(elementRowKey);
        boolean hasProperty = false;
        for (PropertyDeleteMutation propertyDelete : propertyDeletes) {
            hasProperty = true;
            this.elementMutationBuilder.addPropertyDeleteToMutation(m, propertyDelete);
        }
        for (PropertySoftDeleteMutation propertySoftDelete : propertySoftDeletes) {
            hasProperty = true;
            this.elementMutationBuilder.addPropertySoftDeleteToMutation(m, propertySoftDelete);
        }
        for (Property property : properties) {
            hasProperty = true;
            this.elementMutationBuilder.addPropertyToMutation(this, m, elementRowKey, property);
            if (!(property.getValue() instanceof StreamingPropertyValue)) continue;
            element.addPropertyInternal(property);
        }
        if (hasProperty) {
            this.addMutations(element, m);
        }
        if (this.hasEventListeners()) {
            this.queueEvents(element, properties, propertyDeletes, propertySoftDeletes, null, null);
        }
    }

    @Override
    public void deleteProperty(StorableElement element, Property property, Authorizations authorizations) {
        if (!element.getFetchHints().isIncludePropertyAndMetadata(property.getName())) {
            throw new GeMissingFetchHintException(element.getFetchHints(), "Property " + property.getName() + " needs to be included with metadata");
        }
        StoreMutation m = new StoreMutation(element.getId());
        this.elementMutationBuilder.addPropertyDeleteToMutation(m, property);
        this.addMutations(element, m);
        this.getSearchIndex().deleteProperty(this, element, PropertyDescriptor.fromProperty(property), authorizations);
        if (this.hasEventListeners()) {
            this.queueEvent(new DeletePropertyEvent((Graph)this, (Element)element, property));
        }
    }

    @Override
    public void softDeleteProperty(StorableElement element, Property property, Authorizations authorizations) {
        StoreMutation m = new StoreMutation(element.getId());
        this.elementMutationBuilder.addPropertySoftDeleteToMutation(m, property);
        this.addMutations(element, m);
        this.getSearchIndex().deleteProperty(this, element, PropertyDescriptor.fromProperty(property), authorizations);
        if (this.hasEventListeners()) {
            this.queueEvent(new SoftDeletePropertyEvent((Graph)this, (Element)element, property));
        }
    }

    @Override
    public void softDeleteProperties(Iterable<Property> properties, StorableElement element, Authorizations authorizations) {
        StreamUtil.stream(properties).forEach(p -> this.softDeleteProperty(element, (Property)p, authorizations));
    }

    protected void addMutations(Element element, StoreMutation ... mutations) {
        this.addMutations(GeObjectType.getTypeFromElement(element), mutations);
    }

    protected abstract void addMutations(GeObjectType var1, StoreMutation ... var2);

    private void queueEvents(Element element, Iterable<Property> properties, Iterable<PropertyDeleteMutation> propertyDeletes, Iterable<PropertySoftDeleteMutation> propertySoftDeletes, Iterable<ExtendedDataMutation> extendedData, Iterable<ExtendedDataDeleteMutation> extendedDataDeletes) {
        if (properties != null) {
            for (Property property : properties) {
                this.queueEvent(new AddPropertyEvent(this, element, property));
            }
        }
        if (propertyDeletes != null) {
            for (PropertyDeleteMutation propertyDeleteMutation : propertyDeletes) {
                this.queueEvent(new DeletePropertyEvent((Graph)this, element, propertyDeleteMutation));
            }
        }
        if (propertySoftDeletes != null) {
            for (PropertySoftDeleteMutation propertySoftDeleteMutation : propertySoftDeletes) {
                this.queueEvent(new SoftDeletePropertyEvent((Graph)this, element, propertySoftDeleteMutation));
            }
        }
        if (extendedData != null) {
            for (ExtendedDataMutation extendedDataMutation : extendedData) {
                this.queueEvent(new AddExtendedDataEvent(this, element, extendedDataMutation.getTableName(), extendedDataMutation.getRow(), extendedDataMutation.getColumnName(), extendedDataMutation.getKey(), extendedDataMutation.getValue(), extendedDataMutation.getVisibility()));
            }
        }
        if (extendedDataDeletes != null) {
            for (ExtendedDataDeleteMutation extendedDataDeleteMutation : extendedDataDeletes) {
                this.queueEvent(new DeleteExtendedDataEvent(this, element, extendedDataDeleteMutation.getTableName(), extendedDataDeleteMutation.getRow(), extendedDataDeleteMutation.getColumnName(), extendedDataDeleteMutation.getKey()));
            }
        }
    }

    @Override
    public Iterable<Vertex> getVertices(FetchHints fetchHints, Long endTime, Authorizations authorizations) throws GeException {
        return this.getVerticesInRange(new IdRange(null, null), fetchHints, endTime, authorizations);
    }

    @Override
    public void deleteElements(Stream<? extends ElementId> elementIds, Authorizations authorizations) {
        DeleteElementsConsumer consumer = new DeleteElementsConsumer(authorizations);
        elementIds.forEach(consumer);
        consumer.processBatches(true);
    }

    @Override
    public void deleteVertex(Vertex vertex, Authorizations authorizations) {
        if (this.cacheEnabled) {
            this.elementCacheService.invalidate("v", (String)vertex.getId());
        }
        this.deleteElements(Stream.of(vertex), authorizations);
    }

    @Override
    public void deleteVertex(String vertexId, Authorizations authorizations) {
        if (this.cacheEnabled) {
            this.elementCacheService.invalidate("v", vertexId);
        }
        this.deleteElements(Stream.of(vertexId).map(ElementId::vertex), authorizations);
    }

    @Override
    public void deleteEdge(String edgeId, Authorizations authorizations) {
        if (this.cacheEnabled) {
            this.elementCacheService.invalidate("e", edgeId);
        }
        this.deleteElements(Stream.of(edgeId).map(ElementId::edge), authorizations);
    }

    @Override
    public void softDeleteVertex(Vertex vertex, Long timestamp, Authorizations authorizations) {
        Preconditions.checkNotNull(vertex, "vertex cannot be null");
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        this.getSearchIndex().deleteElement(this, vertex, authorizations);
        for (Edge edge : vertex.getEdges(Direction.BOTH, authorizations)) {
            this.softDeleteEdge(edge, timestamp, authorizations);
        }
        this.addMutations(GeObjectType.VERTEX, this.getSoftDeleteRowMutation((String)vertex.getId(), timestamp));
        if (this.hasEventListeners()) {
            this.queueEvent(new SoftDeleteVertexEvent(this, vertex));
        }
    }

    private StoreMutation getSoftDeleteRowMutation(String rowKey, long timestamp) {
        StoreMutation m = new StoreMutation(rowKey);
        m.put((CharSequence)"D", (CharSequence)"D", timestamp, StorableElement.SOFT_DELETE_VALUE);
        return m;
    }

    @Override
    public void markVertexHidden(Vertex vertex, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull(vertex, "vertex cannot be null");
        ColumnVisibility columnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(visibility);
        for (Edge edge : vertex.getEdges(Direction.BOTH, authorizations)) {
            this.markEdgeHidden(edge, visibility, authorizations);
        }
        this.addMutations(GeObjectType.VERTEX, this.getMarkHiddenRowMutation((String)vertex.getId(), columnVisibility));
        this.getSearchIndex().markElementHidden(this, vertex, visibility, authorizations);
        if (this.hasEventListeners()) {
            this.queueEvent(new MarkHiddenVertexEvent(this, vertex));
        }
    }

    private StoreMutation getMarkHiddenRowMutation(String rowKey, ColumnVisibility visibility) {
        StoreMutation m = new StoreMutation(rowKey);
        m.put((CharSequence)"H", (CharSequence)"H", visibility, StorableElement.HIDDEN_VALUE);
        return m;
    }

    @Override
    public void markVertexVisible(Vertex vertex, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull(vertex, "vertex cannot be null");
        ColumnVisibility columnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(visibility);
        for (Edge edge : vertex.getEdges(Direction.BOTH, FetchHints.ALL_INCLUDING_HIDDEN, authorizations)) {
            this.markEdgeVisible(edge, visibility, authorizations);
        }
        this.addMutations(GeObjectType.VERTEX, this.getMarkVisibleRowMutation((String)vertex.getId(), columnVisibility));
        this.getSearchIndex().markElementVisible(this, vertex, visibility, authorizations);
        if (this.hasEventListeners()) {
            this.queueEvent(new MarkVisibleVertexEvent(this, vertex));
        }
    }

    private StoreMutation getMarkVisibleRowMutation(String rowKey, ColumnVisibility visibility) {
        StoreMutation m = new StoreMutation(rowKey);
        m.putDelete("H", "H", visibility);
        return m;
    }

    @Override
    public List<InputStream> getStreamingPropertyValueInputStreams(List<StreamingPropertyValue> streamingPropertyValues) {
        if (streamingPropertyValues.size() == 0) {
            return Collections.emptyList();
        }
        return this.streamingPropertyValueStorageStrategy.getInputStreams(streamingPropertyValues);
    }

    @Override
    public Iterable<ExtendedDataRow> getExtendedData(Iterable<ExtendedDataRowId> ids, FetchHints fetchHints, Authorizations authorizations) {
        List<IdRange> ranges = this.extendedDataRowIdToRange(ids);
        return this.getExtendedDataRowsInRange(ranges, fetchHints, authorizations);
    }

    protected abstract Iterable<ExtendedDataRow> getExtendedDataRowsInRange(List<IdRange> var1, FetchHints var2, Authorizations var3);

    @Override
    public Iterable<ExtendedDataRow> getExtendedDataForElements(Iterable<? extends ElementId> elementIdsArg, String tableName, FetchHints fetchHints, Authorizations authorizations) {
        List<? extends ElementId> elementIds = IterableUtils.toList(elementIdsArg);
        try {
            List<IdRange> ranges = elementIds.stream().map(elementId -> IdRange.prefix(StorableKeyHelper.createExtendedDataRowKey(elementId.getElementType(), elementId.getId(), tableName, null))).collect(Collectors.toList());
            if (ranges.size() == 0) {
                return Collections.emptyList();
            }
            return this.getExtendedDataRowsInRange(ranges, fetchHints, authorizations);
        }
        catch (IllegalStateException ex) {
            throw new GeException("Failed to get extended data: " + Joiner.on((String)", ").join(elementIds) + ":" + tableName, ex);
        }
    }

    @Override
    public Iterable<ExtendedDataRow> getExtendedDataInRange(ElementType elementType, IdRange elementIdRange, Authorizations authorizations) {
        IdRange extendedDataRowKeyRange = StorableKeyHelper.createExtendedDataRowKeyRange(elementType, elementIdRange);
        return this.getExtendedDataInRange(extendedDataRowKeyRange, authorizations);
    }

    public Iterable<ExtendedDataRow> getExtendedDataInRange(IdRange extendedDataRowKeyRange, Authorizations authorizations) {
        return this.getExtendedDataRowsInRange(Collections.singletonList(extendedDataRowKeyRange), FetchHints.ALL, authorizations);
    }

    private List<IdRange> extendedDataRowIdToRange(Iterable<ExtendedDataRowId> ids) {
        return StreamUtils.stream(ids).map(id -> IdRange.prefix(StorableKeyHelper.createExtendedDataRowKey(id))).collect(Collectors.toList());
    }

    @Override
    public void saveExtendedDataMutations(Element element, ElementType elementType, IndexHint indexHint, Iterable<ExtendedDataMutation> extendedData, Iterable<ExtendedDataDeleteMutation> extendedDataDeletes, Authorizations authorizations) {
        if (extendedData == null) {
            return;
        }
        Object elementId = element.getId();
        this.elementMutationBuilder.saveExtendedDataMarkers((String)elementId, elementType, extendedData);
        this.elementMutationBuilder.saveExtendedData(this, (String)elementId, elementType, extendedData, extendedDataDeletes);
        if (indexHint != IndexHint.DO_NOT_INDEX) {
            this.getSearchIndex().addElementExtendedData(this, element, extendedData, authorizations);
            for (ExtendedDataDeleteMutation m : extendedDataDeletes) {
                this.getSearchIndex().deleteExtendedData(this, element, m.getTableName(), m.getRow(), m.getColumnName(), m.getKey(), m.getVisibility(), authorizations);
            }
        }
        if (this.hasEventListeners()) {
            this.queueEvents(element, null, null, null, extendedData, extendedDataDeletes);
        }
    }

    @Override
    public Edge getEdge(String edgeId, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        Edge edge;
        if (this.cacheEnabled && (edge = (Edge)this.elementCacheService.getIfPresent("e", edgeId)) != null && edge.getFetchHints().hasFetchHints(fetchHints) && authorizations.contains(edge.getAuthorizations())) {
            return edge;
        }
        try {
            edge = IterableUtils.singleOrDefault(this.getEdgesInRange(new IdRange(edgeId, true, edgeId, true), fetchHints, endTime, authorizations), null);
            if (edge != null && this.cacheEnabled) {
                this.elementCacheService.put("e", edgeId, edge, this.elementCacheOptions);
            }
            return edge;
        }
        catch (IllegalStateException ex) {
            throw new GeException("Failed to find edge with id: " + edgeId, ex);
        }
    }

    @Override
    public Iterable<Edge> getEdges(FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        return this.getEdgesInRange(null, fetchHints, endTime, authorizations);
    }

    @Override
    public abstract Iterable<Edge> getEdgesInRange(IdRange var1, FetchHints var2, Long var3, Authorizations var4);

    @Override
    public StorableEdgeBuilderByVertexId prepareEdge(String edgeId, String outVertexId, String inVertexId, String label, Long timestamp, Visibility visibility) {
        Preconditions.checkNotNull(outVertexId, "outVertexId cannot be null");
        Preconditions.checkNotNull(inVertexId, "inVertexId cannot be null");
        Preconditions.checkNotNull(label, "label cannot be null");
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        final long timestampLong = timestamp;
        String finalEdgeId = edgeId;
        return new StorableEdgeBuilderByVertexId(finalEdgeId, outVertexId, inVertexId, label, visibility, this.elementMutationBuilder){

            @Override
            public Edge save(Authorizations authorizations) {
                AbstractStorableGraph.this.elementMutationBuilder.saveEdgeBuilder(AbstractStorableGraph.this, this, timestampLong);
                StorableEdge edge = AbstractStorableGraph.this.createEdge(this, timestampLong, FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
                return AbstractStorableGraph.this.savePreparedEdge(this, edge, null, authorizations);
            }

            @Override
            protected StorableEdge createEdge(Authorizations authorizations) {
                return AbstractStorableGraph.this.createEdge(this, timestampLong, FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
            }
        };
    }

    @Override
    public EdgeBuilder prepareEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Long timestamp, Visibility visibility) {
        Preconditions.checkNotNull(outVertex, "outVertex cannot be null");
        Preconditions.checkNotNull(inVertex, "inVertex cannot be null");
        Preconditions.checkNotNull(label, "label cannot be null");
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        final long timestampLong = timestamp;
        String finalEdgeId = edgeId;
        return new EdgeBuilder(finalEdgeId, outVertex, inVertex, label, visibility){

            @Override
            public Edge save(Authorizations authorizations) {
                AddEdgeToVertexRunnable addEdgeToVertex = new AddEdgeToVertexRunnable(){

                    @Override
                    public void run(StorableEdge edge) {
                        if (this.getOutVertex() instanceof StorableVertex) {
                            ((StorableVertex)this.getOutVertex()).addOutEdge(edge);
                        }
                        if (this.getInVertex() instanceof StorableVertex) {
                            ((StorableVertex)this.getInVertex()).addInEdge(edge);
                        }
                    }
                };
                AbstractStorableGraph.this.elementMutationBuilder.saveEdgeBuilder(AbstractStorableGraph.this, this, timestampLong);
                StorableEdge edge = AbstractStorableGraph.this.createEdge(this, timestampLong, FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
                return AbstractStorableGraph.this.savePreparedEdge(this, edge, addEdgeToVertex, authorizations);
            }
        };
    }

    protected StorableEdge createEdge(EdgeBuilderBase edgeBuilder, long timestamp, FetchHints fetchHints, Authorizations authorizations) {
        Iterable<Visibility> hiddenVisibilities = null;
        String edgeLabel = edgeBuilder.getEdgeLabel();
        if (edgeBuilder.getNewEdgeLabel() != null) {
            edgeLabel = edgeBuilder.getNewEdgeLabel();
        }
        return new StorableEdge(this, edgeBuilder.getId(), edgeBuilder.getVertexId(Direction.OUT), edgeBuilder.getVertexId(Direction.IN), edgeLabel, null, edgeBuilder.getVisibility(), edgeBuilder.getProperties(), edgeBuilder.getPropertyDeletes(), edgeBuilder.getPropertySoftDeletes(), hiddenVisibilities, edgeBuilder.getExtendedDataTableNames(), timestamp, fetchHints, authorizations);
    }

    private Edge savePreparedEdge(EdgeBuilderBase edgeBuilder, StorableEdge edge, AddEdgeToVertexRunnable addEdgeToVertex, Authorizations authorizations) {
        if (addEdgeToVertex != null) {
            addEdgeToVertex.run(edge);
        }
        if (edgeBuilder.getIndexHint() != IndexHint.DO_NOT_INDEX) {
            this.getSearchIndex().addElement(this, edge, authorizations);
            this.getSearchIndex().addElementExtendedData(this, edge, edgeBuilder.getExtendedData(), authorizations);
            for (ExtendedDataDeleteMutation m : edgeBuilder.getExtendedDataDeletes()) {
                this.getSearchIndex().deleteExtendedData(this, edge, m.getTableName(), m.getRow(), m.getColumnName(), m.getKey(), m.getVisibility(), authorizations);
            }
        }
        if (this.hasEventListeners()) {
            this.queueEvent(new AddEdgeEvent(this, edge));
            this.queueEvents(edge, edgeBuilder.getProperties(), edgeBuilder.getPropertyDeletes(), edgeBuilder.getPropertySoftDeletes(), edgeBuilder.getExtendedData(), edgeBuilder.getExtendedDataDeletes());
        }
        if (this.cacheEnabled) {
            this.elementCacheService.invalidate("e", edge.getId());
            this.elementCacheService.invalidate("v", edgeBuilder.getVertexId(Direction.OUT));
            this.elementCacheService.invalidate("v", edgeBuilder.getVertexId(Direction.IN));
        }
        return edge;
    }

    @Override
    public void deleteExtendedDataRow(ExtendedDataRowId rowId, Authorizations authorizations) {
        Preconditions.checkNotNull(rowId);
        this.getSearchIndex().deleteExtendedData(this, rowId, authorizations);
        this.addMutations(GeObjectType.EXTENDED_DATA, this.getDeleteExtendedDataMutations(rowId));
        if (this.hasEventListeners()) {
            this.queueEvent(new DeleteExtendedDataRowEvent(this, rowId));
        }
    }

    @Override
    public void softDeleteEdge(Edge edge, Long timestamp, Authorizations authorizations) {
        Preconditions.checkNotNull(edge);
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        this.getSearchIndex().deleteElement(this, edge, authorizations);
        ColumnVisibility visibility = ElementMutationBuilder.visibilityToColumnVisibility(edge.getVisibility());
        StoreMutation outMutation = new StoreMutation(edge.getVertexId(Direction.OUT));
        outMutation.put("EOUTD", (CharSequence)edge.getId(), visibility, timestamp, StorableElement.SOFT_DELETE_VALUE);
        StoreMutation inMutation = new StoreMutation(edge.getVertexId(Direction.IN));
        inMutation.put("EIND", (CharSequence)edge.getId(), visibility, timestamp, StorableElement.SOFT_DELETE_VALUE);
        this.addMutations(GeObjectType.VERTEX, outMutation, inMutation);
        this.addMutations(GeObjectType.EDGE, this.getSoftDeleteRowMutation((String)edge.getId(), timestamp));
        if (this.hasEventListeners()) {
            this.queueEvent(new SoftDeleteEdgeEvent(this, edge));
        }
    }

    @Override
    public void deleteEdge(Edge edge, Authorizations authorizations) {
        this.deleteElements(Stream.of(edge), authorizations);
    }

    @Override
    public void markEdgeHidden(Edge edge, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull(edge);
        Vertex out = edge.getVertex(Direction.OUT, authorizations);
        if (out == null) {
            throw new GeException(String.format("Unable to mark edge hidden %s, can't find out vertex %s", edge.getId(), edge.getVertexId(Direction.OUT)));
        }
        Vertex in = edge.getVertex(Direction.IN, authorizations);
        if (in == null) {
            throw new GeException(String.format("Unable to mark edge hidden %s, can't find in vertex %s", edge.getId(), edge.getVertexId(Direction.IN)));
        }
        ColumnVisibility columnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(visibility);
        StoreMutation outMutation = new StoreMutation((String)out.getId());
        outMutation.put((CharSequence)"EOUTH", (CharSequence)edge.getId(), columnVisibility, StorableElement.HIDDEN_VALUE);
        StoreMutation inMutation = new StoreMutation((String)in.getId());
        inMutation.put((CharSequence)"EINH", (CharSequence)edge.getId(), columnVisibility, StorableElement.HIDDEN_VALUE);
        this.addMutations(GeObjectType.VERTEX, outMutation, inMutation);
        this.addMutations(GeObjectType.EDGE, this.getMarkHiddenRowMutation((String)edge.getId(), columnVisibility));
        if (out instanceof StorableVertex) {
            ((StorableVertex)out).removeOutEdge(edge);
        }
        if (in instanceof StorableVertex) {
            ((StorableVertex)in).removeInEdge(edge);
        }
        this.getSearchIndex().markElementHidden(this, edge, visibility, authorizations);
        if (this.hasEventListeners()) {
            this.queueEvent(new MarkHiddenEdgeEvent(this, edge));
        }
    }

    @Override
    public void markEdgeVisible(Edge edge, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull(edge);
        Vertex out = edge.getVertex(Direction.OUT, FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
        if (out == null) {
            throw new GeException(String.format("Unable to mark edge visible %s, can't find out vertex %s", edge.getId(), edge.getVertexId(Direction.OUT)));
        }
        Vertex in = edge.getVertex(Direction.IN, FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
        if (in == null) {
            throw new GeException(String.format("Unable to mark edge visible %s, can't find in vertex %s", edge.getId(), edge.getVertexId(Direction.IN)));
        }
        ColumnVisibility columnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(visibility);
        StoreMutation outMutation = new StoreMutation((String)out.getId());
        outMutation.putDelete("EOUTH", (CharSequence)edge.getId(), columnVisibility);
        StoreMutation inMutation = new StoreMutation((String)in.getId());
        inMutation.putDelete("EINH", (CharSequence)edge.getId(), columnVisibility);
        this.addMutations(GeObjectType.VERTEX, outMutation, inMutation);
        this.addMutations(GeObjectType.EDGE, this.getMarkVisibleRowMutation((String)edge.getId(), columnVisibility));
        if (out instanceof StorableVertex) {
            ((StorableVertex)out).addOutEdge(edge);
        }
        if (in instanceof StorableVertex) {
            ((StorableVertex)in).addInEdge(edge);
        }
        this.getSearchIndex().markElementVisible(this, edge, visibility, authorizations);
        if (this.hasEventListeners()) {
            this.queueEvent(new MarkVisibleEdgeEvent(this, edge));
        }
    }

    @Override
    public Authorizations createAuthorizations(String ... auths) {
        return new Authorizations(auths);
    }

    @Override
    public Vertex getVertex(String vertexId, FetchHints fetchHints, Long endTime, Authorizations authorizations) throws GeException {
        try {
            Vertex vertex;
            if (vertexId == null) {
                return null;
            }
            if (this.cacheEnabled && (vertex = (Vertex)this.elementCacheService.getIfPresent("v", vertexId)) != null && vertex.getFetchHints().hasFetchHints(fetchHints) && authorizations.contains(vertex.getAuthorizations())) {
                return vertex;
            }
            vertex = IterableUtils.singleOrDefault(this.getVerticesInRange(new IdRange(vertexId), fetchHints, endTime, authorizations), null);
            if (vertex != null && this.cacheEnabled) {
                this.elementCacheService.put("v", vertexId, vertex, this.elementCacheOptions);
            }
            return vertex;
        }
        catch (IllegalStateException ex) {
            throw new GeException("Failed to find vertex with id: " + vertexId, ex);
        }
    }

    @Override
    public Iterable<String> getVertexIds(Authorizations authorizations) {
        return new ConvertingIterable<Vertex, String>(this.getVertices(FetchHints.NONE, authorizations)){

            @Override
            protected String convert(Vertex o) {
                return o.getId();
            }
        };
    }

    @Override
    public Iterable<Vertex> getVerticesWithPrefix(String vertexIdPrefix, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        IdRange range = IdRange.prefix(vertexIdPrefix);
        return this.getVerticesInRange(range, fetchHints, endTime, authorizations);
    }

    @Override
    public abstract Iterable<Vertex> getVerticesInRange(IdRange var1, FetchHints var2, Long var3, Authorizations var4);

    @Override
    public void alterElementVisibility(StorableElement element, Visibility newVisibility, Authorizations authorizations) {
        StoreMutation m;
        String elementRowKey = element.getId();
        if (element instanceof Edge) {
            String vertexInRowKey;
            StoreMutation vertexInMutation;
            Edge edge = (Edge)((Object)element);
            String vertexOutRowKey = edge.getVertexId(Direction.OUT);
            StoreMutation vertexOutMutation = new StoreMutation(vertexOutRowKey);
            if (this.elementMutationBuilder.alterEdgeVertexOutVertex(vertexOutMutation, edge, newVisibility)) {
                this.addMutations(GeObjectType.VERTEX, vertexOutMutation);
            }
            if (this.elementMutationBuilder.alterEdgeVertexInVertex(vertexInMutation = new StoreMutation(vertexInRowKey = edge.getVertexId(Direction.IN)), edge, newVisibility)) {
                this.addMutations(GeObjectType.VERTEX, vertexInMutation);
            }
        }
        if (this.elementMutationBuilder.alterElementVisibility(m = new StoreMutation(elementRowKey), element, newVisibility)) {
            this.addMutations(element, m);
        }
        element.setVisibility(newVisibility);
    }

    @Override
    public void alterEdgeLabel(E edge, String newEdgeLabel, Authorizations authorizations) {
        this.elementMutationBuilder.alterEdgeLabel((Edge)edge, newEdgeLabel);
        ((StorableEdge)edge).setLabel(newEdgeLabel);
    }

    @Override
    public void alterConceptType(V vertex, String newConceptType) {
        this.elementMutationBuilder.alterVertexConceptType((Vertex)vertex, newConceptType);
        ((StorableVertex)vertex).setConceptType(newConceptType);
    }

    @Override
    public void alterElementPropertyVisibilities(StorableElement element, List<AlterPropertyVisibility> alterPropertyVisibilities) {
        if (alterPropertyVisibilities.size() == 0) {
            return;
        }
        String elementRowKey = element.getId();
        StoreMutation m = new StoreMutation(elementRowKey);
        ArrayList propertyList = Lists.newArrayList();
        for (AlterPropertyVisibility apv : alterPropertyVisibilities) {
            MutableProperty property = (MutableProperty)element.getProperty(apv.getKey(), apv.getName(), apv.getExistingVisibility());
            if (property == null) {
                throw new GeException("Could not find property " + apv.getKey() + ":" + apv.getName());
            }
            if (property.getVisibility().equals(apv.getVisibility())) continue;
            if (apv.getExistingVisibility() == null) {
                apv.setExistingVisibility(property.getVisibility());
            }
            this.elementMutationBuilder.addPropertySoftDeleteToMutation(m, property);
            property.setVisibility(apv.getVisibility());
            property.setTimestamp(apv.getTimestamp());
            this.elementMutationBuilder.addPropertyToMutation(this, m, elementRowKey, property);
            propertyList.add(PropertyDescriptor.from(apv.getKey(), apv.getName(), apv.getExistingVisibility()));
        }
        if (!propertyList.isEmpty()) {
            this.addMutations(element, m);
        }
    }

    @Override
    public void alterPropertyMetadatas(StorableElement element, List<SetPropertyMetadata> setPropertyMetadatas) {
        if (setPropertyMetadatas.size() == 0) {
            return;
        }
        String elementRowKey = element.getId();
        StoreMutation m = new StoreMutation(elementRowKey);
        for (SetPropertyMetadata apm : setPropertyMetadatas) {
            Property property = element.getProperty(apm.getPropertyKey(), apm.getPropertyName(), apm.getPropertyVisibility());
            if (property == null) {
                throw new GeException(String.format("Could not find property %s:%s(%s)", apm.getPropertyKey(), apm.getPropertyName(), apm.getPropertyVisibility()));
            }
            if (property.getFetchHints().isIncludePropertyAndMetadata(property.getName())) {
                property.getMetadata().add(apm.getMetadataName(), apm.getNewValue(), apm.getMetadataVisibility());
            }
            this.elementMutationBuilder.addPropertyMetadataItemToMutation(m, property, apm.getMetadataName(), apm.getNewValue(), apm.getMetadataVisibility());
        }
        this.addMutations(element, m);
    }

    @Override
    public boolean isVisibilityValid(Visibility visibility, Authorizations authorizations) {
        return authorizations.canRead(visibility);
    }

    @Override
    public void markPropertyHidden(StorableElement element, Property property, Long timestamp, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull(element);
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        ColumnVisibility columnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(visibility);
        if (element instanceof Vertex) {
            this.addMutations(GeObjectType.VERTEX, this.getMarkHiddenPropertyMutation(element.getId(), property, timestamp, columnVisibility));
        } else if (element instanceof Edge) {
            this.addMutations(GeObjectType.EDGE, this.getMarkHiddenPropertyMutation(element.getId(), property, timestamp, columnVisibility));
        }
        this.getSearchIndex().markPropertyHidden(this, element, property, visibility, authorizations);
        if (this.hasEventListeners()) {
            this.queueEvent(new MarkHiddenPropertyEvent(this, element, property, visibility));
        }
    }

    private StoreMutation getMarkHiddenPropertyMutation(String rowKey, Property property, long timestamp, ColumnVisibility visibility) {
        StoreMutation m = new StoreMutation(rowKey);
        String columnQualifier = StorableKeyHelper.getColumnQualifierFromPropertyHiddenColumnQualifier(property, this.getNameSubstitutionStrategy());
        m.put("PROPH", columnQualifier, visibility, timestamp, StorableElement.HIDDEN_VALUE);
        return m;
    }

    @Override
    public void markPropertyVisible(StorableElement element, Property property, Long timestamp, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull(element);
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        ColumnVisibility columnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(visibility);
        if (element instanceof Vertex) {
            this.addMutations(GeObjectType.VERTEX, this.getMarkVisiblePropertyMutation(element.getId(), property, timestamp, columnVisibility));
        } else if (element instanceof Edge) {
            this.addMutations(GeObjectType.EDGE, this.getMarkVisiblePropertyMutation(element.getId(), property, timestamp, columnVisibility));
        }
        this.getSearchIndex().markPropertyVisible(this, element, property, visibility, authorizations);
        if (this.hasEventListeners()) {
            this.queueEvent(new MarkVisiblePropertyEvent(this, element, property, visibility));
        }
    }

    private StoreMutation getMarkVisiblePropertyMutation(String rowKey, Property property, long timestamp, ColumnVisibility visibility) {
        StoreMutation m = new StoreMutation(rowKey);
        String columnQualifier = StorableKeyHelper.getColumnQualifierFromPropertyHiddenColumnQualifier(property, this.getNameSubstitutionStrategy());
        m.put("PROPH", columnQualifier, visibility, timestamp, StorableElement.HIDDEN_VALUE_DELETED);
        return m;
    }

    @Override
    public long getVertexCount(Authorizations authorizations) {
        String tableName = this.getTableNameFromElementType(ElementType.VERTEX);
        return this.getRowCountFromTable(tableName, "V", authorizations);
    }

    @Override
    public long getEdgeCount(Authorizations authorizations) {
        String tableName = this.getTableNameFromElementType(ElementType.EDGE);
        return this.getRowCountFromTable(tableName, "E", authorizations);
    }

    protected abstract long getRowCountFromTable(String var1, String var2, Authorizations var3);

    private StoreMutation[] getDeleteExtendedDataMutations(ExtendedDataRowId rowId) {
        StoreMutation[] mutations = new StoreMutation[1];
        String rowKey = StorableKeyHelper.createExtendedDataRowKey(rowId);
        StoreMutation m = new StoreMutation(rowKey);
        m.put("", "", ElementMutationBuilder.DELETE_ROW_VALUE);
        mutations[0] = m;
        return mutations;
    }

    @Override
    public void invalidateElementFromCache(ElementType elementType, String id) {
        if (this.cacheEnabled) {
            this.elementCacheService.invalidate(ElementType.VERTEX.equals((Object)elementType) ? "v" : "e", id);
        }
    }

    public void addElementToCache(ElementType elementType, Element element) {
        if (this.cacheEnabled) {
            this.elementCacheService.put(ElementType.VERTEX.equals((Object)elementType) ? "v" : "e", (String)element.getId(), element, this.elementCacheOptions);
        } else {
            LOGGER.warn("Element caching is not enabled", new Object[0]);
        }
    }

    @Override
    protected GraphMetadataStore getGraphMetadataStore() {
        return this.graphMetadataStore;
    }

    public void setGraphMetadataStore(GraphMetadataStore graphMetadataStore) {
        this.graphMetadataStore = graphMetadataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueEvent(GraphEvent graphEvent) {
        if (!this.hasEventListeners()) {
            return;
        }
        Queue<GraphEvent> queue = this.graphEventQueue;
        synchronized (queue) {
            this.graphEventQueue.add(graphEvent);
        }
    }

    public static String getVerticesTableName(String tableNamePrefix) {
        return tableNamePrefix + "_v";
    }

    public static String getHistoryVerticesTableName(String tableNamePrefix) {
        return tableNamePrefix + "_vh";
    }

    public static String getEdgesTableName(String tableNamePrefix) {
        return tableNamePrefix.concat("_e");
    }

    public static String getHistoryEdgesTableName(String tableNamePrefix) {
        return tableNamePrefix.concat("_eh");
    }

    public static String getExtendedDataTableName(String tableNamePrefix) {
        return tableNamePrefix + "_extdata";
    }

    public static String getDataTableName(String tableNamePrefix) {
        return tableNamePrefix.concat("_d");
    }

    public static String getMetadataTableName(String tableNamePrefix) {
        return tableNamePrefix.concat("_m");
    }

    public String getVerticesTableName() {
        return verticesTableName;
    }

    public String getHistoryVerticesTableName() {
        return historyVerticesTableName;
    }

    public String getEdgesTableName() {
        return edgesTableName;
    }

    public String getHistoryEdgesTableName() {
        return historyEdgesTableName;
    }

    public static String getExtendedDataTableName() {
        return extendedDataTableName;
    }

    public String getDataTableName() {
        return dataTableName;
    }

    public String getMetadataTableName() {
        return metadataTableName;
    }

    protected boolean isHistoryInSeparateTable() {
        return this.historyInSeparateTable;
    }

    public String getTableNameFromElementType(ElementType elementType) {
        switch (elementType) {
            case VERTEX: {
                return this.getVerticesTableName();
            }
            case EDGE: {
                return this.getEdgesTableName();
            }
        }
        throw new GeException("Unexpected element type: " + (Object)((Object)elementType));
    }

    public String getHistoryTableNameFromElementType(ElementType elementType) {
        switch (elementType) {
            case VERTEX: {
                return this.getHistoryVerticesTableName();
            }
            case EDGE: {
                return this.getHistoryEdgesTableName();
            }
        }
        throw new GeException("Unexpected element type: " + (Object)((Object)elementType));
    }

    public StreamingPropertyValueStorageStrategy getStreamingPropertyValueStorageStrategy() {
        return this.streamingPropertyValueStorageStrategy;
    }

    @Override
    public NameSubstitutionStrategy getNameSubstitutionStrategy() {
        return this.nameSubstitutionStrategy;
    }

    @Override
    public GeSerializer getGeSerializer() {
        return this.geSerializer;
    }

    private class DeleteElementsConsumer
    implements Consumer<ElementId> {
        private final Authorizations authorizations;
        private final Set<String> verticesToFetch = new HashSet<String>();
        private final Set<String> edgesToFetch = new HashSet<String>();
        private final Set<Vertex> verticesToDelete = new HashSet<Vertex>();
        private final Set<EdgeElementLocation> edgesToDelete = new HashSet<EdgeElementLocation>();

        public DeleteElementsConsumer(Authorizations authorizations) {
            this.authorizations = authorizations;
        }

        @Override
        public void accept(ElementId elementId) {
            if (elementId instanceof Vertex) {
                this.verticesToDelete.add((Vertex)elementId);
            } else if (elementId instanceof EdgeElementLocation) {
                this.edgesToDelete.add((EdgeElementLocation)elementId);
            } else if (elementId.getElementType() == ElementType.VERTEX) {
                this.verticesToFetch.add(elementId.getId());
            } else if (elementId.getElementType() == ElementType.EDGE) {
                this.edgesToFetch.add(elementId.getId());
            } else {
                throw new GeException("unhandled element type: " + (Object)((Object)elementId.getElementType()));
            }
            this.processBatches(false);
        }

        public void processBatches(boolean finalBatch) {
            if (finalBatch || this.verticesToFetch.size() > 100) {
                this.verticesToDelete.addAll(IterableUtils.toList(AbstractStorableGraph.this.getVertices(this.verticesToFetch, FetchHints.EDGE_REFS, this.authorizations)));
                this.verticesToFetch.clear();
            }
            if (finalBatch || this.verticesToDelete.size() > 100) {
                for (Vertex vertexToDelete : this.verticesToDelete) {
                    this.edgesToFetch.addAll(IterableUtils.toList(vertexToDelete.getEdgeIds(Direction.BOTH, this.authorizations)));
                }
                this.deleteVertices(this.verticesToDelete);
                this.verticesToDelete.clear();
            }
            if (finalBatch || this.edgesToFetch.size() > 100) {
                this.edgesToDelete.addAll(IterableUtils.toList(AbstractStorableGraph.this.getEdges(this.edgesToFetch, FetchHints.NONE, this.authorizations)));
                this.edgesToFetch.clear();
            }
            if (finalBatch || this.edgesToDelete.size() > 100) {
                this.deleteEdges(this.edgesToDelete);
                this.edgesToDelete.clear();
            }
        }

        private void deleteVertices(Set<Vertex> verticesToDelete) {
            AbstractStorableGraph.this.getSearchIndex().deleteElements(AbstractStorableGraph.this, verticesToDelete, this.authorizations);
            this.deleteAllExtendedDataForElements(verticesToDelete, this.authorizations);
            for (Vertex vertex : verticesToDelete) {
                AbstractStorableGraph.this.addMutations(GeObjectType.VERTEX, AbstractStorableGraph.this.elementMutationBuilder.getDeleteRowMutation((String)vertex.getId()));
                AbstractStorableGraph.this.queueEvent(new DeleteVertexEvent(AbstractStorableGraph.this, vertex));
                if (!AbstractStorableGraph.this.cacheEnabled) continue;
                AbstractStorableGraph.this.elementCacheService.invalidate("v", (String)vertex.getId());
            }
        }

        private void deleteEdges(Set<EdgeElementLocation> edgesToDelete) {
            AbstractStorableGraph.this.getSearchIndex().deleteElements(AbstractStorableGraph.this, edgesToDelete, this.authorizations);
            this.deleteAllExtendedDataForElements(edgesToDelete, this.authorizations);
            for (EdgeElementLocation edgeLocation : edgesToDelete) {
                ColumnVisibility visibility = ElementMutationBuilder.visibilityToColumnVisibility(edgeLocation.getVisibility());
                StoreMutation outMutation = new StoreMutation(edgeLocation.getVertexId(Direction.OUT));
                outMutation.putDelete("EOUT", edgeLocation.getId(), visibility);
                StoreMutation inMutation = new StoreMutation(edgeLocation.getVertexId(Direction.IN));
                inMutation.putDelete("EIN", edgeLocation.getId(), visibility);
                AbstractStorableGraph.this.addMutations(GeObjectType.VERTEX, outMutation, inMutation);
                AbstractStorableGraph.this.addMutations(GeObjectType.EDGE, AbstractStorableGraph.this.elementMutationBuilder.getDeleteRowMutation(edgeLocation.getId()));
                AbstractStorableGraph.this.queueEvent(new DeleteEdgeEvent(AbstractStorableGraph.this, edgeLocation));
                if (!AbstractStorableGraph.this.cacheEnabled) continue;
                AbstractStorableGraph.this.elementCacheService.invalidate("e", edgeLocation.getId());
                AbstractStorableGraph.this.elementCacheService.invalidate("v", edgeLocation.getVertexId(Direction.OUT));
                AbstractStorableGraph.this.elementCacheService.invalidate("v", edgeLocation.getVertexId(Direction.IN));
            }
        }

        private void deleteAllExtendedDataForElements(Iterable<? extends ElementId> elementIds, Authorizations authorizations) {
            FetchHints fetchHints = new FetchHintsBuilder().setIncludeExtendedDataTableNames(true).build();
            Iterable<ExtendedDataRow> rows = AbstractStorableGraph.this.getExtendedDataForElements(elementIds, fetchHints, authorizations);
            for (ExtendedDataRow row : rows) {
                AbstractStorableGraph.this.deleteExtendedDataRow(row.getId(), authorizations);
            }
        }
    }

    protected static abstract class AddEdgeToVertexRunnable {
        protected AddEdgeToVertexRunnable() {
        }

        public abstract void run(StorableEdge var1);
    }
}

