/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store;

import com.mware.ge.GeException;
import com.mware.ge.GraphMetadataEntry;
import com.mware.ge.GraphMetadataStore;
import com.mware.ge.store.AbstractStorableGraph;
import com.mware.ge.store.StorableGraphConfiguration;
import com.mware.ge.store.mutations.StoreMutation;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.util.JavaSerializableUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;

public abstract class DistributedMetadataStore
extends GraphMetadataStore {
    private final GeLogger LOGGER = GeLoggerFactory.getLogger(DistributedMetadataStore.class);
    private final String ZK_PATH_REPLACEMENT = "[^a-zA-Z]+";
    private final Pattern ZK_PATH_REPLACEMENT_PATTERN = Pattern.compile("[^a-zA-Z]+");
    private final String ZK_DEFINE_PROPERTY = "defineProperty.".replaceAll("[^a-zA-Z]+", "");
    private static final String ZK_PATH = "/ge/metadata";
    private final CuratorFramework curatorFramework;
    protected final AbstractStorableGraph graph;
    private final TreeCache treeCache;
    private final Map<String, GraphMetadataEntry> entries = Collections.synchronizedMap(new HashMap());
    private final StampedLock stampedLock = new StampedLock();

    public DistributedMetadataStore(AbstractStorableGraph graph) {
        this.graph = graph;
        StorableGraphConfiguration config = (StorableGraphConfiguration)graph.getConfiguration();
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        this.curatorFramework = CuratorFrameworkFactory.newClient((String)config.getZookeeperServers(), (RetryPolicy)retryPolicy);
        this.curatorFramework.start();
        this.treeCache = new TreeCache(this.curatorFramework, ZK_PATH);
        this.treeCache.getListenable().addListener((client, event) -> {
            if (this.LOGGER.isTraceEnabled()) {
                this.LOGGER.trace("treeCache event, clearing cache %s", event);
            }
            this.writeValues(this.entries::clear);
            if (graph.getSearchIndex() != null) {
                graph.getSearchIndex().clearCache();
            }
            this.invalidatePropertyDefinitions(event);
        });
        try {
            this.treeCache.start();
        }
        catch (Exception e) {
            throw new GeException("Could not start metadata sync", e);
        }
    }

    protected abstract void write(StoreMutation var1) throws IOException;

    protected abstract void delete(StoreMutation var1) throws IOException;

    protected abstract Iterable<GraphMetadataEntry> getAllMetadata();

    @Override
    public void close() {
        this.treeCache.close();
        this.curatorFramework.close();
    }

    @Override
    public void drop() {
        this.close();
        try {
            this.curatorFramework.delete().guaranteed().forPath(ZK_PATH);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.curatorFramework.close();
    }

    @Override
    public Iterable<GraphMetadataEntry> getMetadata() {
        if (this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace("getMetadata", new Object[0]);
        }
        return this.readValues(() -> new ArrayList<GraphMetadataEntry>(this.entries.values()));
    }

    private void ensureMetadataLoaded() {
        if (this.entries.size() > 0) {
            return;
        }
        if (this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace("metadata is stale... loading", new Object[0]);
        }
        Iterable<GraphMetadataEntry> metadata = this.getAllMetadata();
        for (GraphMetadataEntry graphMetadataEntry : metadata) {
            this.entries.put(graphMetadataEntry.getKey(), graphMetadataEntry);
        }
    }

    @Override
    public void reloadMetadata() {
        this.LOGGER.trace("forcing immediate reload of metadata", new Object[0]);
        this.writeValues(() -> {
            this.entries.clear();
            this.ensureMetadataLoaded();
        });
    }

    @Override
    public void setMetadata(String key, Object value) {
        if (this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace("setMetadata: %s = %s", key, value);
        }
        try {
            StoreMutation m = new StoreMutation(key);
            byte[] valueBytes = JavaSerializableUtils.objectToBytes(value);
            m.put("", "", valueBytes);
            this.write(m);
            this.graph.flush();
        }
        catch (IOException ex) {
            throw new GeException("Could not add metadata " + key, ex);
        }
        this.writeValues(() -> {
            this.entries.clear();
            try {
                this.signalMetadataChange(key);
            }
            catch (Exception e) {
                this.LOGGER.error("Could not notify other nodes via ZooKeeper", e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetadata(String key) {
        if (this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace("deleteMetadata: %s", key);
        }
        try {
            StoreMutation m = new StoreMutation(key);
            m.putDelete("", "");
            this.delete(m);
            this.graph.flush();
        }
        catch (IOException ex) {
            throw new GeException("Could not add metadata " + key, ex);
        }
        Map<String, GraphMetadataEntry> map = this.entries;
        synchronized (map) {
            this.entries.clear();
            try {
                this.signalMetadataChange(key);
            }
            catch (Exception e) {
                this.LOGGER.error("Could not notify other nodes via ZooKeeper", e);
            }
        }
    }

    private void invalidatePropertyDefinitions(TreeCacheEvent event) {
        if (event == null || event.getData() == null) {
            return;
        }
        String path = event.getData().getPath();
        byte[] bytes = event.getData().getData();
        if (path == null || bytes == null) {
            return;
        }
        if (!path.startsWith("/ge/metadata/" + this.ZK_DEFINE_PROPERTY)) {
            return;
        }
        String key = new String(bytes, StandardCharsets.UTF_8);
        if (key == null) {
            return;
        }
        String propertyName = key.substring("defineProperty.".length());
        this.LOGGER.debug("invalidating property definition: %s", propertyName);
        this.graph.invalidatePropertyDefinition(propertyName);
    }

    private void signalMetadataChange(String key) throws Exception {
        String path = "/ge/metadata/" + this.ZK_PATH_REPLACEMENT_PATTERN.matcher(key).replaceAll("_");
        this.LOGGER.debug("signaling change to metadata via path: %s", path);
        byte[] data = key.getBytes(StandardCharsets.UTF_8);
        ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(path, data);
    }

    @Override
    public Object getMetadata(String key) {
        return this.readValues(() -> {
            GraphMetadataEntry e = this.entries.get(key);
            return e != null ? e.getValue() : null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T readValues(Supplier<T> reader) {
        T result = null;
        long stamp = this.stampedLock.tryOptimisticRead();
        if (this.entries.size() > 0) {
            result = reader.get();
        } else {
            stamp = 0L;
        }
        if (!this.stampedLock.validate(stamp)) {
            stamp = this.stampedLock.writeLock();
            try {
                this.ensureMetadataLoaded();
                result = reader.get();
            }
            finally {
                this.stampedLock.unlockWrite(stamp);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeValues(Runnable writer) {
        long stamp = this.stampedLock.writeLock();
        try {
            writer.run();
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
    }
}

