/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store;

import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.GraphConfiguration;
import com.mware.ge.Property;
import com.mware.ge.store.StorableGraph;
import com.mware.ge.store.StorableGraphConfiguration;
import com.mware.ge.store.StreamingPropertyValueFileRef;
import com.mware.ge.store.mutations.ElementMutationBuilder;
import com.mware.ge.store.util.StreamingPropertyValueStorageStrategy;
import com.mware.ge.util.IOUtils;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.StreamingPropertyValueRef;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;

public class FilesystemSPVStorageStrategy
implements StreamingPropertyValueStorageStrategy {
    private final StorableGraph graph;
    private final Path dataFolder;

    public FilesystemSPVStorageStrategy(Graph graph, GraphConfiguration configuration) {
        if (!(configuration instanceof StorableGraphConfiguration)) {
            throw new GeException("Expected " + StorableGraphConfiguration.class.getName() + " found " + configuration.getClass().getName());
        }
        if (!(graph instanceof StorableGraph)) {
            throw new GeException("Expected " + StorableGraph.class.getName() + " found " + graph.getClass().getName());
        }
        this.graph = (StorableGraph)graph;
        this.dataFolder = ((StorableGraphConfiguration)configuration).createSPVFolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamingPropertyValueRef saveStreamingPropertyValue(ElementMutationBuilder elementMutationBuilder, String rowKey, Property property, StreamingPropertyValue streamingPropertyValue) {
        try {
            File filePath = this.createFile(rowKey, property);
            try (FileOutputStream out = new FileOutputStream(filePath);){
                IOUtils.copy(streamingPropertyValue.getInputStream(), out);
            }
            return new StreamingPropertyValueFileRef(filePath, streamingPropertyValue);
        }
        catch (IOException ex) {
            throw new GeException(ex);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public List<InputStream> getInputStreams(List<StreamingPropertyValue> streamingPropertyValues) {
        return streamingPropertyValues.stream().map(StreamingPropertyValue::getInputStream).collect(Collectors.toList());
    }

    protected File createFile(String rowKey, Property property) {
        String relativeFileName = this.createFileName(rowKey, property);
        Path path = Paths.get(this.dataFolder.toString(), relativeFileName);
        try {
            if (!path.getParent().toFile().exists()) {
                Files.createDirectory(path.getParent(), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new GeException(String.format("Could not create SPV folder for rowkey=%s, property=%s", rowKey, property), e);
        }
        if (path.toFile().exists()) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                throw new GeException(String.format("Could not delete SPV folder for rowkey=%s, property=%s", rowKey, property), e);
            }
        }
        return path.toFile();
    }

    private String createFileName(String rowKey, Property property) {
        String fileName = FilesystemSPVStorageStrategy.encodeFileName(property.getName() + "_" + property.getKey() + "_" + property.getTimestamp());
        return rowKey + File.separator + fileName;
    }

    private static String encodeFileName(String fileName) {
        StringBuilder result = new StringBuilder();
        for (char ch : fileName.toCharArray()) {
            if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') {
                result.append(ch);
                continue;
            }
            if (ch == ' ') {
                result.append('_');
                continue;
            }
            String hex = "0000" + Integer.toHexString(ch);
            result.append(hex.substring(hex.length() - 4));
        }
        return result.toString();
    }
}

