/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store;

import com.google.common.collect.ImmutableSet;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ExistingEdgeMutation;
import com.mware.ge.mutation.PropertyDeleteMutation;
import com.mware.ge.mutation.PropertySoftDeleteMutation;
import com.mware.ge.store.StorableElement;
import com.mware.ge.store.StorableGraph;

public class StorableEdge
extends StorableElement
implements Edge {
    public static final String CF_SIGNAL = "E";
    public static final String CF_OUT_VERTEX = "EOUT";
    public static final String CF_IN_VERTEX = "EIN";
    protected String outVertexId;
    protected String inVertexId;
    protected String label;
    protected String newEdgeLabel;

    public StorableEdge(StorableGraph graph, String id, String outVertexId, String inVertexId, String label, String newEdgeLabel, Visibility visibility, Iterable<Property> properties, Iterable<PropertyDeleteMutation> propertyDeleteMutations, Iterable<PropertySoftDeleteMutation> propertySoftDeleteMutations, Iterable<Visibility> hiddenVisibilities, ImmutableSet<String> extendedDataTableNames, long timestamp, FetchHints fetchHints, Authorizations authorizations) {
        super(graph, id, visibility, properties, propertyDeleteMutations, propertySoftDeleteMutations, hiddenVisibilities, extendedDataTableNames, timestamp, fetchHints, authorizations);
        this.outVertexId = outVertexId;
        this.inVertexId = inVertexId;
        this.label = label;
        this.newEdgeLabel = newEdgeLabel;
    }

    public String getNewEdgeLabel() {
        return this.newEdgeLabel;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getVertexId(Direction direction) {
        switch (direction) {
            case OUT: {
                return this.outVertexId;
            }
            case IN: {
                return this.inVertexId;
            }
        }
        throw new IllegalArgumentException("Unexpected direction: " + (Object)((Object)direction));
    }

    @Override
    public Vertex getVertex(Direction direction, Authorizations authorizations) {
        return this.getVertex(direction, this.getGraph().getDefaultFetchHints(), authorizations);
    }

    @Override
    public String getOtherVertexId(String myVertexId) {
        if (this.inVertexId.equals(myVertexId)) {
            return this.outVertexId;
        }
        if (this.outVertexId.equals(myVertexId)) {
            return this.inVertexId;
        }
        throw new GeException("myVertexId(" + myVertexId + ") does not appear on edge (" + this.getId() + ") in either the in (" + this.inVertexId + ") or the out (" + this.outVertexId + ").");
    }

    @Override
    public ExistingEdgeMutation prepareMutation() {
        return new ExistingEdgeMutation(this){

            @Override
            public Edge save(Authorizations authorizations) {
                StorableEdge.this.saveExistingElementMutation(this, authorizations);
                return (Edge)this.getElement();
            }
        };
    }

    protected void setLabel(String label) {
        this.label = label;
    }
}

