/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.ElementBase;
import com.mware.ge.ElementType;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.GeMissingFetchHintException;
import com.mware.ge.HasTimestamp;
import com.mware.ge.HistoricalPropertyValue;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.EdgeMutation;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.mutation.PropertyDeleteMutation;
import com.mware.ge.mutation.PropertySoftDeleteMutation;
import com.mware.ge.mutation.VertexMutation;
import com.mware.ge.property.MutableProperty;
import com.mware.ge.query.ExtendedDataQueryableIterable;
import com.mware.ge.query.QueryableIterable;
import com.mware.ge.search.IndexHint;
import com.mware.ge.store.StorableEdge;
import com.mware.ge.store.StorableGraph;
import com.mware.ge.store.StorableMetadataEntry;
import com.mware.ge.store.StorablePropertyEntry;
import com.mware.ge.store.StorableVertex;
import com.mware.ge.store.util.HiddenProperty;
import com.mware.ge.store.util.SoftDeletedProperty;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.PropertyCollection;
import com.mware.ge.values.storable.Value;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public abstract class StorableElement
extends ElementBase
implements Serializable,
HasTimestamp {
    public static final String CF_PROPERTY = "PROP";
    public static final String CF_PROPERTY_METADATA = "PROPMETA";
    public static final String CF_PROPERTY_SOFT_DELETE = "PROPD";
    public static final String CF_EXTENDED_DATA = "EXTDATA";
    public static final String CF_PROPERTY_HIDDEN = "PROPH";
    public static final String CF_PROPERTY_VISIBLE = "PROPV";
    public static final String CF_HIDDEN = "H";
    public static final String CF_SOFT_DELETE = "D";
    public static final String METADATA_COLUMN_FAMILY = "";
    public static final String METADATA_COLUMN_QUALIFIER = "";
    public static final String DELETE_ROW_COLUMN_FAMILY = "";
    public static final String DELETE_ROW_COLUMN_QUALIFIER = "";
    public static final String CQ_SOFT_DELETE = "D";
    public static final String CQ_HIDDEN = "H";
    public static final byte[] SOFT_DELETE_VALUE = "".getBytes();
    public static final byte[] HIDDEN_VALUE = "".getBytes();
    public static final byte[] HIDDEN_VALUE_DELETED = "X".getBytes();
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(StorableElement.class);
    protected StorableGraph graph;
    protected String id;
    protected Visibility visibility;
    protected long timestamp = 0L;
    protected long softDeleteTimestamp = 0L;
    protected FetchHints fetchHints;
    protected Set<Visibility> hiddenVisibilities;
    protected PropertyCollection properties = new PropertyCollection();
    protected ImmutableSet<String> extendedDataTableNames;
    protected ConcurrentSkipListSet<PropertyDeleteMutation> propertyDeleteMutations;
    protected ConcurrentSkipListSet<PropertySoftDeleteMutation> propertySoftDeleteMutations;
    protected Authorizations authorizations;
    protected List<SoftDeletedProperty> softDeletedProperties = new ArrayList<SoftDeletedProperty>();
    protected List<HiddenProperty> hiddenPropertyMarkers = new ArrayList<HiddenProperty>();
    protected List<HiddenProperty> visiblePropertyMarkers = new ArrayList<HiddenProperty>();
    protected Set<StorablePropertyEntry> storableProperties = new HashSet<StorablePropertyEntry>();
    protected Set<StorableMetadataEntry> storablePropertyMetadatas = new HashSet<StorableMetadataEntry>();

    protected StorableElement(StorableGraph graph, String id, Visibility visibility, Iterable<Property> properties, Iterable<PropertyDeleteMutation> propertyDeleteMutations, Iterable<PropertySoftDeleteMutation> propertySoftDeleteMutations, Iterable<Visibility> hiddenVisibilities, ImmutableSet<String> extendedDataTableNames, long timestamp, FetchHints fetchHints, Authorizations authorizations) {
        this.graph = graph;
        this.id = id;
        this.visibility = visibility;
        this.timestamp = timestamp;
        this.fetchHints = fetchHints;
        this.properties = new PropertyCollection();
        this.extendedDataTableNames = extendedDataTableNames;
        this.authorizations = authorizations;
        this.hiddenVisibilities = hiddenVisibilities == null ? new HashSet() : IterableUtils.toSet(hiddenVisibilities);
        this.updatePropertiesInternal(properties, propertyDeleteMutations, propertySoftDeleteMutations);
    }

    @Override
    public void deleteProperty(String key, String name, Visibility visibility, Authorizations authorizations) {
        Property property = this.getProperty(key, name, visibility);
        if (property != null) {
            this.properties.removeProperty(property);
            this.getGraph().deleteProperty(this, property, authorizations);
        }
    }

    @Override
    public void softDeleteProperty(String key, String name, Visibility visibility, Authorizations authorizations) {
        Property property = this.getProperty(key, name, visibility);
        if (property != null) {
            this.properties.removeProperty(property);
            this.getGraph().softDeleteProperty(this, property, authorizations);
        }
    }

    public void softDeleteProperties(Authorizations authorizations) {
        List<Property> propertyList = IterableUtils.toList(this.getProperties());
        propertyList.forEach(p -> this.properties.removeProperty((Property)p));
        this.getGraph().softDeleteProperties(propertyList, this, authorizations);
    }

    @Override
    public void markPropertyHidden(Property property, Long timestamp, Visibility visibility, Authorizations authorizations) {
        this.getGraph().markPropertyHidden(this, property, timestamp, visibility, authorizations);
    }

    @Override
    public void markPropertyVisible(Property property, Long timestamp, Visibility visibility, Authorizations authorizations) {
        this.getGraph().markPropertyVisible(this, property, timestamp, visibility, authorizations);
    }

    protected <TElement extends Element> void saveExistingElementMutation(ExistingElementMutation<TElement> mutation, Authorizations authorizations) {
        VertexMutation vertexMutation;
        String newConceptType;
        EdgeMutation edgeMutation;
        String newEdgeLabel;
        StorableElement element = (StorableElement)mutation.getElement();
        this.getGraph().alterPropertyMetadatas(element, mutation.getSetPropertyMetadatas());
        this.getGraph().alterElementPropertyVisibilities(element, mutation.getAlterPropertyVisibilities());
        Iterable<PropertyDeleteMutation> propertyDeletes = mutation.getPropertyDeletes();
        Iterable<PropertySoftDeleteMutation> propertySoftDeletes = mutation.getPropertySoftDeletes();
        Iterable<Property> properties = mutation.getProperties();
        this.updatePropertiesInternal(properties, propertyDeletes, propertySoftDeletes);
        this.getGraph().saveProperties(element, properties, propertyDeletes, propertySoftDeletes);
        if (mutation.getNewElementVisibility() != null) {
            this.getGraph().alterElementVisibility(element, mutation.getNewElementVisibility(), authorizations);
        }
        if (mutation instanceof EdgeMutation && (newEdgeLabel = (edgeMutation = (EdgeMutation)((Object)mutation)).getNewEdgeLabel()) != null) {
            this.getGraph().alterEdgeLabel((StorableEdge)mutation.getElement(), newEdgeLabel, authorizations);
        }
        if (mutation instanceof VertexMutation && (newConceptType = (vertexMutation = (VertexMutation)((Object)mutation)).getNewConceptType()) != null) {
            this.getGraph().alterConceptType((StorableVertex)mutation.getElement(), newConceptType);
        }
        if (mutation.getIndexHint() != IndexHint.DO_NOT_INDEX) {
            this.getGraph().getSearchIndex().updateElement(this.graph, mutation, authorizations);
        }
        ElementType elementType = ElementType.getTypeFromElement(mutation.getElement());
        this.getGraph().saveExtendedDataMutations((Element)mutation.getElement(), elementType, mutation.getIndexHint(), mutation.getExtendedData(), mutation.getExtendedDataDeletes(), authorizations);
        this.getGraph().invalidateElementFromCache(elementType, element.id);
    }

    @Override
    public Iterable<HistoricalPropertyValue> getHistoricalPropertyValues(String key, String name, Visibility visibility, Long startTime, Long endTime, Authorizations authorizations) {
        return this.getGraph().getHistoricalPropertyValues(this, key, name, visibility, startTime, endTime, authorizations);
    }

    @Override
    public abstract <T extends Element> ExistingElementMutation<T> prepareMutation();

    @Override
    public QueryableIterable<ExtendedDataRow> getExtendedData(String tableName, FetchHints fetchHints) {
        return new ExtendedDataQueryableIterable(this.getGraph(), this, tableName, this.getGraph().getExtendedData(ElementType.getTypeFromElement(this), this.getId(), tableName, fetchHints, this.getAuthorizations()));
    }

    @Override
    public Property getProperty(String key, String name) {
        return this.getProperty(key, name, null);
    }

    @Override
    public Value getPropertyValue(String name, int index) {
        return this.getPropertyValue(null, name, index);
    }

    @Override
    public Value getPropertyValue(String key, String name, int index) {
        Property reservedProperty = this.getReservedProperty(name);
        if (reservedProperty != null) {
            return reservedProperty.getValue();
        }
        Property property = this.properties.getProperty(key, name, index);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public Iterable<Property> getProperties() {
        if (!this.getFetchHints().isIncludeProperties()) {
            throw new GeMissingFetchHintException(this.getFetchHints(), "includeProperties");
        }
        return this.properties.getProperties();
    }

    public Iterable<PropertyDeleteMutation> getPropertyDeleteMutations() {
        return this.propertyDeleteMutations;
    }

    public Iterable<PropertySoftDeleteMutation> getPropertySoftDeleteMutations() {
        return this.propertySoftDeleteMutations;
    }

    @Override
    public Iterable<Property> getProperties(String key, String name) {
        Property reservedProperty = this.getReservedProperty(name);
        if (reservedProperty != null) {
            return Lists.newArrayList((Object[])new Property[]{reservedProperty});
        }
        this.getFetchHints().assertPropertyIncluded(name);
        return this.properties.getProperties(key, name);
    }

    @Override
    public StorableGraph getGraph() {
        return this.graph;
    }

    protected void updatePropertiesInternal(Iterable<Property> properties, Iterable<PropertyDeleteMutation> propertyDeleteMutations, Iterable<PropertySoftDeleteMutation> propertySoftDeleteMutations) {
        if (propertyDeleteMutations != null) {
            this.propertyDeleteMutations = new ConcurrentSkipListSet();
            for (PropertyDeleteMutation propertyDeleteMutation : propertyDeleteMutations) {
                this.removePropertyInternal(propertyDeleteMutation.getKey(), propertyDeleteMutation.getName(), propertyDeleteMutation.getVisibility());
                this.propertyDeleteMutations.add(propertyDeleteMutation);
            }
        }
        if (propertySoftDeleteMutations != null) {
            this.propertySoftDeleteMutations = new ConcurrentSkipListSet();
            for (PropertySoftDeleteMutation propertySoftDeleteMutation : propertySoftDeleteMutations) {
                this.removePropertyInternal(propertySoftDeleteMutation.getKey(), propertySoftDeleteMutation.getName(), propertySoftDeleteMutation.getVisibility());
                this.propertySoftDeleteMutations.add(propertySoftDeleteMutation);
            }
        }
        for (Property property : properties) {
            this.addPropertyInternal(property);
        }
    }

    protected void removePropertyInternal(String key, String name, Visibility visibility) {
        Property property = this.getProperty(key, name, visibility);
        if (property != null) {
            this.properties.removeProperty(property);
        }
    }

    public void addPropertyInternal(Property property) {
        if (property.getKey() == null) {
            throw new IllegalArgumentException("key is required for property");
        }
        Property existingProperty = this.getProperty(property.getKey(), property.getName(), property.getVisibility());
        if (existingProperty == null) {
            this.properties.addProperty(property);
        } else if (existingProperty instanceof MutableProperty) {
            ((MutableProperty)existingProperty).update(property);
        } else {
            throw new GeException("Could not update property of type: " + existingProperty.getClass().getName());
        }
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public String toString() {
        if (this instanceof Edge) {
            Edge edge = (Edge)((Object)this);
            return this.getId() + ":[" + edge.getVertexId(Direction.OUT) + "-" + edge.getLabel() + "->" + edge.getVertexId(Direction.IN) + "]";
        }
        return this.getId();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Element) {
            Element objElem = (Element)obj;
            return this.getId().equals(objElem.getId());
        }
        return super.equals(obj);
    }

    @Override
    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    @Override
    public Iterable<Visibility> getHiddenVisibilities() {
        return this.hiddenVisibilities;
    }

    @Override
    public ImmutableSet<String> getExtendedDataTableNames() {
        if (!this.getFetchHints().isIncludeExtendedDataTableNames()) {
            throw new GeMissingFetchHintException(this.getFetchHints(), "includeExtendedDataTableNames");
        }
        return this.extendedDataTableNames;
    }

    @Override
    public FetchHints getFetchHints() {
        return this.fetchHints;
    }

    @Override
    protected Iterable<Property> internalGetProperties(String key, String name) {
        this.getFetchHints().assertPropertyIncluded(name);
        return this.properties.getProperties(key, name);
    }
}

