/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store;

import com.mware.ge.Authorizations;
import com.mware.ge.ExtendedDataRowBase;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.FetchHints;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.values.storable.Value;
import java.util.ArrayList;
import java.util.Set;

public class StorableExtendedDataRow
extends ExtendedDataRowBase {
    private final ExtendedDataRowId rowId;
    private final Set<Property> properties;

    public StorableExtendedDataRow(ExtendedDataRowId rowId, Set<Property> properties, FetchHints fetchHints) {
        super(fetchHints);
        this.rowId = rowId;
        this.properties = properties;
    }

    @Override
    public ExtendedDataRowId getId() {
        return this.rowId;
    }

    @Override
    public Iterable<Property> getProperties() {
        return this.properties;
    }

    public static class StorableExtendedDataRowProperty
    extends Property {
        private final String propertyName;
        private final String propertyKey;
        private final Value propertyValue;
        private final FetchHints fetchHints;
        private final long timestamp;
        private final Visibility visibility;

        public StorableExtendedDataRowProperty(String propertyName, String propertyKey, Value propertyValue, FetchHints fetchHints, long timestamp, Visibility visibility) {
            this.propertyName = propertyName;
            this.propertyKey = propertyKey;
            this.propertyValue = propertyValue;
            this.fetchHints = fetchHints;
            this.timestamp = timestamp;
            this.visibility = visibility;
        }

        @Override
        public String getKey() {
            return this.propertyKey;
        }

        @Override
        public String getName() {
            return this.propertyName;
        }

        @Override
        public Value getValue() {
            return this.propertyValue;
        }

        @Override
        public Long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }

        @Override
        public Metadata getMetadata() {
            return Metadata.create(this.fetchHints);
        }

        @Override
        public FetchHints getFetchHints() {
            return this.fetchHints;
        }

        @Override
        public Iterable<Visibility> getHiddenVisibilities() {
            return new ArrayList<Visibility>();
        }

        @Override
        public boolean isHidden(Authorizations authorizations) {
            return false;
        }
    }
}

