/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store;

import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.GraphConfiguration;
import com.mware.ge.serializer.GeSerializer;
import com.mware.ge.store.FilesystemSPVStorageStrategy;
import com.mware.ge.store.util.StreamingPropertyValueStorageStrategy;
import com.mware.ge.util.ConfigurationUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

public abstract class StorableGraphConfiguration
extends GraphConfiguration {
    public static final String STREAMING_PROPERTY_VALUE_STORAGE_STRATEGY_PREFIX = "streamingPropertyValueStorageStrategy";
    public static final String DEFAULT_STREAMING_PROPERTY_VALUE_STORAGE_STRATEGY = FilesystemSPVStorageStrategy.class.getName();
    public static final String ELEMENT_CACHE_ENABLED = "elementCacheEnabled";
    public static final String ELEMENT_CACHE_SIZE = "elementCacheSize";
    public static final String HISTORY_IN_SEPARATE_TABLE = "historyInSeparateTable";
    public static final String ZOOKEEPER_SERVERS = "zookeeperServers";
    public static final String STREAMING_PROPERTY_VALUE_DATA_FOLDER = "spvFolder";
    public static final String DEFAULT_STREAMING_PROPERTY_VALUE_DATA_FOLDER = "/data";
    public static final boolean DEFAULT_ELEMENT_CACHE_ENABLED = false;
    public static final int DEFAULT_ELEMENT_CACHE_SIZE = 1000000;
    public static final boolean DEFAULT_HISTORY_IN_SEPARATE_TABLE = false;
    public static final String DEFAULT_ZOOKEEPER_SERVERS = "localhost";
    protected final GeSerializer serializer = this.createSerializer();

    public StorableGraphConfiguration(Map<String, Object> config) {
        super(config);
    }

    public GeSerializer getSerializer() {
        return this.serializer;
    }

    public StreamingPropertyValueStorageStrategy createStreamingPropertyValueStorageStrategy(Graph graph) {
        return (StreamingPropertyValueStorageStrategy)ConfigurationUtils.createProvider(graph, this, STREAMING_PROPERTY_VALUE_STORAGE_STRATEGY_PREFIX, DEFAULT_STREAMING_PROPERTY_VALUE_STORAGE_STRATEGY);
    }

    public Path createSPVFolder() {
        String folderPath = this.getString(STREAMING_PROPERTY_VALUE_DATA_FOLDER, DEFAULT_STREAMING_PROPERTY_VALUE_DATA_FOLDER);
        Path path = Paths.get(folderPath, new String[0]);
        if (!path.toFile().exists()) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new GeException(String.format("Could not create SPV storage folder: %s", folderPath), e);
            }
        }
        return path;
    }

    public boolean isElementCacheEnabled() {
        return this.getBoolean(ELEMENT_CACHE_ENABLED, false);
    }

    public int getElementCacheSize() {
        return this.getInteger(ELEMENT_CACHE_SIZE, 1000000);
    }

    public boolean isHistoryInSeparateTable() {
        return this.getBoolean(HISTORY_IN_SEPARATE_TABLE, false);
    }

    public String getZookeeperServers() {
        return this.getString(ZOOKEEPER_SERVERS, DEFAULT_ZOOKEEPER_SERVERS);
    }
}

