/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store;

import com.google.common.collect.ImmutableSet;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.EdgeInfo;
import com.mware.ge.EdgesSummary;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.GeMissingFetchHintException;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ExistingVertexMutation;
import com.mware.ge.mutation.PropertyDeleteMutation;
import com.mware.ge.mutation.PropertySoftDeleteMutation;
import com.mware.ge.query.VertexQuery;
import com.mware.ge.store.Edges;
import com.mware.ge.store.EdgesWithCount;
import com.mware.ge.store.EdgesWithEdgeInfo;
import com.mware.ge.store.StorableEdgeInfo;
import com.mware.ge.store.StorableElement;
import com.mware.ge.store.StorableGraph;
import com.mware.ge.store.util.GetVertexIdsIterable;
import com.mware.ge.store.util.SoftDeleteEdgeInfo;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.FilterIterable;
import com.mware.ge.util.JoinIterable;
import com.mware.ge.util.LookAheadIterable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StorableVertex
extends StorableElement
implements Vertex {
    public static final String CF_SIGNAL = "V";
    public static final String CF_OUT_EDGE = "EOUT";
    public static final String CF_IN_EDGE = "EIN";
    public static final String CF_OUT_EDGE_SOFT_DELETE = "EOUTD";
    public static final String CF_IN_EDGE_SOFT_DELETE = "EIND";
    public static final String CF_OUT_EDGE_HIDDEN = "EOUTH";
    public static final String CF_IN_EDGE_HIDDEN = "EINH";
    private final Edges inEdges;
    private final Edges outEdges;
    private List<SoftDeleteEdgeInfo> outSoftDeletes = new ArrayList<SoftDeleteEdgeInfo>();
    private List<SoftDeleteEdgeInfo> inSoftDeletes = new ArrayList<SoftDeleteEdgeInfo>();
    private Set<String> hiddenEdges = new HashSet<String>();
    private String conceptType;
    private String newConceptType;

    public StorableVertex(StorableGraph graph, String vertexId, String conceptType, String newConceptType, Visibility vertexVisibility, Iterable<Property> properties, Iterable<PropertyDeleteMutation> propertyDeleteMutations, Iterable<PropertySoftDeleteMutation> propertySoftDeleteMutations, Iterable<Visibility> hiddenVisibilities, ImmutableSet<String> extendedDataTableNames, long timestamp, FetchHints fetchHints, Authorizations authorizations) {
        this(graph, vertexId, conceptType, newConceptType, vertexVisibility, properties, propertyDeleteMutations, propertySoftDeleteMutations, hiddenVisibilities, extendedDataTableNames, (Edges)new EdgesWithEdgeInfo(), (Edges)new EdgesWithEdgeInfo(), timestamp, fetchHints, authorizations);
    }

    public StorableVertex(StorableGraph graph, String vertexId, String conceptType, String newConceptType, Visibility vertexVisibility, Iterable<Property> properties, Iterable<PropertyDeleteMutation> propertyDeleteMutations, Iterable<PropertySoftDeleteMutation> propertySoftDeleteMutations, Iterable<Visibility> hiddenVisibilities, ImmutableSet<String> extendedDataTableNames, Edges inEdges, Edges outEdges, long timestamp, FetchHints fetchHints, Authorizations authorizations) {
        super(graph, vertexId, vertexVisibility, properties, propertyDeleteMutations, propertySoftDeleteMutations, hiddenVisibilities, extendedDataTableNames, timestamp, fetchHints, authorizations);
        this.inEdges = inEdges;
        this.outEdges = outEdges;
        this.conceptType = conceptType;
        this.newConceptType = newConceptType;
    }

    @Override
    public Iterable<Edge> getEdges(Direction direction, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        this.getFetchHints().validateHasEdgeFetchHints(direction, new String[0]);
        return this.getGraph().getEdges(this.getEdgeIds(direction, authorizations), fetchHints, endTime, authorizations);
    }

    @Override
    public Iterable<String> getEdgeIds(Direction direction, Authorizations authorizations) {
        this.getFetchHints().validateHasEdgeFetchHints(direction, new String[0]);
        return this.getEdgeIdsWithOtherVertexId(null, direction, null, authorizations);
    }

    @Override
    public Iterable<Edge> getEdges(Direction direction, String label, FetchHints fetchHints, Authorizations authorizations) {
        this.getFetchHints().validateHasEdgeFetchHints(direction, label);
        return this.getGraph().getEdges(this.getEdgeIds(direction, StorableVertex.labelToArrayOrNull(label), authorizations), fetchHints, authorizations);
    }

    @Override
    public Iterable<String> getEdgeIds(Direction direction, String label, Authorizations authorizations) {
        this.getFetchHints().validateHasEdgeFetchHints(direction, label);
        return this.getEdgeIdsWithOtherVertexId(null, direction, StorableVertex.labelToArrayOrNull(label), authorizations);
    }

    @Override
    public Iterable<Edge> getEdges(Direction direction, String[] labels, FetchHints fetchHints, Authorizations authorizations) {
        this.getFetchHints().validateHasEdgeFetchHints(direction, labels);
        return this.getGraph().getEdges(this.getEdgeIdsWithOtherVertexId(null, direction, labels, authorizations), fetchHints, authorizations);
    }

    @Override
    public Iterable<String> getEdgeIds(Direction direction, String[] labels, Authorizations authorizations) {
        this.getFetchHints().validateHasEdgeFetchHints(direction, labels);
        return this.getEdgeIdsWithOtherVertexId(null, direction, labels, authorizations);
    }

    @Override
    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, FetchHints fetchHints, Authorizations authorizations) {
        this.getFetchHints().validateHasEdgeFetchHints(direction, new String[0]);
        return this.getGraph().getEdges(this.getEdgeIdsWithOtherVertexId((String)otherVertex.getId(), direction, null, authorizations), fetchHints, authorizations);
    }

    @Override
    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, Authorizations authorizations) {
        this.getFetchHints().validateHasEdgeFetchHints(direction, new String[0]);
        return this.getEdgeIdsWithOtherVertexId((String)otherVertex.getId(), direction, null, authorizations);
    }

    @Override
    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, String label, FetchHints fetchHints, Authorizations authorizations) {
        this.getFetchHints().validateHasEdgeFetchHints(direction, label);
        return this.getGraph().getEdges(this.getEdgeIdsWithOtherVertexId((String)otherVertex.getId(), direction, StorableVertex.labelToArrayOrNull(label), authorizations), fetchHints, authorizations);
    }

    @Override
    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, String label, Authorizations authorizations) {
        this.getFetchHints().validateHasEdgeFetchHints(direction, label);
        return this.getEdgeIdsWithOtherVertexId((String)otherVertex.getId(), direction, StorableVertex.labelToArrayOrNull(label), authorizations);
    }

    @Override
    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, String[] labels, FetchHints fetchHints, Authorizations authorizations) {
        this.getFetchHints().validateHasEdgeFetchHints(direction, labels);
        return this.getGraph().getEdges(this.getEdgeIdsWithOtherVertexId((String)otherVertex.getId(), direction, labels, authorizations), fetchHints, authorizations);
    }

    @Override
    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, String[] labels, Authorizations authorizations) {
        this.getFetchHints().validateHasEdgeFetchHints(direction, labels);
        return this.getEdgeIdsWithOtherVertexId((String)otherVertex.getId(), direction, labels, authorizations);
    }

    @Override
    public EdgesSummary getEdgesSummary(Authorizations authorizations) {
        Integer c;
        String label;
        Object edgesWithCount;
        HashMap<String, Integer> outEdgeCountsByLabels = new HashMap<String, Integer>();
        HashMap<String, Integer> inEdgeCountsByLabels = new HashMap<String, Integer>();
        if (this.inEdges instanceof EdgesWithCount) {
            edgesWithCount = (EdgesWithCount)this.inEdges;
            inEdgeCountsByLabels.putAll(edgesWithCount.getEdgeCountsByLabelName());
        } else {
            for (Map.Entry<String, StorableEdgeInfo> entry : this.getEdgeInfos(Direction.IN)) {
                label = ((StorableEdgeInfo)entry.getValue()).getLabel();
                c = inEdgeCountsByLabels.getOrDefault(label, 0);
                inEdgeCountsByLabels.put(label, c + 1);
            }
        }
        if (this.outEdges instanceof EdgesWithCount) {
            edgesWithCount = (EdgesWithCount)this.outEdges;
            outEdgeCountsByLabels.putAll(edgesWithCount.getEdgeCountsByLabelName());
        } else {
            for (Map.Entry<String, StorableEdgeInfo> entry : this.getEdgeInfos(Direction.OUT)) {
                label = entry.getValue().getLabel();
                c = outEdgeCountsByLabels.getOrDefault(label, 0);
                outEdgeCountsByLabels.put(label, c + 1);
            }
        }
        return new EdgesSummary(outEdgeCountsByLabels, inEdgeCountsByLabels);
    }

    public Iterable<String> getEdgeIdsWithOtherVertexId(final String otherVertexId, final Direction direction, final String[] labels, Authorizations authorizations) {
        if (!this.getFetchHints().isIncludeEdgeRefs()) {
            throw new GeMissingFetchHintException(this.getFetchHints(), "includeEdgeRefs");
        }
        if (!this.getFetchHints().isIncludeEdgeIds()) {
            throw new GeMissingFetchHintException(this.getFetchHints(), "includeEdgeIds");
        }
        return new LookAheadIterable<Map.Entry<String, StorableEdgeInfo>, String>(){

            @Override
            protected boolean isIncluded(Map.Entry<String, StorableEdgeInfo> edgeInfo, String edgeId) {
                if (otherVertexId != null && !otherVertexId.equals(edgeInfo.getValue().getVertexId())) {
                    return false;
                }
                if (labels == null || labels.length == 0) {
                    return true;
                }
                for (String label : labels) {
                    if (!label.equals(edgeInfo.getValue().getLabel())) continue;
                    return true;
                }
                return false;
            }

            @Override
            protected String convert(Map.Entry<String, StorableEdgeInfo> edgeInfo) {
                return edgeInfo.getKey();
            }

            @Override
            protected Iterator<Map.Entry<String, StorableEdgeInfo>> createIterator() {
                return StorableVertex.this.getEdgeInfos(direction).iterator();
            }
        };
    }

    private Iterable<Map.Entry<String, StorableEdgeInfo>> getEdgeInfos(Direction direction) {
        if (!this.getFetchHints().isIncludeEdgeRefs()) {
            throw new GeException("getEdgeInfos called without including any edge infos");
        }
        switch (direction) {
            case IN: {
                if (!this.getFetchHints().isIncludeInEdgeRefs() && !this.getFetchHints().hasEdgeLabelsOfEdgeRefsToInclude()) {
                    return null;
                }
                if (this.inEdges instanceof EdgesWithEdgeInfo) {
                    return ((EdgesWithEdgeInfo)this.inEdges).getEntries();
                }
                throw new GeException("Cannot get edge info");
            }
            case OUT: {
                if (!this.getFetchHints().isIncludeOutEdgeRefs() && !this.getFetchHints().hasEdgeLabelsOfEdgeRefsToInclude()) {
                    return null;
                }
                if (this.outEdges instanceof EdgesWithEdgeInfo) {
                    return ((EdgesWithEdgeInfo)this.outEdges).getEntries();
                }
                throw new GeException("Cannot get edge info");
            }
            case BOTH: {
                return new JoinIterable<Map.Entry<String, StorableEdgeInfo>>(this.getEdgeInfos(Direction.IN), this.getEdgeInfos(Direction.OUT));
            }
        }
        throw new GeException("Unexpected direction: " + (Object)((Object)direction));
    }

    @Override
    public Iterable<EdgeInfo> getEdgeInfos(Direction direction, String[] labels, Authorizations authorizations) {
        if (!this.getFetchHints().isIncludeEdgeRefs()) {
            throw new GeException("getEdgeInfos called without including any edge infos");
        }
        switch (direction) {
            case IN: {
                return this.filterEdgeInfosByLabel(this.storableEdgeInfosToEdgeInfos(this.getEdgeInfos(direction), Direction.IN), labels);
            }
            case OUT: {
                return this.filterEdgeInfosByLabel(this.storableEdgeInfosToEdgeInfos(this.getEdgeInfos(direction), Direction.OUT), labels);
            }
            case BOTH: {
                return new JoinIterable<EdgeInfo>(this.getEdgeInfos(Direction.IN, labels, authorizations), this.getEdgeInfos(Direction.OUT, labels, authorizations));
            }
        }
        throw new GeException("Unexpected direction: " + (Object)((Object)direction));
    }

    private Iterable<EdgeInfo> storableEdgeInfosToEdgeInfos(Iterable<Map.Entry<String, StorableEdgeInfo>> edgeInfos, final Direction direction) {
        return new ConvertingIterable<Map.Entry<String, StorableEdgeInfo>, EdgeInfo>(edgeInfos){

            @Override
            protected EdgeInfo convert(Map.Entry<String, StorableEdgeInfo> o) {
                final String edgeId = o.getKey() == null ? null : o.getKey();
                final StorableEdgeInfo edgeInfo = o.getValue();
                return new EdgeInfo(){

                    @Override
                    public String getEdgeId() {
                        if (!StorableVertex.this.getFetchHints().isIncludeEdgeIds()) {
                            throw new GeMissingFetchHintException(StorableVertex.this.getFetchHints(), "includeEdgeIds");
                        }
                        return edgeId;
                    }

                    @Override
                    public String getLabel() {
                        return edgeInfo.getLabel();
                    }

                    @Override
                    public String getVertexId() {
                        if (!StorableVertex.this.getFetchHints().isIncludeEdgeVertexIds()) {
                            throw new GeMissingFetchHintException(StorableVertex.this.getFetchHints(), "includeEdgeVertexIds");
                        }
                        return edgeInfo.getVertexId();
                    }

                    @Override
                    public Direction getDirection() {
                        return direction;
                    }
                };
            }
        };
    }

    protected Iterable<EdgeInfo> filterEdgeInfosByLabel(Iterable<EdgeInfo> edgeInfos, final String[] labels) {
        if (labels != null) {
            return new FilterIterable<EdgeInfo>(edgeInfos){

                @Override
                protected boolean isIncluded(EdgeInfo o) {
                    for (String label : labels) {
                        if (!o.getLabel().equals(label)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return edgeInfos;
    }

    @Override
    public Iterable<Vertex> getVertices(Direction direction, FetchHints fetchHints, Authorizations authorizations) {
        return this.getGraph().getVertices(this.getVertexIds(direction, authorizations), fetchHints, authorizations);
    }

    @Override
    public Iterable<Vertex> getVertices(Direction direction, String[] labels, FetchHints fetchHints, Authorizations authorizations) {
        return this.getGraph().getVertices(this.getVertexIds(direction, labels, authorizations), fetchHints, authorizations);
    }

    @Override
    public Iterable<String> getVertexIds(Direction direction, String[] labels, Authorizations authorizations) {
        if (!this.getFetchHints().isIncludeEdgeVertexIds()) {
            throw new GeMissingFetchHintException(this.getFetchHints(), "includeEdgeVertexIds");
        }
        switch (direction) {
            case BOTH: {
                Iterable<String> inVertexIds = this.getVertexIds(Direction.IN, labels, authorizations);
                Iterable<String> outVertexIds = this.getVertexIds(Direction.OUT, labels, authorizations);
                return new JoinIterable<String>(inVertexIds, outVertexIds);
            }
            case IN: {
                if (this.inEdges instanceof EdgesWithEdgeInfo) {
                    return new GetVertexIdsIterable(((EdgesWithEdgeInfo)this.inEdges).getEdgeInfos(), labels);
                }
                throw new GeException("Cannot get vertex ids");
            }
            case OUT: {
                if (this.outEdges instanceof EdgesWithEdgeInfo) {
                    return new GetVertexIdsIterable(((EdgesWithEdgeInfo)this.outEdges).getEdgeInfos(), labels);
                }
                throw new GeException("Cannot get vertex ids");
            }
        }
        throw new GeException("Unexpected direction: " + (Object)((Object)direction));
    }

    @Override
    public VertexQuery query(String queryString, Authorizations authorizations) {
        return this.getGraph().getSearchIndex().queryVertex(this.getGraph(), this, queryString, authorizations);
    }

    protected void addOutEdge(Edge edge) {
        if (!(this.outEdges instanceof EdgesWithEdgeInfo)) {
            throw new GeException("Cannot add edge");
        }
        ((EdgesWithEdgeInfo)this.outEdges).add((String)edge.getId(), new StorableEdgeInfo(edge.getLabel(), edge.getVertexId(Direction.IN)));
    }

    protected void removeOutEdge(Edge edge) {
        if (!(this.outEdges instanceof EdgesWithEdgeInfo)) {
            throw new GeException("Cannot remove out edge");
        }
        ((EdgesWithEdgeInfo)this.outEdges).remove((String)edge.getId());
    }

    protected void addInEdge(Edge edge) {
        if (!(this.inEdges instanceof EdgesWithEdgeInfo)) {
            throw new GeException("Cannot add edge");
        }
        ((EdgesWithEdgeInfo)this.inEdges).add((String)edge.getId(), new StorableEdgeInfo(edge.getLabel(), edge.getVertexId(Direction.OUT)));
    }

    protected void removeInEdge(Edge edge) {
        if (!(this.inEdges instanceof EdgesWithEdgeInfo)) {
            throw new GeException("Cannot remove in edge");
        }
        ((EdgesWithEdgeInfo)this.inEdges).remove((String)edge.getId());
    }

    @Override
    public ExistingVertexMutation prepareMutation() {
        return new ExistingVertexMutation(this){

            @Override
            public Vertex save(Authorizations authorizations) {
                StorableVertex.this.saveExistingElementMutation(this, authorizations);
                return (Vertex)this.getElement();
            }
        };
    }

    private static String[] labelToArrayOrNull(String label) {
        String[] stringArray;
        if (label == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = label;
        }
        return stringArray;
    }

    @Override
    public String getConceptType() {
        return this.conceptType;
    }

    public void setConceptType(String newConceptType) {
        this.conceptType = newConceptType;
    }

    public String getNewConceptType() {
        return this.newConceptType;
    }
}

