/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store;

import java.nio.ByteBuffer;

public class StoreValue {
    private byte[] value;
    private long ts;

    public StoreValue(long ts, byte[] val) {
        this.ts = ts;
        this.value = val;
    }

    public byte[] value() {
        return this.value;
    }

    public long ts() {
        return this.ts;
    }

    public byte[] serialize() {
        ByteBuffer buf = ByteBuffer.allocate(8 + this.value.length);
        buf.putLong(this.ts).put(this.value);
        return buf.array();
    }

    public static StoreValue deserialize(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        long ts = buf.getLong();
        byte[] v = new byte[bytes.length - 8];
        System.arraycopy(bytes, buf.position(), v, 0, bytes.length - 8);
        return new StoreValue(ts, v);
    }
}

