/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store;

import com.mware.ge.GeException;
import com.mware.ge.store.StorableGraph;
import com.mware.ge.util.IOUtils;
import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.StreamingPropertyValueRef;
import com.mware.ge.values.storable.ValueWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamingPropertyValueFileRef
extends StreamingPropertyValueRef<StorableGraph> {
    private File file;

    public StreamingPropertyValueFileRef(File file, StreamingPropertyValue propertyValue) {
        super(propertyValue);
        this.file = file;
    }

    @Override
    public StreamingPropertyValue toStreamingPropertyValue(StorableGraph graph, Long timestamp) {
        return new StreamingPropertyValueFile(this.file, this);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
    }

    @Override
    public Object asObjectCopy() {
        return null;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return null;
    }

    public static class StreamingPropertyValueFile
    extends StreamingPropertyValue {
        private final File file;

        public StreamingPropertyValueFile(File file, StreamingPropertyValueFileRef streamingPropertyValueRef) {
            super(streamingPropertyValueRef.getValueType());
            this.searchIndex(streamingPropertyValueRef.isSearchIndex());
            this.file = file;
        }

        @Override
        public Long getLength() {
            return this.file.length();
        }

        @Override
        public InputStream getInputStream() {
            try {
                return new ByteArrayInputStream(IOUtils.toBytes(new FileInputStream(this.file)));
            }
            catch (IOException ex) {
                throw new GeException("Could not open: " + this.file, ex);
            }
        }
    }
}

