/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store;

import com.mware.ge.Visibility;
import com.mware.ge.mutation.ExtendedDataMutation;
import java.util.HashSet;
import java.util.Set;

public class TableNameVisibilityPair {
    private final Visibility visibility;
    private final String tableName;

    private TableNameVisibilityPair(Visibility visibility, String tableName) {
        this.visibility = visibility;
        this.tableName = tableName;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public String getTableName() {
        return this.tableName;
    }

    public static Set<TableNameVisibilityPair> getUniquePairs(Iterable<ExtendedDataMutation> extendedDatas) {
        HashSet<TableNameVisibilityPair> results = new HashSet<TableNameVisibilityPair>();
        for (ExtendedDataMutation extendedData : extendedDatas) {
            results.add(new TableNameVisibilityPair(extendedData.getVisibility(), extendedData.getTableName()));
        }
        return results;
    }

    public String toString() {
        return "TableNameVisibilityPair{visibility=" + this.visibility + ", tableName='" + this.tableName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableNameVisibilityPair that = (TableNameVisibilityPair)o;
        if (!this.visibility.equals(that.visibility)) {
            return false;
        }
        return this.tableName.equals(that.tableName);
    }

    public int hashCode() {
        int result = this.visibility.hashCode();
        result = 31 * result + this.tableName.hashCode();
        return result;
    }
}

