/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.decoder;

import com.mware.ge.Authorizations;
import com.mware.ge.FetchHints;
import com.mware.ge.collection.Pair;
import com.mware.ge.collection.PrefetchingIterator;
import com.mware.ge.store.StorableGraph;
import com.mware.ge.store.StoreKey;
import com.mware.ge.store.StoreValue;
import com.mware.ge.store.decoder.EdgeElementData;
import com.mware.ge.store.decoder.ElementDecoder;

public class EdgeDecoder
extends ElementDecoder<EdgeElementData> {
    public EdgeDecoder(PrefetchingIterator<Pair<StoreKey, StoreValue>> storeIterable, StorableGraph graph, FetchHints fetchHints, Authorizations authorizations) {
        super(storeIterable, graph, fetchHints, authorizations);
    }

    @Override
    protected EdgeElementData createElementData(StorableGraph graph) {
        EdgeElementData data = new EdgeElementData();
        data.graph = graph;
        return data;
    }

    @Override
    protected String getVisibilitySignal() {
        return "E";
    }

    @Override
    protected boolean processColumn(Pair<StoreKey, StoreValue> keyValue) {
        StoreKey key = keyValue.first();
        StoreValue value = keyValue.other();
        if (key.cf().equals("EIN")) {
            if (((EdgeElementData)this.getElementData()).inVertexIdTimestamp == null || value.ts() > ((EdgeElementData)this.getElementData()).inVertexIdTimestamp) {
                ((EdgeElementData)this.getElementData()).inVertexId = key.cq();
                ((EdgeElementData)this.getElementData()).inVertexIdTimestamp = value.ts();
            }
            return true;
        }
        if (key.cf().equals("EOUT")) {
            if (((EdgeElementData)this.getElementData()).outVertexIdTimestamp == null || value.ts() > ((EdgeElementData)this.getElementData()).outVertexIdTimestamp) {
                ((EdgeElementData)this.getElementData()).outVertexId = key.cq();
                ((EdgeElementData)this.getElementData()).outVertexIdTimestamp = value.ts();
            }
            return true;
        }
        return false;
    }

    @Override
    protected void processSignalColumn(Pair<StoreKey, StoreValue> keyValue) {
        super.processSignalColumn(keyValue);
        ((EdgeElementData)this.getElementData()).label = keyValue.first().cq();
    }
}

