/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.decoder;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.security.ByteSequence;
import com.mware.ge.store.StorableGraph;
import com.mware.ge.store.decoder.DecoderMetadataEntry;
import com.mware.ge.store.decoder.PropertyColumnQualifierByteSequence;
import com.mware.ge.store.util.HiddenProperty;
import com.mware.ge.store.util.LazyMutableProperty;
import com.mware.ge.store.util.MetadataEntry;
import com.mware.ge.store.util.MetadataRef;
import com.mware.ge.store.util.PropertyRef;
import com.mware.ge.store.util.SoftDeletedProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ElementData {
    public String id;
    public long timestamp;
    public String visibility;
    public StorableGraph graph;
    public final List<String> hiddenVisibilities = new ArrayList<String>();
    public long softDeleteTimestamp;
    public final List<SoftDeletedProperty> softDeletedProperties = new ArrayList<SoftDeletedProperty>();
    public final List<HiddenProperty> hiddenProperties = new ArrayList<HiddenProperty>();
    public final List<DecoderMetadataEntry> metadataEntries = new ArrayList<DecoderMetadataEntry>();
    public final Map<ByteSequence, List<Integer>> propertyMetadata = new HashMap<ByteSequence, List<Integer>>();
    public final Map<ByteSequence, PropertyColumnQualifierByteSequence> propertyColumnQualifiers = new HashMap<ByteSequence, PropertyColumnQualifierByteSequence>();
    public final Map<ByteSequence, byte[]> propertyValues = new HashMap<ByteSequence, byte[]>();
    public final Map<ByteSequence, ByteSequence> propertyVisibilities = new HashMap<ByteSequence, ByteSequence>();
    public final Map<ByteSequence, Long> propertyTimestamps = new HashMap<ByteSequence, Long>();
    public final Set<String> extendedTableNames = new HashSet<String>();

    private Iterable<PropertyRef> internalGetProperties(FetchHints fetchHints) {
        ArrayList<PropertyRef> results = new ArrayList<PropertyRef>();
        try {
            this.iterateProperties((propertyKey, propertyName, propertyValue, propertyVisibility, propertyTimestamp, propertyHiddenVisibilities, metadata) -> results.add(new PropertyRef(propertyKey, propertyName, propertyValue, propertyVisibility, propertyTimestamp, propertyHiddenVisibilities, metadata)), fetchHints);
        }
        catch (IOException ex) {
            throw new GeException("Could not get properties", ex);
        }
        return results;
    }

    public Iterable<Property> getProperties(FetchHints fetchHints) {
        return Iterables.transform(this.internalGetProperties(fetchHints), (Function)new Function<PropertyRef, Property>(){

            @Nullable
            public Property apply(@Nullable PropertyRef property) {
                HashSet hiddenVisibilities = null;
                if (property.hiddenVisibilities != null) {
                    hiddenVisibilities = Sets.newHashSet((Iterable)Iterables.transform(property.hiddenVisibilities, (Function)new Function<ByteSequence, Visibility>(){

                        @Nullable
                        public Visibility apply(ByteSequence visibilityText) {
                            return new Visibility(visibilityText.toString());
                        }
                    }));
                }
                Visibility visibility = new Visibility(property.visibility.toString());
                MetadataRef ref = null;
                if (property.metadata != null) {
                    int[] metadataIndexes = new int[property.metadata.size()];
                    for (int i = 0; i < property.metadata.size(); ++i) {
                        metadataIndexes[i] = property.metadata.get(i);
                    }
                    ref = new MetadataRef(ElementData.this.metadataEntries.parallelStream().map(dme -> new MetadataEntry(dme.metadataKey.toString(), dme.metadataVisibility.toString(), dme.value)).collect(Collectors.toList()), metadataIndexes);
                }
                return new LazyMutableProperty(ElementData.this.graph, ElementData.this.graph.getGeSerializer(), ElementData.this.graph.getNameSubstitutionStrategy().inflate(new String(property.key.toArray())), ElementData.this.graph.getNameSubstitutionStrategy().inflate(new String(property.name.toArray())), property.value, ref, hiddenVisibilities, visibility, property.timestamp, FetchHints.ALL_INCLUDING_HIDDEN);
            }
        });
    }

    private void iterateProperties(PropertyDataHandler propertyDataHandler, FetchHints fetchHints) throws IOException {
        boolean includeHidden = fetchHints.isIncludeHidden();
        for (Map.Entry<ByteSequence, byte[]> propertyValueEntry : this.propertyValues.entrySet()) {
            ByteSequence key = propertyValueEntry.getKey();
            PropertyColumnQualifierByteSequence propertyColumnQualifier = this.propertyColumnQualifiers.get(key);
            ByteSequence propertyKey = propertyColumnQualifier.getPropertyKey();
            ByteSequence propertyName = propertyColumnQualifier.getPropertyName();
            byte[] propertyValue = propertyValueEntry.getValue();
            ByteSequence propertyVisibility = this.propertyVisibilities.get(key);
            long propertyTimestamp = this.propertyTimestamps.get(key);
            if (propertyTimestamp < this.softDeleteTimestamp) continue;
            Set<ByteSequence> propertyHiddenVisibilities = this.getPropertyHiddenVisibilities(propertyKey, propertyName, propertyVisibility);
            if (!includeHidden && this.isHidden(propertyKey, propertyName, propertyVisibility) || this.isPropertyDeleted(propertyKey, propertyName, propertyTimestamp, propertyVisibility)) continue;
            List<Integer> metadata = this.propertyMetadata.get(key);
            propertyDataHandler.handle(propertyKey, propertyName, propertyValue, propertyVisibility, propertyTimestamp, propertyHiddenVisibilities, metadata);
        }
    }

    private Set<ByteSequence> getPropertyHiddenVisibilities(ByteSequence propertyKey, ByteSequence propertyName, ByteSequence propertyVisibility) {
        HashSet<ByteSequence> hiddenVisibilities = null;
        for (HiddenProperty hiddenProperty : this.hiddenProperties) {
            if (!hiddenProperty.matches(propertyKey, propertyName, propertyVisibility)) continue;
            if (hiddenVisibilities == null) {
                hiddenVisibilities = new HashSet<ByteSequence>();
            }
            hiddenVisibilities.add(hiddenProperty.getHiddenVisibility());
        }
        return hiddenVisibilities;
    }

    private boolean isHidden(ByteSequence propertyKey, ByteSequence propertyName, ByteSequence propertyVisibility) {
        for (HiddenProperty hiddenProperty : this.hiddenProperties) {
            if (!hiddenProperty.matches(propertyKey, propertyName, propertyVisibility)) continue;
            return true;
        }
        return false;
    }

    private boolean isPropertyDeleted(ByteSequence propertyKey, ByteSequence propertyName, long propertyTimestamp, ByteSequence propertyVisibility) {
        for (SoftDeletedProperty softDeletedProperty : this.softDeletedProperties) {
            if (!softDeletedProperty.matches(propertyKey, propertyName, propertyVisibility)) continue;
            return softDeletedProperty.getTimestamp() >= propertyTimestamp;
        }
        return false;
    }

    private static interface PropertyDataHandler {
        public void handle(ByteSequence var1, ByteSequence var2, byte[] var3, ByteSequence var4, long var5, Set<ByteSequence> var7, List<Integer> var8) throws IOException;
    }
}

