/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.decoder;

import com.mware.ge.Authorizations;
import com.mware.ge.FetchHints;
import com.mware.ge.Visibility;
import com.mware.ge.collection.Pair;
import com.mware.ge.collection.PrefetchingIterator;
import com.mware.ge.security.ArrayByteSequence;
import com.mware.ge.security.ByteSequence;
import com.mware.ge.store.StorableElement;
import com.mware.ge.store.StorableGraph;
import com.mware.ge.store.StoreKey;
import com.mware.ge.store.StoreValue;
import com.mware.ge.store.decoder.DecoderMetadataEntry;
import com.mware.ge.store.decoder.ElementData;
import com.mware.ge.store.decoder.PropertyColumnQualifierByteSequence;
import com.mware.ge.store.decoder.PropertyHiddenColumnQualifierByteSequence;
import com.mware.ge.store.decoder.PropertyMetadataColumnQualifierByteSequence;
import com.mware.ge.store.mutations.ElementMutationBuilder;
import com.mware.ge.store.util.HiddenProperty;
import com.mware.ge.store.util.SoftDeletedProperty;
import com.mware.ge.util.LookAheadIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class ElementDecoder<T extends ElementData>
implements Iterable<T> {
    protected FetchHints fetchHints;
    protected T elementData;
    protected Authorizations authorizations;
    protected StorableGraph graph;
    private PrefetchingIterator<Pair<StoreKey, StoreValue>> storeIterable;

    public ElementDecoder(PrefetchingIterator<Pair<StoreKey, StoreValue>> storeIterable, StorableGraph graph, FetchHints fetchHints, Authorizations authorizations) {
        this.storeIterable = storeIterable;
        this.graph = graph;
        this.fetchHints = fetchHints;
        this.elementData = this.createElementData(graph);
        this.authorizations = authorizations;
    }

    @Override
    public Iterator<T> iterator() {
        return new LookAheadIterable<Pair<StoreKey, StoreValue>, T>(){

            @Override
            protected boolean isIncluded(Pair<StoreKey, StoreValue> src, T elem) {
                return elem != null;
            }

            @Override
            protected T convert(Pair<StoreKey, StoreValue> source) {
                String nextId;
                String id;
                Pair next;
                ArrayList<Pair<StoreKey, StoreValue>> mutations = new ArrayList<Pair<StoreKey, StoreValue>>();
                mutations.add(source);
                while (ElementDecoder.this.storeIterable.hasNext() && (next = (Pair)ElementDecoder.this.storeIterable.peek()) != null && (id = source.first().id()).equals(nextId = ((StoreKey)next.first()).id())) {
                    mutations.add((Pair<StoreKey, StoreValue>)ElementDecoder.this.storeIterable.next());
                }
                mutations.sort(Comparator.comparingLong(m -> ((StoreValue)m.other()).ts()).reversed());
                return ElementDecoder.this.decode(mutations);
            }

            @Override
            protected Iterator<Pair<StoreKey, StoreValue>> createIterator() {
                return ElementDecoder.this.storeIterable;
            }
        }.iterator();
    }

    protected boolean populateElementData(List<Pair<StoreKey, StoreValue>> mutations) {
        for (int i = 0; i < mutations.size(); ++i) {
            if (this.processKeyValue(mutations.get(i))) continue;
            return false;
        }
        if (((ElementData)this.elementData).visibility == null) {
            return false;
        }
        if (((ElementData)this.elementData).softDeleteTimestamp >= ((ElementData)this.elementData).timestamp) {
            return false;
        }
        if (this.fetchHints.isIncludeHidden()) {
            return true;
        }
        for (String hiddenVis : ((ElementData)this.elementData).hiddenVisibilities) {
            if (!this.authorizations.canRead(new Visibility(hiddenVis))) continue;
            return false;
        }
        return true;
    }

    private boolean processKeyValue(Pair<StoreKey, StoreValue> pair) {
        if (((ElementData)this.elementData).id == null) {
            ((ElementData)this.elementData).id = pair.first().id();
        }
        StoreKey key = pair.first();
        StoreValue value = pair.other();
        if (key.cf().equals("PROPMETA")) {
            if (this.authorizations.canRead(key.visibility())) {
                this.extractPropertyMetadata(pair);
            }
            return true;
        }
        if (key.cf().equals("PROP")) {
            if (this.authorizations.canRead(key.visibility())) {
                this.extractPropertyData(pair);
            }
            return true;
        }
        if (key.cf().equals("EXTDATA")) {
            ((ElementData)this.elementData).extendedTableNames.add(new String(value.value()));
            return true;
        }
        if (key.cf().equals(this.getVisibilitySignal()) && value.ts() > ((ElementData)this.elementData).timestamp) {
            if (this.authorizations.canRead(key.visibility())) {
                ((ElementData)this.elementData).visibility = key.visibilityString();
                ((ElementData)this.elementData).timestamp = value.ts();
                this.processSignalColumn(pair);
            }
            return true;
        }
        if (this.processColumn(pair)) {
            return true;
        }
        if (key.cf().equals("") && key.cq().equals("") && Arrays.equals(ElementMutationBuilder.DELETE_ROW_VALUE, value.value())) {
            return false;
        }
        if (key.cf().equals("D") && key.cq().equals("D") && Arrays.equals(StorableElement.SOFT_DELETE_VALUE, value.value())) {
            ((ElementData)this.elementData).softDeleteTimestamp = pair.other().ts();
            return true;
        }
        if (key.cf().equals("PROPD")) {
            this.extractPropertySoftDelete(pair);
            return true;
        }
        if (key.cf().equals("H")) {
            ((ElementData)this.elementData).hiddenVisibilities.add(key.visibilityString());
            return true;
        }
        if (key.cf().equals("PROPH")) {
            this.extractPropertyHidden(pair);
            return true;
        }
        return true;
    }

    protected abstract T createElementData(StorableGraph var1);

    protected abstract String getVisibilitySignal();

    protected abstract boolean processColumn(Pair<StoreKey, StoreValue> var1);

    protected void processSignalColumn(Pair<StoreKey, StoreValue> keyValue) {
    }

    private void extractPropertyData(Pair<StoreKey, StoreValue> keyValue) {
        long timestamp = keyValue.other().ts();
        PropertyColumnQualifierByteSequence propertyColumnQualifier = new PropertyColumnQualifierByteSequence((ByteSequence)new ArrayByteSequence(keyValue.first().cq()));
        ByteSequence mapKey = propertyColumnQualifier.getDiscriminator((ByteSequence)new ArrayByteSequence(keyValue.first().vis()), timestamp);
        if (this.shouldIncludeProperty(propertyColumnQualifier.getPropertyName())) {
            ((ElementData)this.elementData).propertyColumnQualifiers.put(mapKey, propertyColumnQualifier);
            ((ElementData)this.elementData).propertyValues.put(mapKey, keyValue.other().value());
            ((ElementData)this.elementData).propertyVisibilities.put(mapKey, (ByteSequence)new ArrayByteSequence(keyValue.first().vis()));
            ((ElementData)this.elementData).propertyTimestamps.put(mapKey, timestamp);
        }
    }

    private void extractPropertyMetadata(Pair<StoreKey, StoreValue> keyValue) {
        PropertyMetadataColumnQualifierByteSequence propertyMetadataColumnQualifier = new PropertyMetadataColumnQualifierByteSequence((ByteSequence)new ArrayByteSequence(keyValue.first().cq()));
        if (this.shouldIncludeMetadata(propertyMetadataColumnQualifier)) {
            ByteSequence discriminator = propertyMetadataColumnQualifier.getPropertyDiscriminator(keyValue.other().ts());
            List propertyMetadata = ((ElementData)this.elementData).propertyMetadata.computeIfAbsent(discriminator, k -> new ArrayList());
            DecoderMetadataEntry pme = new DecoderMetadataEntry(propertyMetadataColumnQualifier.getMetadataKey(), (ByteSequence)new ArrayByteSequence(keyValue.first().vis()), keyValue.other().value());
            int pos = ((ElementData)this.elementData).metadataEntries.indexOf(pme);
            if (pos < 0) {
                pos = ((ElementData)this.elementData).metadataEntries.size();
                ((ElementData)this.elementData).metadataEntries.add(pme);
            }
            propertyMetadata.add(pos);
        }
    }

    private void extractPropertySoftDelete(Pair<StoreKey, StoreValue> keyValue) {
        PropertyColumnQualifierByteSequence propertyColumnQualifier = new PropertyColumnQualifierByteSequence((ByteSequence)new ArrayByteSequence(keyValue.first().cq()));
        SoftDeletedProperty softDeletedProperty = new SoftDeletedProperty(propertyColumnQualifier.getPropertyKey(), propertyColumnQualifier.getPropertyName(), keyValue.other().ts(), (ByteSequence)new ArrayByteSequence(keyValue.first().vis()));
        ((ElementData)this.elementData).softDeletedProperties.add(softDeletedProperty);
    }

    private void extractPropertyHidden(Pair<StoreKey, StoreValue> keyValue) {
        if (Arrays.equals(keyValue.other().value(), StorableElement.HIDDEN_VALUE_DELETED)) {
            return;
        }
        PropertyHiddenColumnQualifierByteSequence propertyHiddenColumnQualifier = new PropertyHiddenColumnQualifierByteSequence((ByteSequence)new ArrayByteSequence(keyValue.first().cq()));
        HiddenProperty hiddenProperty = new HiddenProperty(propertyHiddenColumnQualifier.getPropertyKey(), propertyHiddenColumnQualifier.getPropertyName(), propertyHiddenColumnQualifier.getPropertyVisibilityString(), (ByteSequence)new ArrayByteSequence(keyValue.first().vis()));
        ((ElementData)this.elementData).hiddenProperties.add(hiddenProperty);
    }

    private boolean shouldIncludeProperty(ByteSequence propertyName) {
        if (this.fetchHints.isIncludeAllProperties()) {
            return true;
        }
        return this.fetchHints.getPropertyNamesToInclude() != null && this.fetchHints.getPropertyNamesToInclude().contains((Object)propertyName.toString());
    }

    private boolean shouldIncludeMetadata(PropertyMetadataColumnQualifierByteSequence propertyMetadataColumnQualifier) {
        if (!this.shouldIncludeProperty(propertyMetadataColumnQualifier.getPropertyName())) {
            return false;
        }
        if (this.fetchHints.isIncludeAllPropertyMetadata()) {
            return true;
        }
        ByteSequence metadataKey = propertyMetadataColumnQualifier.getMetadataKey();
        return this.fetchHints.getMetadataKeysToInclude() != null && this.fetchHints.getMetadataKeysToInclude().contains((Object)metadataKey.toString());
    }

    public T getElementData() {
        return this.elementData;
    }

    public FetchHints getFetchHints() {
        return this.fetchHints;
    }

    protected T decode(List<Pair<StoreKey, StoreValue>> mutations) {
        this.elementData = this.createElementData(this.graph);
        if (this.populateElementData(mutations)) {
            return this.getElementData();
        }
        return null;
    }
}

