/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.decoder;

import com.mware.ge.Authorizations;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.collection.Pair;
import com.mware.ge.store.StorableExtendedDataRow;
import com.mware.ge.store.StorableGraph;
import com.mware.ge.store.StoreKey;
import com.mware.ge.store.StoreValue;
import com.mware.ge.store.util.KeyBase;
import com.mware.ge.store.util.StorableKeyHelper;
import com.mware.ge.values.storable.Value;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class ExtendedDataDecoder {
    private StorableGraph graph;
    private FetchHints fetchHints;
    private Authorizations authorizations;

    public ExtendedDataDecoder(StorableGraph graph, FetchHints fetchHints, Authorizations authorizations) {
        this.graph = graph;
        this.fetchHints = fetchHints;
        this.authorizations = authorizations;
    }

    public ExtendedDataRow decode(List<Pair<StoreKey, StoreValue>> row) {
        if (row.size() == 0) {
            return null;
        }
        ExtendedDataRowId rowId = StorableKeyHelper.parseExtendedDataRowId(row.get(0).first().id());
        HashSet<Property> properties = new HashSet<Property>();
        row.sort(Comparator.comparingLong(m -> ((StoreValue)m.other()).ts()));
        for (Pair<StoreKey, StoreValue> rowEntry : row) {
            String columnFamily = rowEntry.first().cf();
            if ("EXTDATA".equals(columnFamily)) {
                String[] columnQualifierParts = KeyBase.splitOnValueSeparator(rowEntry.first().cq());
                if (columnQualifierParts.length != 1 && columnQualifierParts.length != 2) {
                    throw new GeException("Invalid column qualifier for extended data row: " + rowId + " (expected 1 or 2 parts, found " + columnQualifierParts.length + ")");
                }
                String propertyName = columnQualifierParts[0];
                String propertyKey = columnQualifierParts.length > 1 ? columnQualifierParts[1] : null;
                Value propertyValue = (Value)this.graph.getGeSerializer().bytesToObject(rowId, rowEntry.other().value());
                long timestamp = rowEntry.other().ts();
                Visibility visibility = rowEntry.first().visibility();
                if (!this.authorizations.canRead(visibility)) continue;
                StorableExtendedDataRow.StorableExtendedDataRowProperty prop = new StorableExtendedDataRow.StorableExtendedDataRowProperty(propertyName, propertyKey, propertyValue, this.fetchHints, timestamp, visibility);
                properties.add(prop);
                continue;
            }
            throw new GeException("unhandled column family: " + columnFamily);
        }
        if (properties.size() == 0) {
            return null;
        }
        return new StorableExtendedDataRow(rowId, properties, this.fetchHints);
    }
}

