/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.decoder;

import com.mware.ge.GeException;
import com.mware.ge.security.ArrayByteSequence;
import com.mware.ge.security.ByteSequence;
import com.mware.ge.store.GeInvalidKeyException;
import com.mware.ge.store.util.ByteSequenceUtils;
import java.nio.ByteBuffer;

public abstract class KeyBaseByteSequence {
    public static final byte VALUE_SEPARATOR = 31;

    public static ByteSequence[] splitOnValueSeparator(ByteSequence bytes, int partCount) {
        ByteSequence[] results = new ByteSequence[partCount];
        int last = 0;
        int i = ByteSequenceUtils.indexOf(bytes, (byte)31);
        int partIndex = 0;
        while (i > 0) {
            results[partIndex++] = ByteSequenceUtils.subSequence(bytes, last, i);
            if (partIndex >= partCount) {
                throw new GeException("Invalid number of parts for '" + bytes + "'. Expected " + partCount + " found " + partIndex);
            }
            last = i + 1;
            i = ByteSequenceUtils.indexOf(bytes, (byte)31, last);
        }
        results[partIndex++] = ByteSequenceUtils.subSequence(bytes, last);
        if (partIndex != partCount) {
            throw new GeException("Invalid number of parts for '" + bytes + "'. Expected " + partCount + " found " + partIndex);
        }
        return results;
    }

    public static void assertNoValueSeparator(ByteSequence bytes) {
        if (ByteSequenceUtils.indexOf(bytes, (byte)31) >= 0) {
            throw new GeInvalidKeyException("String cannot contain '31' (0x1f): " + bytes);
        }
    }

    public static ByteSequence getDiscriminator(ByteSequence propertyName, ByteSequence propertyKey, ByteSequence visibilityString, long timestamp) {
        KeyBaseByteSequence.assertNoValueSeparator(propertyName);
        KeyBaseByteSequence.assertNoValueSeparator(propertyKey);
        KeyBaseByteSequence.assertNoValueSeparator(visibilityString);
        int length = propertyName.length() + propertyKey.length() + visibilityString.length() + 8;
        byte[] bytes = new byte[length];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        ByteSequenceUtils.putIntoByteBuffer(propertyName, bb);
        ByteSequenceUtils.putIntoByteBuffer(propertyKey, bb);
        ByteSequenceUtils.putIntoByteBuffer(visibilityString, bb);
        bb.putLong(timestamp);
        return new ArrayByteSequence(bytes);
    }
}

