/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.decoder;

import com.google.common.collect.ImmutableSet;
import com.mware.ge.Authorizations;
import com.mware.ge.FetchHints;
import com.mware.ge.Visibility;
import com.mware.ge.collection.Pair;
import com.mware.ge.collection.PrefetchingIterator;
import com.mware.ge.store.StorableEdgeInfo;
import com.mware.ge.store.StorableGraph;
import com.mware.ge.store.StoreKey;
import com.mware.ge.store.StoreValue;
import com.mware.ge.store.decoder.ElementDecoder;
import com.mware.ge.store.decoder.VertexElementData;
import com.mware.ge.store.util.SoftDeleteEdgeInfo;
import java.util.List;

public class VertexDecoder
extends ElementDecoder<VertexElementData> {
    public VertexDecoder(PrefetchingIterator<Pair<StoreKey, StoreValue>> storeIterable, StorableGraph graph, FetchHints fetchHints, Authorizations authorizations) {
        super(storeIterable, graph, fetchHints, authorizations);
    }

    @Override
    protected VertexElementData decode(List<Pair<StoreKey, StoreValue>> mutations) {
        VertexElementData data = (VertexElementData)super.decode(mutations);
        if (data != null) {
            this.removeHiddenAndSoftDeletes();
        }
        return data;
    }

    @Override
    protected VertexElementData createElementData(StorableGraph graph) {
        VertexElementData data = new VertexElementData();
        data.graph = graph;
        return data;
    }

    @Override
    protected String getVisibilitySignal() {
        return "V";
    }

    @Override
    protected boolean processColumn(Pair<StoreKey, StoreValue> keyValue) {
        StoreKey key = keyValue.first();
        StoreValue value = keyValue.other();
        if (key.cf().equals("EOUT")) {
            this.processOutEdge(keyValue);
            return true;
        }
        if (key.cf().equals("EIN")) {
            this.processInEdge(keyValue);
            return true;
        }
        if (key.cf().equals("EOUTH") || key.cf().equals("EINH")) {
            String edgeId = key.cq();
            ((VertexElementData)this.getElementData()).hiddenEdges.add(edgeId);
            ((VertexElementData)this.getElementData()).hiddenEdgesVisibilities.put(edgeId, key.visibility());
            return true;
        }
        if (key.cf().equals("EIND")) {
            String edgeId = key.cq();
            ((VertexElementData)this.getElementData()).inSoftDeletes.add(new SoftDeleteEdgeInfo(edgeId, value.ts()));
            return true;
        }
        if (key.cf().equals("EOUTD")) {
            String edgeId = key.cq();
            ((VertexElementData)this.getElementData()).outSoftDeletes.add(new SoftDeleteEdgeInfo(edgeId, value.ts()));
            return true;
        }
        return false;
    }

    private void processOutEdge(Pair<StoreKey, StoreValue> keyValue) {
        StorableEdgeInfo edgeInfo = new StorableEdgeInfo(keyValue.other().value(), keyValue.other().ts());
        if (this.authorizations.canRead(keyValue.first().visibility()) && this.shouldIncludeOutEdge(edgeInfo)) {
            String edgeId = keyValue.first().cq();
            ((VertexElementData)this.getElementData()).outEdges.add(edgeId, edgeInfo);
        }
    }

    private void processInEdge(Pair<StoreKey, StoreValue> keyValue) {
        StorableEdgeInfo edgeInfo = new StorableEdgeInfo(keyValue.other().value(), keyValue.other().ts());
        if (this.authorizations.canRead(keyValue.first().visibility()) && this.shouldIncludeInEdge(edgeInfo)) {
            String edgeId = keyValue.first().cq();
            ((VertexElementData)this.getElementData()).inEdges.add(edgeId, edgeInfo);
        }
    }

    private boolean shouldIncludeOutEdge(StorableEdgeInfo edgeInfo) {
        ImmutableSet<String> labels = this.getFetchHints().getEdgeLabelsOfEdgeRefsToInclude();
        if (labels != null && labels.contains(edgeInfo.getLabel())) {
            return true;
        }
        return this.getFetchHints().isIncludeAllEdgeRefs() || this.getFetchHints().isIncludeEdgeLabelsAndCounts() || this.getFetchHints().isIncludeOutEdgeRefs();
    }

    private boolean shouldIncludeInEdge(StorableEdgeInfo edgeInfo) {
        ImmutableSet<String> labels = this.getFetchHints().getEdgeLabelsOfEdgeRefsToInclude();
        if (labels != null && labels.contains(edgeInfo.getLabel())) {
            return true;
        }
        return this.getFetchHints().isIncludeAllEdgeRefs() || this.getFetchHints().isIncludeEdgeLabelsAndCounts() || this.getFetchHints().isIncludeInEdgeRefs();
    }

    @Override
    protected void processSignalColumn(Pair<StoreKey, StoreValue> keyValue) {
        super.processSignalColumn(keyValue);
        ((VertexElementData)this.getElementData()).conceptType = keyValue.first().cq();
    }

    @Override
    protected boolean populateElementData(List<Pair<StoreKey, StoreValue>> mutations) {
        boolean ret = super.populateElementData(mutations);
        if (ret) {
            this.removeHiddenAndSoftDeletes();
        }
        return ret;
    }

    private void removeHiddenAndSoftDeletes() {
        if (!this.getFetchHints().isIncludeHidden()) {
            for (String edgeId : ((VertexElementData)this.getElementData()).hiddenEdges) {
                Visibility hiddenEdgeVisibility = ((VertexElementData)this.getElementData()).hiddenEdgesVisibilities.get(edgeId);
                if (!this.authorizations.canRead(hiddenEdgeVisibility)) continue;
                ((VertexElementData)this.getElementData()).inEdges.remove(edgeId);
                ((VertexElementData)this.getElementData()).outEdges.remove(edgeId);
            }
        }
        for (SoftDeleteEdgeInfo inSoftDelete : ((VertexElementData)this.getElementData()).inSoftDeletes) {
            StorableEdgeInfo inEdge = ((VertexElementData)this.getElementData()).inEdges.get(inSoftDelete.getEdgeId());
            if (inEdge == null || inSoftDelete.getTimestamp() < inEdge.getTimestamp()) continue;
            ((VertexElementData)this.getElementData()).inEdges.remove(inSoftDelete.getEdgeId());
        }
        for (SoftDeleteEdgeInfo outSoftDelete : ((VertexElementData)this.getElementData()).outSoftDeletes) {
            StorableEdgeInfo outEdge = ((VertexElementData)this.getElementData()).outEdges.get(outSoftDelete.getEdgeId());
            if (outEdge == null || outSoftDelete.getTimestamp() < outEdge.getTimestamp()) continue;
            ((VertexElementData)this.getElementData()).outEdges.remove(outSoftDelete.getEdgeId());
        }
    }
}

