/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.kv;

import com.mware.ge.store.StoreKey;
import com.mware.ge.store.mutations.StoreMutation;
import java.nio.ByteBuffer;

public class KVKeyUtils {
    public static final char ID_VALUE_SEPARATOR = '\u001e';

    public static byte[] encodeId(byte[] id) {
        byte[] _id = new byte[id.length + 1];
        System.arraycopy(id, 0, _id, 0, id.length);
        _id[id.length] = 30;
        return _id;
    }

    public static byte[] decodeId(byte[] id) {
        int idlen = 0;
        for (int i = 0; i < id.length; ++i) {
            if (id[i] != 30) continue;
            idlen = i;
            break;
        }
        byte[] bid = new byte[idlen];
        System.arraycopy(id, 0, bid, 0, idlen);
        return bid;
    }

    public static ByteBuffer keyFromMutation(StoreMutation m, byte[] cf, byte[] cq, byte[] vis) {
        byte[] id = KVKeyUtils.encodeId(m.getRow());
        ByteBuffer buf = ByteBuffer.allocate(id.length + 4 + cf.length + 4 + cq.length + 4 + vis.length);
        buf.put(id).putInt(cf.length).put(cf).putInt(cq.length).put(cq).putInt(vis.length).put(vis);
        return buf;
    }

    public static StoreKey storeKey(byte[] key) {
        byte[] bid = KVKeyUtils.decodeId(key);
        int idlen = bid.length;
        ByteBuffer buffer = ByteBuffer.wrap(key, idlen + 1, key.length - idlen - 1);
        byte[] id = bid;
        byte[] bcf = new byte[buffer.getInt()];
        buffer.get(bcf);
        byte[] bcq = new byte[buffer.getInt()];
        buffer.get(bcq);
        byte[] vis = new byte[buffer.getInt()];
        buffer.get(vis);
        return new StoreKey(id, bcf, bcq, vis);
    }
}

