/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.kv;

import com.mware.ge.GeException;
import com.mware.ge.GraphMetadataEntry;
import com.mware.ge.GraphMetadataStore;
import com.mware.ge.IdRange;
import com.mware.ge.collection.Pair;
import com.mware.ge.store.kv.KVKeyUtils;
import com.mware.ge.store.kv.KVStoreGraph;
import com.mware.ge.store.kv.ScanIterator;
import com.mware.ge.util.JavaSerializableUtils;
import com.mware.ge.util.LookAheadIterable;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;

public class KVMetadataStore
extends GraphMetadataStore {
    private KVStoreGraph graph;

    public KVMetadataStore(KVStoreGraph graph) {
        this.graph = graph;
    }

    @Override
    public Iterable<GraphMetadataEntry> getMetadata() {
        return new LookAheadIterable<Pair<byte[], byte[]>, GraphMetadataEntry>(){
            ScanIterator iter;

            @Override
            protected boolean isIncluded(Pair<byte[], byte[]> src, GraphMetadataEntry graphMetadataEntry) {
                return graphMetadataEntry != null;
            }

            @Override
            protected GraphMetadataEntry convert(Pair<byte[], byte[]> pair) {
                return new GraphMetadataEntry(new String(KVKeyUtils.decodeId(pair.first())), pair.other());
            }

            @Override
            protected Iterator<Pair<byte[], byte[]>> createIterator() {
                this.iter = KVMetadataStore.this.graph.getKvStore().scan(KVMetadataStore.this.graph.getMetadataTableName());
                return this.iter;
            }

            @Override
            public void close() {
                IOUtils.closeQuietly((Closeable)this.iter);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getMetadata(String key) {
        try (ScanIterator iter = this.graph.getKvStore().scan(this.graph.getMetadataTableName(), new IdRange(key));){
            if (iter.hasNext()) {
                Pair pair = (Pair)iter.next();
                Object object = new GraphMetadataEntry(new String(KVKeyUtils.decodeId((byte[])pair.first())), (byte[])pair.other()).getValue();
                return object;
            }
            Object var4_6 = null;
            return var4_6;
        }
        catch (IOException ex) {
            throw new GeException(ex);
        }
    }

    @Override
    public void setMetadata(String key, Object value) {
        byte[] bvalue = JavaSerializableUtils.objectToBytes(value);
        byte[] bkey = KVKeyUtils.encodeId(key.getBytes(StandardCharsets.UTF_8));
        this.graph.kvStore.put(this.graph.getMetadataTableName(), bkey, bvalue);
    }

    @Override
    public void reloadMetadata() {
    }

    @Override
    public void removeMetadata(String key) {
        byte[] bkey = KVKeyUtils.encodeId(key.getBytes());
        this.graph.kvStore.delete(this.graph.getMetadataTableName(), bkey);
    }

    @Override
    public void close() {
    }

    @Override
    public void drop() {
    }
}

