/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.kv;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.google.common.collect.ImmutableSet;
import com.mware.ge.Authorizations;
import com.mware.ge.Edge;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.GeObjectType;
import com.mware.ge.GraphMetadataEntry;
import com.mware.ge.IdRange;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.collection.CombiningIterable;
import com.mware.ge.collection.Iterators;
import com.mware.ge.collection.Pair;
import com.mware.ge.collection.PrefetchingIterator;
import com.mware.ge.store.AbstractStorableGraph;
import com.mware.ge.store.Edges;
import com.mware.ge.store.StorableEdge;
import com.mware.ge.store.StorableGraphConfiguration;
import com.mware.ge.store.StorableVertex;
import com.mware.ge.store.StoreKey;
import com.mware.ge.store.StoreValue;
import com.mware.ge.store.decoder.EdgeDecoder;
import com.mware.ge.store.decoder.EdgeElementData;
import com.mware.ge.store.decoder.ExtendedDataDecoder;
import com.mware.ge.store.decoder.VertexDecoder;
import com.mware.ge.store.decoder.VertexElementData;
import com.mware.ge.store.kv.KVKeyUtils;
import com.mware.ge.store.kv.KVStore;
import com.mware.ge.store.kv.ScanIterator;
import com.mware.ge.store.mutations.ElementMutationBuilder;
import com.mware.ge.store.mutations.StoreColumnUpdate;
import com.mware.ge.store.mutations.StoreMutation;
import com.mware.ge.util.IncreasingTime;
import com.mware.ge.util.LookAheadIterable;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.curator.shaded.com.google.common.io.Files;

public abstract class KVStoreGraph
extends AbstractStorableGraph<StorableVertex, StorableEdge> {
    protected KVStore kvStore = this.createStore();

    public KVStoreGraph(StorableGraphConfiguration config) {
        super(config);
        this.kvStore.open();
    }

    @Override
    public Iterable<Vertex> getVerticesInRange(final IdRange idRange, final FetchHints fetchHints, Long endTime, final Authorizations authorizations) {
        return new LookAheadIterable<VertexElementData, Vertex>(){
            ScanIterator iter;

            @Override
            protected boolean isIncluded(VertexElementData src, Vertex vertex) {
                return vertex != null;
            }

            @Override
            protected Vertex convert(VertexElementData vertexElementData) {
                if (vertexElementData == null) {
                    return null;
                }
                ImmutableSet extendedDataTableNames = vertexElementData.extendedTableNames.size() > 0 ? ImmutableSet.copyOf((Collection)vertexElementData.extendedTableNames) : ImmutableSet.of();
                boolean outEdgeLabelsOnly = fetchHints.isIncludeEdgeLabelsAndCounts() && !fetchHints.isIncludeAllEdgeRefs() && !fetchHints.isIncludeOutEdgeRefs();
                boolean inEdgeLabelsOnly = fetchHints.isIncludeEdgeLabelsAndCounts() && !fetchHints.isIncludeAllEdgeRefs() && !fetchHints.isIncludeInEdgeRefs();
                return new StorableVertex(KVStoreGraph.this, vertexElementData.id, vertexElementData.conceptType, null, new Visibility(vertexElementData.visibility), vertexElementData.getProperties(fetchHints), null, null, vertexElementData.hiddenVisibilities.stream().map(Visibility::new).collect(Collectors.toList()), (ImmutableSet<String>)extendedDataTableNames, (Edges)(inEdgeLabelsOnly ? vertexElementData.inEdges.getEdgesWithCount() : vertexElementData.inEdges), (Edges)(outEdgeLabelsOnly ? vertexElementData.outEdges.getEdgesWithCount() : vertexElementData.outEdges), vertexElementData.timestamp, fetchHints, authorizations);
            }

            @Override
            protected Iterator<VertexElementData> createIterator() {
                this.iter = KVStoreGraph.this.getKvStore().scan(KVStoreGraph.this.getVerticesTableName(), idRange);
                Iterator<Pair> mappingIterator = Iterators.map(o -> Pair.of(KVKeyUtils.storeKey((byte[])o.first()), StoreValue.deserialize((byte[])o.other())), this.iter);
                return new VertexDecoder(Iterators.prefetching(mappingIterator), KVStoreGraph.this, fetchHints, authorizations).iterator();
            }

            @Override
            public void close() {
                IOUtils.closeQuietly((Closeable)this.iter);
            }
        };
    }

    @Override
    public Iterable<Edge> getEdgesInRange(final IdRange idRange, final FetchHints fetchHints, Long endTime, final Authorizations authorizations) {
        return new LookAheadIterable<EdgeElementData, Edge>(){
            ScanIterator iter;

            @Override
            protected boolean isIncluded(EdgeElementData src, Edge vertex) {
                return vertex != null;
            }

            @Override
            protected Edge convert(EdgeElementData edgeElementData) {
                if (edgeElementData == null) {
                    return null;
                }
                ImmutableSet extendedDataTableNames = edgeElementData.extendedTableNames.size() > 0 ? ImmutableSet.copyOf((Collection)edgeElementData.extendedTableNames) : ImmutableSet.of();
                return new StorableEdge(KVStoreGraph.this, edgeElementData.id, edgeElementData.outVertexId, edgeElementData.inVertexId, edgeElementData.label, null, new Visibility(edgeElementData.visibility), edgeElementData.getProperties(fetchHints), null, null, edgeElementData.hiddenVisibilities.stream().map(Visibility::new).collect(Collectors.toList()), (ImmutableSet<String>)extendedDataTableNames, edgeElementData.timestamp, fetchHints, authorizations);
            }

            @Override
            protected Iterator<EdgeElementData> createIterator() {
                this.iter = KVStoreGraph.this.kvStore.scan(KVStoreGraph.this.getEdgesTableName(), idRange);
                Iterator<Pair> mappingIterator = Iterators.map(o -> Pair.of(KVKeyUtils.storeKey((byte[])o.first()), StoreValue.deserialize((byte[])o.other())), this.iter);
                return new EdgeDecoder(Iterators.prefetching(mappingIterator), KVStoreGraph.this, fetchHints, authorizations).iterator();
            }

            @Override
            public void close() {
                IOUtils.closeQuietly((Closeable)this.iter);
            }
        };
    }

    @Override
    protected Iterable<ExtendedDataRow> getExtendedDataRowsInRange(List ranges, final FetchHints fetchHints, final Authorizations authorizations) {
        ArrayList<3> iterables = new ArrayList<3>();
        for (final IdRange range : ranges) {
            iterables.add(new LookAheadIterable<Pair<StoreKey, StoreValue>, ExtendedDataRow>(){
                ScanIterator iter;
                PrefetchingIterator<Pair<StoreKey, StoreValue>> storeIterable;

                @Override
                protected boolean isIncluded(Pair<StoreKey, StoreValue> src, ExtendedDataRow extendedDataRow) {
                    return extendedDataRow != null;
                }

                @Override
                protected ExtendedDataRow convert(Pair<StoreKey, StoreValue> source) {
                    String nextId;
                    String id;
                    Pair<StoreKey, StoreValue> next;
                    ArrayList<Pair<StoreKey, StoreValue>> mutations = new ArrayList<Pair<StoreKey, StoreValue>>();
                    mutations.add(source);
                    while (this.storeIterable.hasNext() && (next = this.storeIterable.peek()) != null && (id = source.first().id()).equals(nextId = next.first().id())) {
                        mutations.add(this.storeIterable.next());
                    }
                    boolean deleted = false;
                    for (int i = 0; i < mutations.size(); ++i) {
                        Pair pair = (Pair)mutations.get(i);
                        if (!"".equals(((StoreKey)pair.first()).cf()) || !"".equals(((StoreKey)pair.first()).cq()) || !Arrays.equals(ElementMutationBuilder.DELETE_ROW_VALUE, ((StoreValue)pair.other()).value())) continue;
                        deleted = true;
                    }
                    if (deleted) {
                        return null;
                    }
                    return new ExtendedDataDecoder(KVStoreGraph.this, fetchHints, authorizations).decode(mutations);
                }

                @Override
                protected Iterator<Pair<StoreKey, StoreValue>> createIterator() {
                    this.iter = KVStoreGraph.this.kvStore.scan(AbstractStorableGraph.getExtendedDataTableName(), range);
                    Iterator<Pair> mappingIterator = Iterators.map(o -> Pair.of(KVKeyUtils.storeKey((byte[])o.first()), StoreValue.deserialize((byte[])o.other())), this.iter);
                    this.storeIterable = Iterators.prefetching(mappingIterator);
                    return this.storeIterable;
                }

                @Override
                public void close() {
                    IOUtils.closeQuietly((Closeable)this.iter);
                }
            });
        }
        return new CombiningIterable<ExtendedDataRow>(iterables);
    }

    @Override
    protected void addMutations(GeObjectType objectType, StoreMutation ... mutations) {
        this._addMutations(this.getTableFromElementType(objectType), mutations);
    }

    private String getTableFromElementType(GeObjectType objectType) {
        switch (objectType) {
            case VERTEX: {
                return this.getVerticesTableName();
            }
            case EDGE: {
                return this.getEdgesTableName();
            }
            case EXTENDED_DATA: {
                return KVStoreGraph.getExtendedDataTableName();
            }
        }
        throw new GeException("Unexpected object type: " + (Object)((Object)objectType));
    }

    private void _addMutations(String tableName, StoreMutation ... mutations) {
        for (StoreMutation m : mutations) {
            List<StoreColumnUpdate> updates = m.getUpdates();
            for (int i = 0; i < updates.size(); ++i) {
                StoreColumnUpdate u = updates.get(i);
                ByteBuffer key = KVKeyUtils.keyFromMutation(m, u.getColumnFamily(), u.getColumnQualifier(), u.getColumnVisibility());
                if (u.isDeleted()) {
                    this.kvStore.delete(tableName, key.array());
                    continue;
                }
                long ts = u.getTimestamp() == 0L ? IncreasingTime.currentTimeMillis() : u.getTimestamp();
                byte[] storeValue = new StoreValue(ts, u.getValue()).serialize();
                this.kvStore.put(tableName, key.array(), storeValue);
            }
        }
    }

    @Override
    public void dumpGraph() {
        String content;
        File tempFile;
        Throwable throwable;
        ScanIterator iter;
        this.dumpTable(this.getVerticesTableName(), "VERTICES");
        this.dumpTable(this.getEdgesTableName(), "EDGES");
        try {
            iter = this.kvStore.scan(KVStoreGraph.getExtendedDataTableName());
            throwable = null;
            try {
                Iterator<Pair> iter2 = Iterators.map(o -> Pair.of(KVKeyUtils.storeKey((byte[])o.first()), StoreValue.deserialize((byte[])o.other())), iter);
                ArrayList<DumpTableRow> data = new ArrayList<DumpTableRow>();
                while (iter2.hasNext()) {
                    Pair pair2 = iter2.next();
                    StoreKey key = (StoreKey)pair2.first();
                    StoreValue v = (StoreValue)pair2.other();
                    data.add(new DumpTableRow(key.id(), key.cf(), key.cq(), key.visibilityString(), v.ts(), ""));
                }
                tempFile = File.createTempFile(KVStoreGraph.getExtendedDataTableName(), "");
                content = AsciiTable.getTable(data, Arrays.asList(new Column().header("ID").with(row -> row.id), new Column().header("CF").with(row -> row.cf), new Column().header("CQ").with(row -> row.cq), new Column().header("VIS").with(row -> row.vis), new Column().header("TS").with(row -> String.valueOf(row.ts)), new Column().header("VAL").with(row -> row.val)));
                Files.write((CharSequence)content, (File)tempFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable iter2) {
                throwable = iter2;
                throw iter2;
            }
            finally {
                if (iter != null) {
                    if (throwable != null) {
                        try {
                            iter.close();
                        }
                        catch (Throwable iter2) {
                            throwable.addSuppressed(iter2);
                        }
                    } else {
                        iter.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            iter = this.kvStore.scan(this.getMetadataTableName());
            throwable = null;
            try {
                ArrayList<GraphMetadataEntry> data = new ArrayList<GraphMetadataEntry>();
                Iterator<GraphMetadataEntry> iter2 = Iterators.map(pair -> new GraphMetadataEntry(new String((byte[])pair.first()), (byte[])pair.other()), iter);
                while (iter2.hasNext()) {
                    data.add(iter2.next());
                }
                tempFile = File.createTempFile(this.getMetadataTableName(), "");
                content = AsciiTable.getTable(data, Arrays.asList(new Column().header("Key").with(row -> row.getKey()), new Column().header("Value").with(row -> row.getValue() == null ? null : row.getValue().toString())));
                Files.write((CharSequence)content, (File)tempFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (iter != null) {
                    if (throwable != null) {
                        try {
                            iter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        iter.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void dumpTable(String table, String name) {
        try (ScanIterator iter = this.kvStore.scan(table);){
            Iterator<Pair> iter2 = Iterators.map(o -> Pair.of(KVKeyUtils.storeKey((byte[])o.first()), StoreValue.deserialize((byte[])o.other())), iter);
            ArrayList<DumpTableRow> data = new ArrayList<DumpTableRow>();
            while (iter2.hasNext()) {
                Object obj;
                Pair pair = iter2.next();
                StoreKey key = (StoreKey)pair.first();
                StoreValue v = (StoreValue)pair.other();
                try {
                    obj = this.geSerializer.bytesToObject(((StoreValue)pair.other()).value());
                }
                catch (Throwable t) {
                    obj = new String(((StoreValue)pair.other()).value());
                }
                data.add(new DumpTableRow(key.id(), key.cf(), key.cq(), key.visibilityString(), v.ts(), obj != null ? obj.toString() : null));
            }
            File tempFile = File.createTempFile(table, "");
            String content = AsciiTable.getTable(data, Arrays.asList(new Column().header("ID").with(row -> row.id), new Column().header("CF").with(row -> row.cf), new Column().header("CQ").with(row -> row.cq), new Column().header("VIS").with(row -> row.vis), new Column().header("TS").with(row -> String.valueOf(row.ts)), new Column().header("VAL").with(row -> row.val)));
            Files.write((CharSequence)content, (File)tempFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected abstract KVStore createStore();

    public KVStore getKvStore() {
        return this.kvStore;
    }

    private static class DumpTableRow {
        public String id;
        public String cf;
        public String cq;
        public String vis;
        public long ts;
        public String val;

        public DumpTableRow(String id, String cf, String cq, String vis, long ts, String val) {
            this.id = id;
            this.cf = cf;
            this.cq = cq;
            this.vis = vis;
            this.ts = ts;
            this.val = val;
        }
    }
}

