/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.mutations;

import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.EdgeBuilderBase;
import com.mware.ge.Element;
import com.mware.ge.ElementBuilder;
import com.mware.ge.ElementType;
import com.mware.ge.GeException;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.Visibility;
import com.mware.ge.id.NameSubstitutionStrategy;
import com.mware.ge.mutation.ExtendedDataDeleteMutation;
import com.mware.ge.mutation.ExtendedDataMutation;
import com.mware.ge.mutation.PropertyDeleteMutation;
import com.mware.ge.mutation.PropertyPropertyDeleteMutation;
import com.mware.ge.mutation.PropertySoftDeleteMutation;
import com.mware.ge.security.ColumnVisibility;
import com.mware.ge.serializer.GeSerializer;
import com.mware.ge.store.StorableEdge;
import com.mware.ge.store.StorableEdgeInfo;
import com.mware.ge.store.StorableElement;
import com.mware.ge.store.StorableGraph;
import com.mware.ge.store.StorableVertex;
import com.mware.ge.store.TableNameVisibilityPair;
import com.mware.ge.store.mutations.StoreMutation;
import com.mware.ge.store.util.StorableKeyHelper;
import com.mware.ge.store.util.StreamingPropertyValueStorageStrategy;
import com.mware.ge.util.ExtendedDataMutationUtils;
import com.mware.ge.util.IncreasingTime;
import com.mware.ge.util.Preconditions;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.StreamingPropertyValueRef;
import com.mware.ge.values.storable.Value;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;

public abstract class ElementMutationBuilder {
    public static final byte[] EMPTY_VALUE = "".getBytes();
    public static final byte[] DELETE_ROW_VALUE = "DEL_ROW".getBytes(StandardCharsets.UTF_8);
    protected final StreamingPropertyValueStorageStrategy streamingPropertyValueStorageStrategy;
    protected final GeSerializer geSerializer;
    protected final StorableGraph graph;
    protected static final Cache<String, String> propertyMetadataColumnQualifierTextCache = Cache2kBuilder.of(String.class, String.class).entryCapacity(10000L).name(ElementMutationBuilder.class, "propertyMetadataColumnQualifierTextCache").eternal(true).build();

    protected ElementMutationBuilder(StreamingPropertyValueStorageStrategy streamingPropertyValueStorageStrategy, StorableGraph graph, GeSerializer geSerializer) {
        this.streamingPropertyValueStorageStrategy = streamingPropertyValueStorageStrategy;
        this.graph = graph;
        this.geSerializer = geSerializer;
    }

    public void saveVertexBuilder(StorableGraph graph, VertexBuilder vertexBuilder, long timestamp) {
        StoreMutation m = this.createMutationForVertexBuilder(graph, vertexBuilder, timestamp);
        this.saveVertexMutation(m);
        this.saveExtendedDataMutations(graph, ElementType.VERTEX, vertexBuilder);
    }

    private <T extends Element> void saveExtendedDataMutations(StorableGraph graph, ElementType elementType, ElementBuilder<T> elementBuilder) {
        this.saveExtendedData(graph, elementBuilder.getId(), elementType, elementBuilder.getExtendedData(), elementBuilder.getExtendedDataDeletes());
    }

    public void saveExtendedData(StorableGraph graph, String elementId, ElementType elementType, Iterable<ExtendedDataMutation> extendedData, Iterable<ExtendedDataDeleteMutation> extendedDataDeletes) {
        Map<String, Map<String, ExtendedDataMutationUtils.Mutations>> byTableThenRowId = ExtendedDataMutationUtils.getByTableThenRowId(extendedData, extendedDataDeletes);
        for (Map.Entry<String, Map<String, ExtendedDataMutationUtils.Mutations>> byTableThenRowIdEntry : byTableThenRowId.entrySet()) {
            String tableName = byTableThenRowIdEntry.getKey();
            Map<String, ExtendedDataMutationUtils.Mutations> byRowId = byTableThenRowIdEntry.getValue();
            for (Map.Entry<String, ExtendedDataMutationUtils.Mutations> byRowIdEntry : byRowId.entrySet()) {
                String row = byRowIdEntry.getKey();
                ExtendedDataMutationUtils.Mutations mutations = byRowIdEntry.getValue();
                StoreMutation m = new StoreMutation(StorableKeyHelper.createExtendedDataRowKey(elementType, elementId, tableName, row));
                for (ExtendedDataMutation edm : mutations.getExtendedData()) {
                    Value value = this.transformValue(edm.getValue(), null, null);
                    if (graph != null) {
                        graph.ensurePropertyDefined(edm.getColumnName(), value);
                    }
                    m.put((CharSequence)"EXTDATA", (CharSequence)StorableKeyHelper.createExtendedDataColumnQualifier(edm), ElementMutationBuilder.visibilityToColumnVisibility(edm.getVisibility()), this.geSerializer.objectToBytes(value));
                }
                for (ExtendedDataDeleteMutation eddm : mutations.getExtendedDataDeletes()) {
                    m.putDelete("EXTDATA", StorableKeyHelper.createExtendedDataColumnQualifier(eddm), ElementMutationBuilder.visibilityToColumnVisibility(eddm.getVisibility()));
                }
                this.saveExtendedDataMutation(elementType, m);
            }
        }
    }

    protected abstract void saveExtendedDataMutation(ElementType var1, StoreMutation var2);

    protected abstract void saveVertexMutation(StoreMutation var1);

    private StoreMutation createMutationForVertexBuilder(StorableGraph graph, VertexBuilder vertexBuilder, Long timestamp) {
        String vertexRowKey = vertexBuilder.getId();
        StoreMutation m = new StoreMutation(vertexRowKey);
        ColumnVisibility visibility = ElementMutationBuilder.visibilityToColumnVisibility(vertexBuilder.getVisibility());
        String conceptType = vertexBuilder.getConceptType();
        if (vertexBuilder.getNewConceptType() != null && !vertexBuilder.getNewConceptType().equals(conceptType)) {
            conceptType = vertexBuilder.getNewConceptType();
            m.putDelete("V", vertexBuilder.getConceptType(), visibility, IncreasingTime.currentTimeMillis());
        }
        if (timestamp != null) {
            m.put("V", conceptType, visibility, timestamp, EMPTY_VALUE);
        } else {
            m.put((CharSequence)"V", (CharSequence)conceptType, visibility, EMPTY_VALUE);
        }
        this.createMutationForElementBuilder(graph, vertexBuilder, vertexRowKey, m);
        return m;
    }

    private <T extends Element> void createMutationForElementBuilder(StorableGraph graph, ElementBuilder<T> elementBuilder, String rowKey, StoreMutation m) {
        for (PropertyDeleteMutation propertyDeleteMutation : elementBuilder.getPropertyDeletes()) {
            this.addPropertyDeleteToMutation(m, propertyDeleteMutation);
        }
        for (PropertySoftDeleteMutation propertySoftDeleteMutation : elementBuilder.getPropertySoftDeletes()) {
            this.addPropertySoftDeleteToMutation(m, propertySoftDeleteMutation);
        }
        for (Property property : elementBuilder.getProperties()) {
            this.addPropertyToMutation(graph, m, rowKey, property);
        }
        Iterable<ExtendedDataMutation> extendedData = elementBuilder.getExtendedData();
        this.saveExtendedDataMarkers(m, extendedData);
    }

    public void saveExtendedDataMarkers(String elementId, ElementType elementType, Iterable<ExtendedDataMutation> extendedData) {
        Set<TableNameVisibilityPair> uniquePairs = TableNameVisibilityPair.getUniquePairs(extendedData);
        if (uniquePairs.size() == 0) {
            return;
        }
        StoreMutation m = new StoreMutation(elementId);
        for (TableNameVisibilityPair pair : uniquePairs) {
            this.addExtendedDataMarkerToElementMutation(m, pair);
        }
        this.saveElementMutation(elementType, m);
    }

    private void saveElementMutation(ElementType elementType, StoreMutation m) {
        switch (elementType) {
            case VERTEX: {
                this.saveVertexMutation(m);
                break;
            }
            case EDGE: {
                this.saveEdgeMutation(m);
                break;
            }
            default: {
                throw new GeException("Unhandled element type: " + (Object)((Object)elementType));
            }
        }
    }

    private void saveExtendedDataMarkers(StoreMutation m, Iterable<ExtendedDataMutation> extendedData) {
        for (TableNameVisibilityPair pair : TableNameVisibilityPair.getUniquePairs(extendedData)) {
            this.addExtendedDataMarkerToElementMutation(m, pair);
        }
    }

    private void addExtendedDataMarkerToElementMutation(StoreMutation m, TableNameVisibilityPair pair) {
        m.put((CharSequence)"EXTDATA", (CharSequence)pair.getTableName(), ElementMutationBuilder.visibilityToColumnVisibility(pair.getVisibility()), pair.getTableName().getBytes());
    }

    private Value transformValue(Value propertyValue, String rowKey, Property property) {
        if (propertyValue instanceof StreamingPropertyValue) {
            if (rowKey != null && property != null) {
                propertyValue = this.saveStreamingPropertyValue(rowKey, property, (StreamingPropertyValue)propertyValue);
            } else {
                throw new GeException(StreamingPropertyValue.class.getSimpleName() + " are not supported");
            }
        }
        return propertyValue;
    }

    public void saveEdgeBuilder(StorableGraph graph, EdgeBuilderBase edgeBuilder, long timestamp) {
        ColumnVisibility edgeColumnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(edgeBuilder.getVisibility());
        StoreMutation m = this.createMutationForEdgeBuilder(graph, edgeBuilder, edgeColumnVisibility, timestamp);
        this.saveEdgeMutation(m);
        String edgeLabel = edgeBuilder.getNewEdgeLabel() != null ? edgeBuilder.getNewEdgeLabel() : edgeBuilder.getEdgeLabel();
        this.saveEdgeInfoOnVertex(edgeBuilder.getId(), edgeBuilder.getVertexId(Direction.OUT), edgeBuilder.getVertexId(Direction.IN), edgeLabel, edgeColumnVisibility);
        this.saveExtendedDataMutations(graph, ElementType.EDGE, edgeBuilder);
    }

    private void saveEdgeInfoOnVertex(String edgeId, String outVertexId, String inVertexId, String edgeLabel, ColumnVisibility edgeColumnVisibility) {
        StoreMutation addEdgeToOutMutation = new StoreMutation(outVertexId);
        StorableEdgeInfo edgeInfo = new StorableEdgeInfo(this.getNameSubstitutionStrategy().deflate(edgeLabel), inVertexId);
        addEdgeToOutMutation.put((CharSequence)"EOUT", (CharSequence)edgeId, edgeColumnVisibility, edgeInfo.getBytes());
        this.saveVertexMutation(addEdgeToOutMutation);
        StoreMutation addEdgeToInMutation = new StoreMutation(inVertexId);
        edgeInfo = new StorableEdgeInfo(this.getNameSubstitutionStrategy().deflate(edgeLabel), outVertexId);
        addEdgeToInMutation.put((CharSequence)"EIN", (CharSequence)edgeId, edgeColumnVisibility, edgeInfo.getBytes());
        this.saveVertexMutation(addEdgeToInMutation);
    }

    public void alterEdgeLabel(Edge edge, String newEdgeLabel) {
        ColumnVisibility edgeColumnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(edge.getVisibility());
        StoreMutation m = this.createAlterEdgeLabelMutation(edge, newEdgeLabel, edgeColumnVisibility);
        this.saveEdgeMutation(m);
        this.saveEdgeInfoOnVertex((String)edge.getId(), edge.getVertexId(Direction.OUT), edge.getVertexId(Direction.IN), newEdgeLabel, edgeColumnVisibility);
    }

    public void alterVertexConceptType(Vertex vertex, String newConceptType) {
        ColumnVisibility vertexColumnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(vertex.getVisibility());
        StoreMutation m = this.createAlterVertexConceptTypeMutation(vertex, newConceptType, vertexColumnVisibility);
        this.saveVertexMutation(m);
    }

    public static ColumnVisibility visibilityToColumnVisibility(Visibility visibility) {
        return new ColumnVisibility(visibility.getVisibilityString());
    }

    protected abstract void saveEdgeMutation(StoreMutation var1);

    private StoreMutation createMutationForEdgeBuilder(StorableGraph graph, EdgeBuilderBase edgeBuilder, ColumnVisibility edgeColumnVisibility, Long timestamp) {
        String edgeRowKey = edgeBuilder.getId();
        StoreMutation m = new StoreMutation(edgeRowKey);
        String edgeLabel = edgeBuilder.getEdgeLabel();
        if (edgeBuilder.getNewEdgeLabel() != null && !edgeBuilder.getNewEdgeLabel().equals(edgeLabel)) {
            edgeLabel = edgeBuilder.getNewEdgeLabel();
            m.putDelete("E", edgeBuilder.getEdgeLabel(), edgeColumnVisibility, IncreasingTime.currentTimeMillis());
        }
        if (timestamp != null) {
            m.put("E", edgeLabel, edgeColumnVisibility, timestamp, EMPTY_VALUE);
            m.put("EOUT", edgeBuilder.getVertexId(Direction.OUT), edgeColumnVisibility, timestamp, EMPTY_VALUE);
            m.put("EIN", edgeBuilder.getVertexId(Direction.IN), edgeColumnVisibility, timestamp, EMPTY_VALUE);
        } else {
            m.put((CharSequence)"E", (CharSequence)edgeLabel, edgeColumnVisibility, EMPTY_VALUE);
            m.put((CharSequence)"EOUT", (CharSequence)edgeBuilder.getVertexId(Direction.OUT), edgeColumnVisibility, EMPTY_VALUE);
            m.put((CharSequence)"EIN", (CharSequence)edgeBuilder.getVertexId(Direction.IN), edgeColumnVisibility, EMPTY_VALUE);
        }
        this.createMutationForElementBuilder(graph, edgeBuilder, edgeRowKey, m);
        return m;
    }

    private StoreMutation createAlterEdgeLabelMutation(Edge edge, String newEdgeLabel, ColumnVisibility edgeColumnVisibility) {
        Object edgeRowKey = edge.getId();
        StoreMutation m = new StoreMutation((String)edgeRowKey);
        m.putDelete("E", edge.getLabel(), edgeColumnVisibility, IncreasingTime.currentTimeMillis());
        m.put("E", newEdgeLabel, edgeColumnVisibility, IncreasingTime.currentTimeMillis(), EMPTY_VALUE);
        return m;
    }

    private StoreMutation createAlterVertexConceptTypeMutation(Vertex vertex, String newConceptType, ColumnVisibility columnVisibility) {
        Object vertexRowKey = vertex.getId();
        StoreMutation m = new StoreMutation((String)vertexRowKey);
        m.putDelete("V", vertex.getConceptType(), columnVisibility, IncreasingTime.currentTimeMillis());
        m.put("V", newConceptType, columnVisibility, IncreasingTime.currentTimeMillis(), EMPTY_VALUE);
        return m;
    }

    public boolean alterElementVisibility(StoreMutation m, StorableElement element, Visibility newVisibility) {
        ColumnVisibility newColumnVisibility;
        ColumnVisibility currentColumnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(element.getVisibility());
        if (currentColumnVisibility.equals(newColumnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(newVisibility))) {
            return false;
        }
        if (element instanceof StorableEdge) {
            StorableEdge edge = (StorableEdge)element;
            m.putDelete("E", edge.getLabel(), currentColumnVisibility, IncreasingTime.currentTimeMillis());
            m.put("E", edge.getLabel(), newColumnVisibility, IncreasingTime.currentTimeMillis(), EMPTY_VALUE);
            m.putDelete("EOUT", edge.getVertexId(Direction.OUT), currentColumnVisibility, IncreasingTime.currentTimeMillis());
            m.put("EOUT", edge.getVertexId(Direction.OUT), newColumnVisibility, IncreasingTime.currentTimeMillis(), EMPTY_VALUE);
            m.putDelete("EIN", edge.getVertexId(Direction.IN), currentColumnVisibility, IncreasingTime.currentTimeMillis());
            m.put("EIN", edge.getVertexId(Direction.IN), newColumnVisibility, IncreasingTime.currentTimeMillis(), EMPTY_VALUE);
        } else if (element instanceof StorableVertex) {
            StorableVertex vertex = (StorableVertex)element;
            m.putDelete("V", vertex.getConceptType(), currentColumnVisibility, IncreasingTime.currentTimeMillis());
            m.put("V", vertex.getConceptType(), newColumnVisibility, IncreasingTime.currentTimeMillis(), EMPTY_VALUE);
        } else {
            throw new IllegalArgumentException("Invalid element type: " + element);
        }
        return true;
    }

    public boolean alterEdgeVertexOutVertex(StoreMutation vertexOutMutation, Edge edge, Visibility newVisibility) {
        ColumnVisibility newColumnVisibility;
        ColumnVisibility currentColumnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(edge.getVisibility());
        if (currentColumnVisibility.equals(newColumnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(newVisibility))) {
            return false;
        }
        StorableEdgeInfo edgeInfo = new StorableEdgeInfo(this.getNameSubstitutionStrategy().deflate(edge.getLabel()), edge.getVertexId(Direction.IN));
        vertexOutMutation.putDelete("EOUT", (CharSequence)edge.getId(), currentColumnVisibility);
        vertexOutMutation.put((CharSequence)"EOUT", (CharSequence)edge.getId(), newColumnVisibility, edgeInfo.getBytes());
        return true;
    }

    public boolean alterEdgeVertexInVertex(StoreMutation vertexInMutation, Edge edge, Visibility newVisibility) {
        ColumnVisibility newColumnVisibility;
        ColumnVisibility currentColumnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(edge.getVisibility());
        if (currentColumnVisibility.equals(newColumnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(newVisibility))) {
            return false;
        }
        StorableEdgeInfo edgeInfo = new StorableEdgeInfo(this.getNameSubstitutionStrategy().deflate(edge.getLabel()), edge.getVertexId(Direction.OUT));
        vertexInMutation.putDelete("EIN", (CharSequence)edge.getId(), currentColumnVisibility);
        vertexInMutation.put((CharSequence)"EIN", (CharSequence)edge.getId(), newColumnVisibility, edgeInfo.getBytes());
        return true;
    }

    public void addPropertyToMutation(StorableGraph graph, StoreMutation m, String rowKey, Property property) {
        String columnQualifier = StorableKeyHelper.getColumnQualifierFromPropertyColumnQualifier(property, this.getNameSubstitutionStrategy());
        ColumnVisibility columnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(property.getVisibility());
        Value propertyValue = this.transformValue(property.getValue(), rowKey, property);
        if (graph != null) {
            graph.ensurePropertyDefined(property.getName(), propertyValue);
        }
        byte[] value = this.geSerializer.objectToBytes(propertyValue);
        long ts = property.getTimestamp() == null ? IncreasingTime.currentTimeMillis() : property.getTimestamp();
        m.put("PROP", columnQualifier, columnVisibility, ts, value);
        this.addPropertyMetadataToMutation(m, property);
    }

    protected abstract NameSubstitutionStrategy getNameSubstitutionStrategy();

    public void addPropertyDeleteToMutation(StoreMutation m, PropertyDeleteMutation propertyDelete) {
        String columnQualifier = StorableKeyHelper.getColumnQualifierFromPropertyColumnQualifier(propertyDelete.getKey(), propertyDelete.getName(), this.getNameSubstitutionStrategy());
        ColumnVisibility columnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(propertyDelete.getVisibility());
        m.putDelete("PROP", columnQualifier, columnVisibility, IncreasingTime.currentTimeMillis());
        this.addPropertyDeleteMetadataToMutation(m, propertyDelete);
    }

    public void addPropertyMetadataToMutation(StoreMutation m, Property property) {
        Metadata metadata = property.getMetadata();
        for (Metadata.Entry metadataItem : metadata.entrySet()) {
            this.addPropertyMetadataItemToMutation(m, property, metadataItem.getKey(), metadataItem.getValue(), metadataItem.getVisibility());
        }
    }

    public void addPropertyMetadataItemToMutation(StoreMutation m, Property property, String metadataKey, Object metadataValue, Visibility visibility) {
        String columnQualifier = this.getPropertyMetadataColumnQualifierText(property, metadataKey);
        ColumnVisibility metadataVisibility = ElementMutationBuilder.visibilityToColumnVisibility(visibility);
        if (metadataValue == null) {
            this.addPropertyMetadataItemDeleteToMutation(m, columnQualifier, metadataVisibility);
        } else {
            this.addPropertyMetadataItemAddToMutation(m, columnQualifier, metadataVisibility, property.getTimestamp(), metadataValue);
        }
    }

    private void addPropertyMetadataItemAddToMutation(StoreMutation m, String columnQualifier, ColumnVisibility metadataVisibility, Long propertyTimestamp, Object value) {
        byte[] metadataValue = this.geSerializer.objectToBytes(value);
        if (propertyTimestamp != null) {
            m.put("PROPMETA", columnQualifier, metadataVisibility, propertyTimestamp, metadataValue);
        } else {
            m.put((CharSequence)"PROPMETA", (CharSequence)columnQualifier, metadataVisibility, metadataValue);
        }
    }

    private void addPropertyMetadataItemDeleteToMutation(StoreMutation m, String columnQualifier, ColumnVisibility metadataVisibility) {
        m.putDelete("PROPMETA", columnQualifier, metadataVisibility, IncreasingTime.currentTimeMillis());
    }

    private String getPropertyMetadataColumnQualifierText(Property property, String metadataKey) {
        String propertyName = property.getName();
        String propertyKey = property.getKey();
        String visibilityString = property.getVisibility().getVisibilityString();
        StringBuilder keyBuilder = new StringBuilder(propertyName.length() + propertyKey.length() + visibilityString.length() + metadataKey.length());
        keyBuilder.append(this.getNameSubstitutionStrategy().deflate(propertyName));
        keyBuilder.append(this.getNameSubstitutionStrategy().deflate(propertyKey));
        keyBuilder.append(visibilityString);
        keyBuilder.append(this.getNameSubstitutionStrategy().deflate(metadataKey));
        String key = keyBuilder.toString();
        String r = (String)propertyMetadataColumnQualifierTextCache.peek((Object)key);
        if (r == null) {
            r = StorableKeyHelper.getColumnQualifierFromPropertyMetadataColumnQualifier(propertyName, propertyKey, visibilityString, metadataKey, this.getNameSubstitutionStrategy());
            propertyMetadataColumnQualifierTextCache.put((Object)key, (Object)r);
        }
        return r;
    }

    public void addPropertyDeleteMetadataToMutation(StoreMutation m, PropertyDeleteMutation propertyDeleteMutation) {
        if (propertyDeleteMutation instanceof PropertyPropertyDeleteMutation) {
            Property property = ((PropertyPropertyDeleteMutation)propertyDeleteMutation).getProperty();
            Metadata metadata = property.getMetadata();
            for (Metadata.Entry metadataItem : metadata.entrySet()) {
                String columnQualifier = this.getPropertyMetadataColumnQualifierText(property, metadataItem.getKey());
                ColumnVisibility metadataVisibility = ElementMutationBuilder.visibilityToColumnVisibility(metadataItem.getVisibility());
                this.addPropertyMetadataItemDeleteToMutation(m, columnQualifier, metadataVisibility);
            }
        }
    }

    public void addPropertyDeleteToMutation(StoreMutation m, Property property) {
        Preconditions.checkNotNull(m, "mutation cannot be null");
        Preconditions.checkNotNull(property, "property cannot be null");
        String columnQualifier = StorableKeyHelper.getColumnQualifierFromPropertyColumnQualifier(property, this.getNameSubstitutionStrategy());
        ColumnVisibility columnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(property.getVisibility());
        m.putDelete("PROP", columnQualifier, columnVisibility, IncreasingTime.currentTimeMillis());
        for (Metadata.Entry metadataEntry : property.getMetadata().entrySet()) {
            String metadataEntryColumnQualifier = this.getPropertyMetadataColumnQualifierText(property, metadataEntry.getKey());
            ColumnVisibility metadataEntryVisibility = ElementMutationBuilder.visibilityToColumnVisibility(metadataEntry.getVisibility());
            this.addPropertyMetadataItemDeleteToMutation(m, metadataEntryColumnQualifier, metadataEntryVisibility);
        }
    }

    public void addPropertySoftDeleteToMutation(StoreMutation m, Property property) {
        Preconditions.checkNotNull(m, "mutation cannot be null");
        Preconditions.checkNotNull(property, "property cannot be null");
        String columnQualifier = StorableKeyHelper.getColumnQualifierFromPropertyColumnQualifier(property, this.getNameSubstitutionStrategy());
        ColumnVisibility columnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(property.getVisibility());
        m.put("PROPD", columnQualifier, columnVisibility, IncreasingTime.currentTimeMillis(), StorableElement.SOFT_DELETE_VALUE);
    }

    public void addPropertySoftDeleteToMutation(StoreMutation m, PropertySoftDeleteMutation propertySoftDelete) {
        String columnQualifier = StorableKeyHelper.getColumnQualifierFromPropertyColumnQualifier(propertySoftDelete.getKey(), propertySoftDelete.getName(), this.getNameSubstitutionStrategy());
        ColumnVisibility columnVisibility = ElementMutationBuilder.visibilityToColumnVisibility(propertySoftDelete.getVisibility());
        assert (propertySoftDelete.getTimestamp() != null);
        m.put("PROPD", columnQualifier, columnVisibility, propertySoftDelete.getTimestamp(), StorableElement.SOFT_DELETE_VALUE);
    }

    public abstract void saveDataMutation(StoreMutation var1);

    public StoreMutation getDeleteRowMutation(String rowKey) {
        StoreMutation m = new StoreMutation(rowKey);
        m.put("", "", DELETE_ROW_VALUE);
        return m;
    }

    protected StreamingPropertyValueRef saveStreamingPropertyValue(String rowKey, Property property, StreamingPropertyValue propertyValue) {
        return this.streamingPropertyValueStorageStrategy.saveStreamingPropertyValue(this, rowKey, property, propertyValue);
    }
}

