/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.mutations;

import java.util.Arrays;

public class StoreColumnUpdate {
    private byte[] columnFamily;
    private byte[] columnQualifier;
    private byte[] columnVisibility;
    private long timestamp;
    private boolean hasTimestamp;
    private byte[] val;
    private boolean deleted;

    public StoreColumnUpdate(byte[] cf, byte[] cq, byte[] cv, boolean hasts, long ts, boolean deleted, byte[] val) {
        this.columnFamily = cf;
        this.columnQualifier = cq;
        this.columnVisibility = cv;
        this.hasTimestamp = hasts;
        this.timestamp = ts;
        this.deleted = deleted;
        this.val = val;
    }

    public boolean hasTimestamp() {
        return this.hasTimestamp;
    }

    public byte[] getColumnFamily() {
        return this.columnFamily;
    }

    public byte[] getColumnQualifier() {
        return this.columnQualifier;
    }

    public byte[] getColumnVisibility() {
        return this.columnVisibility;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public byte[] getValue() {
        return this.val;
    }

    public String toString() {
        return new String(this.columnFamily) + ":" + new String(this.columnQualifier) + " [" + new String(this.columnVisibility) + "] " + (this.hasTimestamp ? Long.valueOf(this.timestamp) : "NO_TIME_STAMP") + " " + new String(this.val) + " " + this.deleted;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StoreColumnUpdate)) {
            return false;
        }
        StoreColumnUpdate upd = (StoreColumnUpdate)obj;
        return Arrays.equals(this.getColumnFamily(), upd.getColumnFamily()) && Arrays.equals(this.getColumnQualifier(), upd.getColumnQualifier()) && Arrays.equals(this.getColumnVisibility(), upd.getColumnVisibility()) && this.isDeleted() == upd.isDeleted() && Arrays.equals(this.getValue(), upd.getValue()) && this.hasTimestamp() == upd.hasTimestamp() && this.getTimestamp() == upd.getTimestamp();
    }

    public int hashCode() {
        return Arrays.hashCode(this.columnFamily) + Arrays.hashCode(this.columnQualifier) + Arrays.hashCode(this.columnVisibility) + (this.hasTimestamp ? Boolean.TRUE.hashCode() + Long.valueOf(this.timestamp).hashCode() : Boolean.FALSE.hashCode()) + (this.deleted ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode() + Arrays.hashCode(this.val));
    }
}

