/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.mutations;

import com.mware.ge.security.ColumnVisibility;
import com.mware.ge.store.mutations.StoreColumnUpdate;
import com.mware.ge.store.mutations.UnsynchronizedBuffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class StoreMutation {
    private static ThreadLocal<CharsetEncoder> ENCODER_FACTORY = new ThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            return Charset.forName("UTF-8").newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
    };
    public static final byte[] EMPTY_BYTES = new byte[0];
    static final int VALUE_SIZE_COPY_CUTOFF = 32768;
    private byte[] row;
    private byte[] data;
    private int entries;
    private List<byte[]> values;
    private UnsynchronizedBuffer.Writer buffer;
    private List<StoreColumnUpdate> updates;

    public StoreMutation(byte[] row) {
        this(row, 0, row.length);
    }

    public StoreMutation(byte[] row, int start, int length) {
        this(row, start, length, 64);
    }

    public StoreMutation(byte[] row, int start, int length, int initialBufferSize) {
        this.row = new byte[length];
        System.arraycopy(row, start, this.row, 0, length);
        this.buffer = new UnsynchronizedBuffer.Writer(initialBufferSize);
    }

    public StoreMutation() {
    }

    public StoreMutation(String rowId) {
        this.row = this.encode(rowId);
        this.buffer = new UnsynchronizedBuffer.Writer(64);
    }

    private byte[] encode(CharSequence value) {
        try {
            ByteBuffer bb = StoreMutation.encode(value.toString(), true);
            int length = bb.limit();
            byte[] bytes = new byte[length];
            System.arraycopy(bb.array(), 0, bytes, 0, length);
            return bytes;
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException("Should not have happened ", e);
        }
    }

    public byte[] getRow() {
        return this.row;
    }

    private void put(byte[] b) {
        this.put(b, b.length);
    }

    private void put(byte[] b, int length) {
        this.buffer.writeVLong(length);
        this.buffer.add(b, 0, length);
    }

    private void put(boolean b) {
        this.buffer.add(b);
    }

    private void put(int i) {
        this.buffer.writeVLong(i);
    }

    private void put(long l) {
        this.buffer.writeVLong(l);
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, byte[] value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, false, 0L, false, value);
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, long timestamp, byte[] value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, true, timestamp, false, value);
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, ColumnVisibility columnVisibility, byte[] value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), false, 0L, false, value);
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, ColumnVisibility columnVisibility, long timestamp, byte[] value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), true, timestamp, false, value);
    }

    public void putDelete(CharSequence columnFamily, CharSequence columnQualifier) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, false, 0L, true, EMPTY_BYTES);
    }

    public void putDelete(CharSequence columnFamily, CharSequence columnQualifier, ColumnVisibility columnVisibility) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), false, 0L, true, EMPTY_BYTES);
    }

    public void putDelete(CharSequence columnFamily, CharSequence columnQualifier, ColumnVisibility columnVisibility, long timestamp) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), true, timestamp, true, EMPTY_BYTES);
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, byte[] columnVisibility, boolean hasts, long timestamp, boolean deleted, byte[] value) {
        byte[] bcf = this.encode(columnFamily.toString());
        byte[] bcq = this.encode(columnQualifier.toString());
        this.put(bcf, bcf.length, bcq, bcq.length, columnVisibility, hasts, timestamp, deleted, value, value.length);
    }

    private void put(byte[] cf, int cfLength, byte[] cq, int cqLength, byte[] cv, boolean hasts, long ts, boolean deleted, byte[] val, int valLength) {
        if (this.buffer == null) {
            throw new IllegalStateException("Can not add to mutation after serializing it");
        }
        this.put(cf, cfLength);
        this.put(cq, cqLength);
        this.put(cv);
        this.put(hasts);
        if (hasts) {
            this.put(ts);
        }
        this.put(deleted);
        if (valLength < 32768) {
            this.put(val, valLength);
        } else {
            if (this.values == null) {
                this.values = new ArrayList<byte[]>();
            }
            byte[] copy = new byte[valLength];
            System.arraycopy(val, 0, copy, 0, valLength);
            this.values.add(copy);
            this.put(-1 * this.values.size());
        }
        ++this.entries;
    }

    public byte[] serialize() {
        if (this.buffer != null) {
            this.data = this.buffer.toArray();
            this.buffer = null;
        }
        return this.data;
    }

    public List<StoreColumnUpdate> getUpdates() {
        this.serialize();
        UnsynchronizedBuffer.Reader in = new UnsynchronizedBuffer.Reader(this.data);
        if (this.updates == null) {
            if (this.entries == 1) {
                this.updates = Collections.singletonList(this.deserializeColumnUpdate(in));
            } else {
                StoreColumnUpdate[] tmpUpdates = new StoreColumnUpdate[this.entries];
                for (int i = 0; i < this.entries; ++i) {
                    tmpUpdates[i] = this.deserializeColumnUpdate(in);
                }
                this.updates = Arrays.asList(tmpUpdates);
            }
        }
        return this.updates;
    }

    protected StoreColumnUpdate newColumnUpdate(byte[] cf, byte[] cq, byte[] cv, boolean hasts, long ts, boolean deleted, byte[] val) {
        return new StoreColumnUpdate(cf, cq, cv, hasts, ts, deleted, val);
    }

    private StoreColumnUpdate deserializeColumnUpdate(UnsynchronizedBuffer.Reader in) {
        byte[] val;
        byte[] cf = this.readBytes(in);
        byte[] cq = this.readBytes(in);
        byte[] cv = this.readBytes(in);
        boolean hasts = in.readBoolean();
        long ts = 0L;
        if (hasts) {
            ts = in.readVLong();
        }
        boolean deleted = in.readBoolean();
        int valLen = (int)in.readVLong();
        if (valLen < 0) {
            val = this.values.get(-1 * valLen - 1);
        } else if (valLen == 0) {
            val = EMPTY_BYTES;
        } else {
            val = new byte[valLen];
            in.readBytes(val);
        }
        return this.newColumnUpdate(cf, cq, cv, hasts, ts, deleted, val);
    }

    private byte[] readBytes(UnsynchronizedBuffer.Reader in) {
        int len = (int)in.readVLong();
        if (len == 0) {
            return EMPTY_BYTES;
        }
        byte[] bytes = new byte[len];
        in.readBytes(bytes);
        return bytes;
    }

    public static ByteBuffer encode(String string, boolean replace) throws CharacterCodingException {
        CharsetEncoder encoder = ENCODER_FACTORY.get();
        if (replace) {
            encoder.onMalformedInput(CodingErrorAction.REPLACE);
            encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        ByteBuffer bytes = encoder.encode(CharBuffer.wrap(string.toCharArray()));
        if (replace) {
            encoder.onMalformedInput(CodingErrorAction.REPORT);
            encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return bytes;
    }

    public byte[] getData() {
        return this.data;
    }
}

