/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.util;

import com.mware.ge.security.ByteSequence;
import java.util.Objects;

public class HiddenProperty {
    private final ByteSequence key;
    private final ByteSequence name;
    private final ByteSequence visibility;
    private final ByteSequence hiddenVisibility;

    public HiddenProperty(ByteSequence key, ByteSequence name, ByteSequence visibility, ByteSequence hiddenVisibility) {
        this.key = key;
        this.name = name;
        this.visibility = visibility;
        this.hiddenVisibility = hiddenVisibility;
    }

    public boolean matches(ByteSequence propertyKey, ByteSequence propertyName, ByteSequence visibility) {
        return propertyKey.equals((Object)this.key) && propertyName.equals((Object)this.name) && visibility.equals((Object)this.visibility);
    }

    public ByteSequence getHiddenVisibility() {
        return this.hiddenVisibility;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiddenProperty that = (HiddenProperty)o;
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.visibility, that.visibility);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.visibility != null ? this.visibility.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HiddenProperty{key='" + this.key + '\'' + ", name='" + this.name + '\'' + ", visibility='" + this.visibility + '\'' + '}';
    }
}

