/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.util;

import com.mware.ge.Authorizations;
import com.mware.ge.FetchHints;
import com.mware.ge.GeMissingFetchHintException;
import com.mware.ge.Graph;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.property.MutableProperty;
import com.mware.ge.serializer.GeSerializer;
import com.mware.ge.store.util.LazyPropertyMetadata;
import com.mware.ge.store.util.MetadataRef;
import com.mware.ge.values.storable.StreamingPropertyValueRef;
import com.mware.ge.values.storable.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class LazyMutableProperty
extends MutableProperty {
    private final Graph graph;
    private final GeSerializer geSerializer;
    private final String propertyKey;
    private final String propertyName;
    private Long timestamp;
    private final FetchHints fetchHints;
    private Set<Visibility> hiddenVisibilities;
    private byte[] propertyValue;
    private MetadataRef metadataRef;
    private Visibility visibility;
    private transient Value cachedPropertyValue;
    private transient Metadata cachedMetadata;

    public LazyMutableProperty(Graph graph, GeSerializer geSerializer, String propertyKey, String propertyName, byte[] propertyValue, MetadataRef metadataRef, Set<Visibility> hiddenVisibilities, Visibility visibility, long timestamp, FetchHints fetchHints) {
        this.graph = graph;
        this.geSerializer = geSerializer;
        this.propertyKey = propertyKey;
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.metadataRef = metadataRef;
        this.visibility = visibility;
        this.hiddenVisibilities = hiddenVisibilities;
        this.timestamp = timestamp;
        this.fetchHints = fetchHints;
    }

    @Override
    public synchronized void setValue(Value value) {
        this.cachedPropertyValue = value;
        this.propertyValue = null;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public void addHiddenVisibility(Visibility visibility) {
        if (this.hiddenVisibilities == null) {
            this.hiddenVisibilities = new HashSet<Visibility>();
        }
        this.hiddenVisibilities.add(visibility);
    }

    @Override
    public void removeHiddenVisibility(Visibility visibility) {
        if (this.hiddenVisibilities == null) {
            this.hiddenVisibilities = new HashSet<Visibility>();
        }
        this.hiddenVisibilities.remove(visibility);
    }

    @Override
    protected void updateMetadata(Property property) {
        this.cachedMetadata = null;
        if (property instanceof LazyMutableProperty) {
            this.metadataRef = ((LazyMutableProperty)property).metadataRef;
        } else {
            ArrayList<Metadata.Entry> entries = new ArrayList<Metadata.Entry>(property.getMetadata().entrySet());
            this.metadataRef = null;
            if (this.getFetchHints().isIncludePropertyAndMetadata(this.propertyName)) {
                for (Metadata.Entry metadataEntry : entries) {
                    this.getMetadata().add(metadataEntry.getKey(), metadataEntry.getValue(), metadataEntry.getVisibility());
                }
            }
        }
    }

    @Override
    public String getKey() {
        return this.propertyKey;
    }

    @Override
    public String getName() {
        return this.propertyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value getValue() {
        if (this.cachedPropertyValue == null) {
            LazyMutableProperty lazyMutableProperty = this;
            synchronized (lazyMutableProperty) {
                if (this.cachedPropertyValue == null) {
                    if (this.propertyValue == null || this.propertyValue.length == 0) {
                        return null;
                    }
                    this.cachedPropertyValue = (Value)this.geSerializer.bytesToObject(this.propertyValue);
                    this.propertyValue = null;
                    if (this.cachedPropertyValue instanceof StreamingPropertyValueRef) {
                        this.cachedPropertyValue = ((StreamingPropertyValueRef)this.cachedPropertyValue).toStreamingPropertyValue(this.graph, this.getTimestamp());
                    }
                }
            }
        }
        return this.cachedPropertyValue;
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public Metadata getMetadata() {
        if (!this.fetchHints.isIncludePropertyMetadata()) {
            throw new GeMissingFetchHintException(this.fetchHints, "includePropertyMetadata");
        }
        if (this.cachedMetadata == null) {
            if (this.metadataRef == null) {
                this.cachedMetadata = Metadata.create(this.fetchHints);
            } else {
                this.cachedMetadata = new LazyPropertyMetadata(this.metadataRef.getMetadataEntries(), this.metadataRef.getMetadataIndexes(), this.geSerializer, this.graph.getNameSubstitutionStrategy(), this.fetchHints);
                this.metadataRef = null;
            }
        }
        return this.cachedMetadata;
    }

    @Override
    public FetchHints getFetchHints() {
        return this.fetchHints;
    }

    @Override
    public Iterable<Visibility> getHiddenVisibilities() {
        if (this.hiddenVisibilities == null) {
            return new ArrayList<Visibility>();
        }
        return this.hiddenVisibilities;
    }

    @Override
    public boolean isHidden(Authorizations authorizations) {
        if (this.hiddenVisibilities != null) {
            for (Visibility v : this.getHiddenVisibilities()) {
                if (!authorizations.canRead(v)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }
}

