/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.util;

import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Metadata;
import com.mware.ge.Visibility;
import com.mware.ge.id.NameSubstitutionStrategy;
import com.mware.ge.serializer.GeSerializer;
import com.mware.ge.store.util.MetadataEntry;
import com.mware.ge.values.storable.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LazyPropertyMetadata
implements Metadata {
    private static final String KEY_SEPARATOR = "\u001f";
    private transient ReadWriteLock entriesLock = new ReentrantReadWriteLock();
    private final Map<String, Metadata.Entry> entries = new ConcurrentHashMap<String, Metadata.Entry>();
    private final List<MetadataEntry> metadataEntries;
    private int[] metadataIndexes;
    private final Set<String> removedEntries = new HashSet<String>();
    private final GeSerializer geSerializer;
    private final NameSubstitutionStrategy nameSubstitutionStrategy;
    private final FetchHints fetchHints;

    public LazyPropertyMetadata(List<MetadataEntry> metadataEntries, int[] metadataIndexes, GeSerializer geSerializer, NameSubstitutionStrategy nameSubstitutionStrategy, FetchHints fetchHints) {
        this.metadataEntries = metadataEntries;
        this.metadataIndexes = metadataIndexes;
        this.geSerializer = geSerializer;
        this.nameSubstitutionStrategy = nameSubstitutionStrategy;
        this.fetchHints = fetchHints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Metadata add(String key, Value value, Visibility visibility) {
        this.getEntriesLock().writeLock().lock();
        try {
            String mapKey = LazyPropertyMetadata.toMapKey(key, visibility);
            this.removedEntries.remove(mapKey);
            this.entries.put(mapKey, new Entry(key, value, visibility));
            LazyPropertyMetadata lazyPropertyMetadata = this;
            return lazyPropertyMetadata;
        }
        finally {
            this.getEntriesLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key, Visibility visibility) {
        this.getEntriesLock().writeLock().lock();
        try {
            String mapKey = LazyPropertyMetadata.toMapKey(key, visibility);
            this.removedEntries.add(mapKey);
            this.entries.remove(mapKey);
        }
        finally {
            this.getEntriesLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        this.getEntriesLock().writeLock().lock();
        try {
            if (this.metadataIndexes != null && this.metadataEntries != null) {
                for (int metadataIndex : this.metadataIndexes) {
                    MetadataEntry entry = this.metadataEntries.get(metadataIndex);
                    String metadataKey = entry.getMetadataKey(this.nameSubstitutionStrategy);
                    if (!metadataKey.equals(key)) continue;
                    Visibility metadataVisibility = entry.getVisibility();
                    String mapKey = LazyPropertyMetadata.toMapKey(metadataKey, metadataVisibility);
                    this.removedEntries.add(mapKey);
                }
            }
            Object object = new ArrayList<Map.Entry<String, Metadata.Entry>>(this.entries.entrySet()).iterator();
            while (object.hasNext()) {
                Map.Entry e = (Map.Entry)object.next();
                if (!((Metadata.Entry)e.getValue()).getKey().equals(key)) continue;
                this.entries.remove(e.getKey());
            }
        }
        finally {
            this.getEntriesLock().writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.getEntriesLock().writeLock().lock();
        try {
            this.entries.clear();
            if (this.metadataEntries != null) {
                this.metadataEntries.clear();
            }
            this.metadataIndexes = new int[0];
            this.removedEntries.clear();
        }
        finally {
            this.getEntriesLock().writeLock().unlock();
        }
    }

    private void loadAll() {
        if (this.metadataEntries != null && this.metadataIndexes != null) {
            for (int metadataIndex : this.metadataIndexes) {
                Visibility metadataVisibility;
                MetadataEntry metadataEntry = this.metadataEntries.get(metadataIndex);
                String metadataKey = metadataEntry.getMetadataKey(this.nameSubstitutionStrategy);
                String mapKey = LazyPropertyMetadata.toMapKey(metadataKey, metadataVisibility = metadataEntry.getVisibility());
                if (this.removedEntries.contains(mapKey) || this.entries.containsKey(mapKey)) continue;
                LazyEntry lazyEntry = new LazyEntry(metadataKey, metadataVisibility, metadataEntry);
                this.entries.put(mapKey, lazyEntry);
            }
        }
    }

    @Override
    public Collection<Metadata.Entry> entrySet() {
        this.getEntriesLock().readLock().lock();
        try {
            this.loadAll();
            ArrayList<Metadata.Entry> arrayList = new ArrayList<Metadata.Entry>(this.entries.values());
            return arrayList;
        }
        finally {
            this.getEntriesLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Metadata.Entry getEntry(String key, Visibility visibility) {
        String mapKey = LazyPropertyMetadata.toMapKey(key, visibility);
        this.getFetchHints().assertMetadataIncluded(key);
        this.getEntriesLock().readLock().lock();
        if (this.removedEntries.contains(mapKey)) {
            return null;
        }
        try {
            Metadata.Entry entry = this.entries.get(mapKey);
            if (entry != null) {
                Metadata.Entry entry2 = entry;
                return entry2;
            }
            if (this.metadataEntries != null && this.metadataIndexes != null) {
                for (int metadataIndex : this.metadataIndexes) {
                    Visibility metadataVisibility;
                    MetadataEntry metadataEntry = this.metadataEntries.get(metadataIndex);
                    String metadataKey = metadataEntry.getMetadataKey(this.nameSubstitutionStrategy);
                    if (!metadataKey.equals(key) || !(metadataVisibility = metadataEntry.getVisibility()).equals(visibility)) continue;
                    LazyEntry lazyEntry = new LazyEntry(metadataKey, metadataVisibility, metadataEntry);
                    this.entries.put(mapKey, lazyEntry);
                    LazyEntry lazyEntry2 = lazyEntry;
                    return lazyEntry2;
                }
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            this.getEntriesLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Metadata.Entry getEntry(String key) {
        this.getFetchHints().assertMetadataIncluded(key);
        this.getEntriesLock().readLock().lock();
        try {
            Metadata.Entry entry = null;
            for (Map.Entry<String, Metadata.Entry> e : this.entries.entrySet()) {
                if (!e.getValue().getKey().equals(key)) continue;
                if (entry != null) {
                    throw new GeException("Multiple matching entries for key: " + key);
                }
                entry = e.getValue();
            }
            if (this.metadataEntries != null && this.metadataIndexes != null) {
                for (Object metadataIndex : (Metadata.Entry)this.metadataIndexes) {
                    Visibility metadataVisibility;
                    String mapKey;
                    MetadataEntry metadataEntry = this.metadataEntries.get((int)metadataIndex);
                    String metadataKey = metadataEntry.getMetadataKey(this.nameSubstitutionStrategy);
                    if (!metadataKey.equals(key) || this.entries.containsKey(mapKey = LazyPropertyMetadata.toMapKey(metadataKey, metadataVisibility = metadataEntry.getVisibility()))) continue;
                    if (entry != null) {
                        throw new GeException("Multiple matching entries for key: " + key);
                    }
                    entry = new LazyEntry(metadataKey, metadataVisibility, metadataEntry);
                    this.entries.put(mapKey, entry);
                }
            }
            Metadata.Entry entry2 = entry;
            return entry2;
        }
        finally {
            this.getEntriesLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Metadata.Entry> getEntries(String key) {
        this.getFetchHints().assertMetadataIncluded(key);
        this.getEntriesLock().readLock().lock();
        try {
            HashMap<String, Metadata.Entry> results = new HashMap<String, Metadata.Entry>();
            for (Map.Entry<String, Metadata.Entry> e : this.entries.entrySet()) {
                if (!e.getValue().getKey().equals(key)) continue;
                String mapKey = LazyPropertyMetadata.toMapKey(e.getValue().getKey(), e.getValue().getVisibility());
                results.put(mapKey, e.getValue());
            }
            if (this.metadataEntries != null && this.metadataIndexes != null) {
                for (Object metadataIndex : (Collection)this.metadataIndexes) {
                    Visibility metadataVisibility;
                    String mapKey;
                    MetadataEntry metadataEntry = this.metadataEntries.get((int)metadataIndex);
                    String metadataKey = metadataEntry.getMetadataKey(this.nameSubstitutionStrategy);
                    if (!metadataKey.equals(key) || results.containsKey(mapKey = LazyPropertyMetadata.toMapKey(metadataKey, metadataVisibility = metadataEntry.getVisibility()))) continue;
                    LazyEntry entry = new LazyEntry(metadataKey, metadataVisibility, metadataEntry);
                    this.entries.put(mapKey, entry);
                    results.put(mapKey, entry);
                }
            }
            Collection collection = results.values();
            return collection;
        }
        finally {
            this.getEntriesLock().readLock().unlock();
        }
    }

    @Override
    public FetchHints getFetchHints() {
        return this.fetchHints;
    }

    private ReadWriteLock getEntriesLock() {
        if (this.entriesLock == null) {
            this.entriesLock = new ReentrantReadWriteLock();
        }
        return this.entriesLock;
    }

    public static String toMapKey(String key, Visibility visibility) {
        return key + KEY_SEPARATOR + visibility.getVisibilityString();
    }

    private class LazyEntry
    implements Metadata.Entry {
        private final String key;
        private final Visibility visibility;
        private final MetadataEntry metadataEntry;
        private Value metadataValue;

        public LazyEntry(String key, Visibility visibility, MetadataEntry metadataEntry) {
            this.key = key;
            this.visibility = visibility;
            this.metadataEntry = metadataEntry;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Value getValue() {
            if (this.metadataValue == null) {
                this.metadataValue = this.metadataEntry.getValue(LazyPropertyMetadata.this.geSerializer);
                if (this.metadataValue == null) {
                    throw new GeException("Invalid metadata value found.");
                }
            }
            return this.metadataValue;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }
    }

    private static class Entry
    implements Metadata.Entry {
        private final String key;
        private final Value value;
        private final Visibility visibility;

        public Entry(String key, Value value, Visibility visibility) {
            this.key = key;
            this.value = value;
            this.visibility = visibility;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }
    }
}

