/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.util;

import com.mware.ge.Visibility;
import com.mware.ge.id.NameSubstitutionStrategy;
import com.mware.ge.serializer.GeSerializer;
import com.mware.ge.values.storable.Value;
import java.util.Arrays;
import java.util.Objects;

public class MetadataEntry {
    private final String key;
    private final String visibility;
    private final byte[] value;
    private transient String realizedKey;
    private transient Visibility realizedVisibility;
    private transient Value realizedValue;

    public MetadataEntry(String key, String visibility, byte[] value) {
        this.key = key;
        this.visibility = visibility;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataEntry that = (MetadataEntry)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.visibility, that.visibility) && Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.visibility);
    }

    public String getMetadataKey(NameSubstitutionStrategy nameSubstitutionStrategy) {
        if (this.realizedKey != null) {
            return this.realizedKey;
        }
        this.realizedKey = nameSubstitutionStrategy.inflate(this.key);
        return this.realizedKey;
    }

    public Visibility getVisibility() {
        if (this.realizedVisibility != null) {
            return this.realizedVisibility;
        }
        this.realizedVisibility = new Visibility(this.visibility);
        return this.realizedVisibility;
    }

    public Value getValue(GeSerializer geSerializer) {
        if (this.realizedValue != null) {
            return this.realizedValue;
        }
        this.realizedValue = (Value)geSerializer.bytesToObject(this.value);
        return this.realizedValue;
    }
}

