/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store.util;

import com.mware.ge.ElementType;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.GeException;
import com.mware.ge.IdRange;
import com.mware.ge.Property;
import com.mware.ge.id.NameSubstitutionStrategy;
import com.mware.ge.mutation.ExtendedDataMutationBase;
import com.mware.ge.store.util.KeyBase;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public class StorableKeyHelper {
    public static ThreadLocal<CharsetEncoder> ENCODER_FACTORY = ThreadLocal.withInitial(() -> StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));

    public static String createExtendedDataRowKey(ExtendedDataRowId rowId) {
        return StorableKeyHelper.createExtendedDataRowKey(rowId.getElementType(), rowId.getElementId(), rowId.getTableName(), rowId.getRowId());
    }

    public static String createExtendedDataRowKey(ElementType elementType, String elementId, String tableName, String row) {
        StringBuilder sb = new StringBuilder();
        if (elementType != null) {
            String elementTypePrefix = StorableKeyHelper.getExtendedDataRowKeyElementTypePrefix(elementType);
            sb.append(elementTypePrefix);
            if (elementId != null) {
                sb.append(elementId);
                if (tableName != null) {
                    sb.append('\u001f');
                    sb.append(tableName);
                    sb.append('\u001f');
                    if (row != null) {
                        sb.append(row);
                    }
                } else if (row != null) {
                    throw new GeException("Cannot create partial key with missing inner value");
                }
            } else if (tableName != null || row != null) {
                throw new GeException("Cannot create partial key with missing inner value");
            }
        } else if (elementId != null || tableName != null || row != null) {
            throw new GeException("Cannot create partial key with missing inner value");
        }
        return sb.toString();
    }

    public static String createExtendedDataTableKey(ElementType elementType, String elementId, String tableName) {
        String elementTypePrefix = StorableKeyHelper.getExtendedDataRowKeyElementTypePrefix(elementType);
        return elementTypePrefix + elementId + '\u001f' + tableName;
    }

    public static String getExtendedDataRowKeyElementTypePrefix(ElementType elementType) {
        switch (elementType) {
            case VERTEX: {
                return "V";
            }
            case EDGE: {
                return "E";
            }
        }
        throw new GeException("Unhandled element type: " + (Object)((Object)elementType));
    }

    public static IdRange createExtendedDataRowKeyRange(ElementType elementType, IdRange elementIdRange) {
        String elementTypePrefix = StorableKeyHelper.getExtendedDataRowKeyElementTypePrefix(elementType);
        String start = (String)elementIdRange.getStart();
        if (start == null) {
            start = "";
        }
        start = elementTypePrefix + start;
        String end = (String)elementIdRange.getEnd();
        if (end != null) {
            end = elementTypePrefix + end;
        } else if (elementType == ElementType.EDGE) {
            end = StorableKeyHelper.getExtendedDataRowKeyElementTypePrefix(ElementType.VERTEX);
        }
        return new IdRange(start, elementIdRange.isInclusiveStart(), end, elementIdRange.isInclusiveEnd());
    }

    public static String createExtendedDataColumnQualifier(ExtendedDataMutationBase edm) {
        if (edm.getKey() == null) {
            return edm.getColumnName();
        }
        return edm.getColumnName() + '\u001f' + edm.getKey();
    }

    public static String getColumnQualifierFromPropertyColumnQualifier(Property property, NameSubstitutionStrategy nameSubstitutionStrategy) {
        return StorableKeyHelper.getColumnQualifierFromPropertyColumnQualifier(property.getKey(), property.getName(), nameSubstitutionStrategy);
    }

    public static String getColumnQualifierFromPropertyColumnQualifier(String propertyKey, String propertyName, NameSubstitutionStrategy nameSubstitutionStrategy) {
        String name = nameSubstitutionStrategy.deflate(propertyName);
        String key = nameSubstitutionStrategy.deflate(propertyKey);
        KeyBase.assertNoValueSeparator(name);
        KeyBase.assertNoValueSeparator(key);
        return new StringBuilder(name.length() + 1 + key.length()).append(name).append('\u001f').append(key).toString();
    }

    public static String getColumnQualifierFromPropertyMetadataColumnQualifier(String propertyName, String propertyKey, String visibilityString, String metadataKey, NameSubstitutionStrategy nameSubstitutionStrategy) {
        String name = nameSubstitutionStrategy.deflate(propertyName);
        String key = nameSubstitutionStrategy.deflate(propertyKey);
        metadataKey = nameSubstitutionStrategy.deflate(metadataKey);
        KeyBase.assertNoValueSeparator(name);
        KeyBase.assertNoValueSeparator(key);
        KeyBase.assertNoValueSeparator(visibilityString);
        KeyBase.assertNoValueSeparator(metadataKey);
        int charCount = name.length() + key.length() + visibilityString.length() + metadataKey.length() + 3;
        CharBuffer qualifierChars = CharBuffer.allocate(charCount);
        qualifierChars.put(name).put('\u001f').put(key).put('\u001f').put(visibilityString).put('\u001f').put(metadataKey).flip();
        CharsetEncoder encoder = ENCODER_FACTORY.get();
        encoder.reset();
        try {
            ByteBuffer encodedQualifier = encoder.encode(qualifierChars);
            return new String(encodedQualifier.array(), 0, encodedQualifier.limit(), StandardCharsets.UTF_8);
        }
        catch (CharacterCodingException cce) {
            throw new RuntimeException("This should never happen", cce);
        }
    }

    public static String getColumnQualifierForDeleteAllPropertyMetadata(Property property, NameSubstitutionStrategy nameSubstitutionStrategy) {
        String name = nameSubstitutionStrategy.deflate(property.getName());
        String key = nameSubstitutionStrategy.deflate(property.getKey());
        KeyBase.assertNoValueSeparator(name);
        KeyBase.assertNoValueSeparator(key);
        return name + '\u001f' + key + '\u001f';
    }

    public static String getColumnQualifierFromPropertyHiddenColumnQualifier(Property property, NameSubstitutionStrategy nameSubstitutionStrategy) {
        return StorableKeyHelper.getColumnQualifierFromPropertyHiddenColumnQualifier(property.getKey(), property.getName(), property.getVisibility().getVisibilityString(), nameSubstitutionStrategy);
    }

    public static String getColumnQualifierFromPropertyHiddenColumnQualifier(String propertyKey, String propertyName, String visibilityString, NameSubstitutionStrategy nameSubstitutionStrategy) {
        String name = nameSubstitutionStrategy.deflate(propertyName);
        String key = nameSubstitutionStrategy.deflate(propertyKey);
        KeyBase.assertNoValueSeparator(name);
        KeyBase.assertNoValueSeparator(key);
        return new StringBuilder(name.length() + 1 + key.length() + 1 + visibilityString.length()).append(name).append('\u001f').append(key).append('\u001f').append(visibilityString).toString();
    }

    public static ExtendedDataRowId parseExtendedDataRowId(String rowKey) {
        ElementType elementType = StorableKeyHelper.extendedDataRowIdElementTypePrefixToElementType(rowKey.charAt(0));
        String[] parts = rowKey.substring(1).split("\u001f");
        if (parts.length != 3) {
            throw new GeException("Invalid row key found for extended data, expected 3 parts found " + parts.length + ": " + rowKey);
        }
        return new ExtendedDataRowId(elementType, parts[0], parts[1], parts[2]);
    }

    private static ElementType extendedDataRowIdElementTypePrefixToElementType(char c) {
        switch (c) {
            case 'V': {
                return ElementType.VERTEX;
            }
            case 'E': {
                return ElementType.EDGE;
            }
        }
        throw new GeException("Invalid element type prefix: " + c);
    }
}

