/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.tools;

import com.beust.jcommander.Parameter;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.FetchHints;
import com.mware.ge.Graph;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.serializer.GeSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.QuickKryoGeSerializer;
import com.mware.ge.tools.GraphRestore;
import com.mware.ge.tools.GraphToolBase;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.Value;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONObject;

public class GraphBackup
extends GraphToolBase {
    private static GeLogger LOGGER = GeLoggerFactory.getLogger(GraphRestore.class);
    @Parameter(names={"--out", "-o"}, description="Output filename prefix")
    protected String outputFileNamePrefix = null;
    @Parameter(names={"--split", "-s"}, description="Split file when reaching this number of elements")
    protected long batchSize = 300000L;
    protected long batchCount = 0L;
    protected long backupFileIndex = 1L;
    protected GeSerializer serializer = new QuickKryoGeSerializer(true);

    public GraphBackup() {
    }

    public GraphBackup(String rootDir, String outputFileNamePrefix) {
        super(rootDir);
        this.outputFileNamePrefix = outputFileNamePrefix;
    }

    public static void main(String[] args) throws Exception {
        GraphBackup graphBackup = new GraphBackup();
        graphBackup.run(args);
    }

    @Override
    protected void run(String[] args) throws Exception {
        super.run(args);
        OutputStream out = this.createOutputStream();
        try {
            out = this.save(this.getGraph(), out, this.getAuthorizations());
        }
        finally {
            out.flush();
            out.close();
            System.out.println("Created backup file: " + this.getBackupFileName(this.backupFileIndex) + " with " + this.batchCount + " elements");
        }
    }

    private File createBackupFile() throws IOException {
        File backupFile;
        File backupRootDir = new File(this.rootDir);
        if (!backupRootDir.exists()) {
            backupRootDir.mkdir();
        }
        if (!(backupFile = new File(backupRootDir, this.getBackupFileName(this.backupFileIndex))).exists()) {
            backupFile.createNewFile();
        }
        return backupFile;
    }

    private String getBackupFileName(long index) {
        return this.outputFileNamePrefix + "-" + index + ".ge";
    }

    public OutputStream createOutputStream() throws IOException {
        if (this.outputFileNamePrefix == null) {
            return System.out;
        }
        File file = this.createBackupFile();
        return new FileOutputStream(file);
    }

    public OutputStream save(Graph graph, OutputStream out, Authorizations authorizations) throws IOException {
        FetchHints fetchHints = FetchHints.ALL_INCLUDING_HIDDEN;
        return this.save(graph.getVertices(fetchHints, authorizations), graph.getEdges(fetchHints, authorizations), out);
    }

    public OutputStream save(Iterable<Vertex> vertices, Iterable<Edge> edges, OutputStream out) throws IOException {
        out = this.saveVertices(vertices, out);
        return this.saveEdges(edges, out);
    }

    public OutputStream saveVertices(Iterable<Vertex> vertices, OutputStream out) throws IOException {
        for (Vertex vertex : vertices) {
            try {
                this.saveVertex(vertex, out);
                out = this.shouldNextBackupFile(out);
            }
            catch (Exception ex) {
                System.err.println("Cannot save vertex: " + (String)vertex.getId() + ", cause: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return out;
    }

    private OutputStream shouldNextBackupFile(OutputStream out) throws IOException {
        ++this.batchCount;
        if (this.batchCount == this.batchSize) {
            out.flush();
            out.close();
            ++this.backupFileIndex;
            out = this.createOutputStream();
            System.out.println("Created backup file: " + this.getBackupFileName(this.backupFileIndex - 1L) + " with " + this.batchCount + " elements");
            this.batchCount = 0L;
            return out;
        }
        return out;
    }

    public void saveVertex(Vertex vertex, OutputStream out) throws IOException {
        JSONObject json = this.vertexToJson(vertex, true);
        out.write(86);
        out.write(json.toString().getBytes());
        out.write(10);
        this.saveStreamingPropertyValues(out, vertex, true);
    }

    public OutputStream saveEdges(Iterable<Edge> edges, OutputStream out) throws IOException {
        for (Edge edge : edges) {
            try {
                this.saveEdge(edge, out);
                out = this.shouldNextBackupFile(out);
            }
            catch (Exception ex) {
                System.err.println("Cannot save edge: " + (String)edge.getId() + ", cause: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return out;
    }

    public void saveEdge(Edge edge, OutputStream out) throws IOException {
        JSONObject json = this.edgeToJson(edge, true);
        out.write(69);
        out.write(json.toString().getBytes());
        out.write(10);
        this.saveStreamingPropertyValues(out, edge, true);
    }

    public JSONObject vertexToJson(Vertex vertex, boolean encoded) {
        JSONObject json = this.elementToJson(vertex, encoded);
        json.put("conceptType", (Object)vertex.getConceptType());
        return json;
    }

    public JSONObject edgeToJson(Edge edge, boolean encoded) {
        JSONObject json = this.elementToJson(edge, encoded);
        json.put("outVertexId", (Object)edge.getVertexId(Direction.OUT));
        json.put("inVertexId", (Object)edge.getVertexId(Direction.IN));
        json.put("label", (Object)edge.getLabel());
        return json;
    }

    public JSONObject elementToJson(Element element, boolean encoded) {
        JSONObject json = new JSONObject();
        json.put("id", element.getId());
        json.put("visibility", (Object)element.getVisibility().getVisibilityString());
        json.put("properties", (Object)this.propertiesToJson(element.getProperties(), encoded));
        return json;
    }

    public JSONArray propertiesToJson(Iterable<Property> properties, boolean encoded) {
        JSONArray json = new JSONArray();
        for (Property property : properties) {
            if (property.getValue() instanceof StreamingPropertyValue) continue;
            json.put((Object)this.propertyToJson(property, encoded));
        }
        return json;
    }

    public JSONObject propertyToJson(Property property, boolean encoded) {
        Metadata metadata;
        JSONObject json = new JSONObject();
        json.put("key", (Object)property.getKey());
        json.put("name", (Object)property.getName());
        json.put("visibility", (Object)property.getVisibility().getVisibilityString());
        Value value = property.getValue();
        if (!(value instanceof StreamingPropertyValue)) {
            json.put("value", (Object)this.objectToJsonString(value, encoded));
        }
        if ((metadata = property.getMetadata()) != null) {
            json.put("metadata", (Object)this.metadataToJson(metadata, encoded));
        }
        return json;
    }

    public JSONObject metadataToJson(Metadata metadata, boolean encoded) {
        JSONObject json = new JSONObject();
        for (Metadata.Entry m : metadata.entrySet()) {
            json.put(m.getKey(), (Object)this.metadataItemToJson(m, encoded));
        }
        return json;
    }

    public JSONObject metadataItemToJson(Metadata.Entry entry, boolean encoded) {
        JSONObject json = new JSONObject();
        json.put("value", (Object)this.objectToJsonString(entry.getValue(), encoded));
        json.put("visibility", (Object)entry.getVisibility().getVisibilityString());
        return json;
    }

    public void saveStreamingPropertyValues(OutputStream out, Element element, boolean encoded) throws IOException {
        for (Property property : element.getProperties()) {
            if (!(property.getValue() instanceof StreamingPropertyValue)) continue;
            this.saveStreamingProperty(out, property, encoded);
        }
    }

    public void saveStreamingProperty(OutputStream out, Property property, boolean encoded) throws IOException {
        int read;
        StreamingPropertyValue spv = (StreamingPropertyValue)property.getValue();
        JSONObject json = this.propertyToJson(property, encoded);
        json.put("valueType", (Object)spv.getValueType().getName());
        json.put("searchIndex", spv.isSearchIndex());
        out.write(68);
        out.write(json.toString().getBytes());
        out.write(10);
        InputStream in = spv.getInputStream();
        byte[] buffer = new byte[10240];
        while ((read = in.read(buffer)) > 0) {
            out.write(Integer.toString(read).getBytes());
            out.write(10);
            out.write(buffer, 0, read);
            out.write(10);
        }
        out.write(48);
        out.write(10);
    }

    private String objectToJsonString(Value value, boolean encoded) {
        byte[] serialized = this.serializer.objectToBytes(value);
        return encoded ? Base64.encodeBase64String((byte[])serialized) : value.asObjectCopy().toString();
    }
}

