/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.tools;

import com.beust.jcommander.Parameter;
import com.mware.ge.Authorizations;
import com.mware.ge.EdgeBuilder;
import com.mware.ge.Element;
import com.mware.ge.ElementBuilder;
import com.mware.ge.Graph;
import com.mware.ge.Metadata;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.Visibility;
import com.mware.ge.serializer.GeSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.QuickKryoGeSerializer;
import com.mware.ge.tools.GraphToolBase;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.util.IOUtils;
import com.mware.ge.util.JavaSerializableUtils;
import com.mware.ge.values.storable.ByteArray;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.StringValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONObject;

public class GraphRestore
extends GraphToolBase {
    private static GeLogger LOGGER = GeLoggerFactory.getLogger(GraphRestore.class);
    @Parameter(names={"--in", "-i"}, description="Input folder where .ge backup files are located", required=true)
    private final File inputFolder = null;
    @Parameter(names={"--skip", "-s"}, description="Concepts to skip (comma separated)")
    private final String conceptsToSkip;
    LongAdder vertices = new LongAdder();
    LongAdder edges = new LongAdder();
    protected GeSerializer serializer = new QuickKryoGeSerializer(true);
    protected int currentBackupFileIndex = 0;
    protected File[] availableBackupFiles;
    protected Set<String> toSkip = new HashSet<String>();
    protected long skipped = 0L;
    static int COMMIT_BATCH = 1000;
    public static final String BASE64_PREFIX = "base64/java:";

    public GraphRestore() {
        this.conceptsToSkip = null;
    }

    public GraphRestore(String rootDir) {
        super(rootDir);
        this.conceptsToSkip = null;
    }

    public static void main(String[] args) throws Exception {
        GraphRestore graphRestore = new GraphRestore();
        graphRestore.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run(String[] args) throws Exception {
        super.run(args);
        if (!this.inputFolder.isDirectory()) {
            throw new IllegalArgumentException("The provided input folder is not a directory");
        }
        if (this.conceptsToSkip != null) {
            this.toSkip.addAll(Arrays.asList(this.conceptsToSkip.split(",")));
        }
        this.availableBackupFiles = this.listBackupFiles();
        try (InputStream in = this.createInputStream();){
            long nrRestored = this.restore(this.getGraph(), in, this.getAuthorizations(), 0L);
            System.out.println("TOTAL: " + nrRestored + " elements were restored");
        }
    }

    private File[] listBackupFiles() {
        return (File[])Arrays.stream((Object[])Objects.requireNonNull(this.inputFolder.listFiles(f -> f.getName().endsWith(".ge")))).sorted(Comparator.comparing(File::getName)).toArray(File[]::new);
    }

    public InputStream createInputStream() throws FileNotFoundException {
        File bkpFile = this.availableBackupFiles[this.currentBackupFileIndex];
        System.out.println("Loading backup file: " + bkpFile.getName());
        return new FileInputStream(bkpFile);
    }

    public long restore(Graph graph, InputStream in, Authorizations authorizations, long nrRestored) throws IOException {
        String line;
        char lastType = 'V';
        boolean elementCreated = false;
        Element element = null;
        while ((line = this.readLine(in)) != null) {
            try {
                char type = line.charAt(0);
                switch (type) {
                    case 'V': {
                        JSONObject json;
                        try {
                            json = new JSONObject(line.substring(1));
                            element = this.restoreVertex(graph, json, authorizations);
                            if (element == null) {
                                this.skipToNextElement(in);
                                ++this.skipped;
                                break;
                            }
                            elementCreated = true;
                            if (++nrRestored % (long)COMMIT_BATCH != 0L) break;
                            System.out.println("Restored: " + nrRestored + " elements");
                            graph.flush();
                        }
                        catch (Exception ex) {
                            System.err.println("Cannot create vertex: " + ex.getMessage());
                            ex.printStackTrace();
                            elementCreated = false;
                            this.skipToNextElement(in);
                        }
                        break;
                    }
                    case 'E': {
                        JSONObject json;
                        if (type != lastType) {
                            graph.flush();
                        }
                        try {
                            json = new JSONObject(line.substring(1));
                            element = this.restoreEdge(graph, json, authorizations);
                            elementCreated = true;
                            if (++nrRestored % (long)COMMIT_BATCH != 0L) break;
                            System.out.println("Restored: " + nrRestored + " elements");
                            graph.flush();
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Cannot create edge: " + ex.getMessage(), new Object[0]);
                            ex.printStackTrace();
                            elementCreated = false;
                            this.skipToNextElement(in);
                        }
                        break;
                    }
                    case 'D': {
                        JSONObject json = new JSONObject(line.substring(1));
                        this.restoreStreamingPropertyValue(in, graph, json, element, authorizations, elementCreated);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected line: " + line);
                    }
                }
                lastType = type;
            }
            catch (Exception ex) {
                LOGGER.warn("Invalid line: " + line, ex);
            }
        }
        ++this.currentBackupFileIndex;
        if (this.currentBackupFileIndex < this.availableBackupFiles.length) {
            in = this.createInputStream();
            nrRestored = this.restore(graph, in, authorizations, nrRestored);
        }
        return nrRestored;
    }

    private void skipToNextElement(InputStream in) throws Exception {
        String line;
        while ((line = this.readLine(in)) != null) {
            char type = line.charAt(0);
            if (type != 'D') continue;
            JSONObject json = new JSONObject(line.substring(1));
            this.restoreStreamingPropertyValue(in, this.getGraph(), json, null, this.getAuthorizations(), false);
            return;
        }
    }

    private String readLine(InputStream in) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while (true) {
            int b;
            if ((b = in.read()) < 0) {
                if (buffer.size() != 0) break;
                return null;
            }
            if (b == 10) break;
            buffer.write(b);
        }
        return new String(buffer.toByteArray());
    }

    private Element restoreVertex(Graph graph, JSONObject json, Authorizations authorizations) {
        Visibility visibility = this.jsonToVisibility(json);
        String vertexId = json.getString("id");
        VertexBuilder v = graph.prepareVertex(vertexId, visibility, "thing");
        this.jsonToProperties(json, v);
        if (this.toSkip.contains(v.getConceptType())) {
            return null;
        }
        this.vertices.increment();
        return v.save(authorizations);
    }

    private Element restoreEdge(Graph graph, JSONObject json, Authorizations authorizations) {
        Visibility visibility = this.jsonToVisibility(json);
        String edgeId = json.getString("id");
        String outVertexId = json.getString("outVertexId");
        String inVertexId = json.getString("inVertexId");
        String label = json.getString("label");
        Vertex outVertex = graph.getVertex(outVertexId, authorizations);
        Vertex inVertex = graph.getVertex(inVertexId, authorizations);
        EdgeBuilder e = graph.prepareEdge(edgeId, outVertex, inVertex, label, visibility);
        this.jsonToProperties(json, e);
        this.edges.increment();
        return e.save(authorizations);
    }

    protected Visibility jsonToVisibility(JSONObject jsonObject) {
        String visibility = jsonObject.optString("visibility", "");
        return new Visibility(visibility);
    }

    protected void jsonToProperties(JSONObject jsonObject, ElementBuilder e) {
        JSONArray propertiesJson = jsonObject.getJSONArray("properties");
        for (int i = 0; i < propertiesJson.length(); ++i) {
            JSONObject propertyJson = propertiesJson.getJSONObject(i);
            if ("conceptType".equals(propertyJson.getString("name"))) {
                ((VertexBuilder)e).setConceptType(propertyJson.getString("value"));
                continue;
            }
            this.jsonToProperty(propertyJson, e);
        }
    }

    private void jsonToProperty(JSONObject propertyJson, ElementBuilder e) {
        String key = propertyJson.getString("key");
        String name = propertyJson.getString("name");
        Value value = this.jsonStringToObject(propertyJson.getString("value"));
        Metadata metadata = this.jsonToPropertyMetadata(propertyJson.optJSONObject("metadata"));
        Visibility visibility = new Visibility(propertyJson.getString("visibility"));
        e.addPropertyValue(key, name, value, metadata, visibility);
    }

    private void restoreStreamingPropertyValue(InputStream in, Graph graph, JSONObject propertyJson, Element element, Authorizations authorizations, boolean elementCreated) throws ClassNotFoundException, IOException {
        String key = propertyJson.getString("key");
        String name = propertyJson.getString("name");
        Metadata metadata = this.jsonToPropertyMetadata(propertyJson.optJSONObject("metadata"));
        Visibility visibility = new Visibility(propertyJson.getString("visibility"));
        Class<Object> valueType = Class.forName(propertyJson.getString("valueType"));
        if (String.class.equals(valueType)) {
            valueType = StringValue.class;
        }
        if (byte[].class.equals(valueType)) {
            valueType = ByteArray.class;
        }
        StreamingPropertyValueInputStream spvin = new StreamingPropertyValueInputStream(in);
        if (elementCreated) {
            StreamingPropertyValue value = StreamingPropertyValue.create(spvin, valueType);
            value.searchIndex(TextValue.class.isAssignableFrom(valueType));
            element.addPropertyValue(key, name, value, metadata, visibility, authorizations);
        } else {
            IOUtils.copy(spvin, new ByteArrayOutputStream());
        }
    }

    private Metadata jsonToPropertyMetadata(JSONObject metadataJson) {
        Metadata metadata = Metadata.create();
        if (metadataJson == null) {
            return metadata;
        }
        for (Object key : metadataJson.keySet()) {
            String keyString = (String)key;
            if ("confidence".equals(keyString) || "http://bigconnect#confidence".equals(keyString)) continue;
            JSONObject metadataItemJson = metadataJson.getJSONObject(keyString);
            Value val = this.jsonStringToObject(metadataItemJson.getString("value"));
            Visibility visibility = new Visibility(metadataItemJson.getString("visibility"));
            metadata.add(keyString, val, visibility);
        }
        return metadata;
    }

    private Value jsonStringToObject(String str) {
        if (str.startsWith(BASE64_PREFIX)) {
            Object obj = JavaSerializableUtils.bytesToObject(Base64.decodeBase64((String)(str = str.substring(BASE64_PREFIX.length()))));
            if (obj instanceof Date) {
                ZonedDateTime zdt = ZonedDateTime.ofInstant(((Date)obj).toInstant(), ZoneOffset.systemDefault());
                return DateTimeValue.datetime(zdt);
            }
            Value v = Values.of(obj);
            return v;
        }
        return Values.stringValue(str);
    }

    public InputStream createInputStream(String fileName) throws FileNotFoundException {
        return new FileInputStream(new File(this.rootDir, fileName));
    }

    public Optional<String> getLastBackupFile(String backupFilePrefix) {
        return Arrays.stream(new File(this.rootDir).listFiles(f -> f.getName().startsWith(backupFilePrefix))).sorted((f1, f2) -> {
            String date1Value = f1.getName().replace(backupFilePrefix, "").replace(".ge", "");
            LocalDateTime date1 = LocalDateTime.parse(date1Value, BACKUP_DATETIME_FORMATTER);
            String date2Value = f2.getName().replace(backupFilePrefix, "").replace(".ge", "");
            LocalDateTime date2 = LocalDateTime.parse(date2Value, BACKUP_DATETIME_FORMATTER);
            return date2.compareTo(date1);
        }).map(f -> f.getName()).findFirst();
    }

    private class StreamingPropertyValueInputStream
    extends InputStream {
        private final InputStream in;
        private int segmentLength;
        private boolean done;

        public StreamingPropertyValueInputStream(InputStream in) throws IOException {
            this.in = in;
            this.readSegmentLengthLine();
        }

        private void readSegmentLengthLine() throws IOException {
            String line = GraphRestore.this.readLine(this.in);
            this.segmentLength = Integer.parseInt(line);
            if (this.segmentLength == 0) {
                this.done = true;
            }
        }

        @Override
        public int read() throws IOException {
            if (this.done) {
                return -1;
            }
            if (this.segmentLength == 0) {
                this.in.read();
                this.readSegmentLengthLine();
                if (this.done) {
                    return -1;
                }
            }
            int ret = this.in.read();
            --this.segmentLength;
            return ret;
        }
    }
}

