/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.tools;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.collect.Lists;
import com.mware.ge.Authorizations;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.GraphFactory;
import com.mware.ge.util.ConfigurationUtils;
import java.io.File;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Parameters(separators="=")
public abstract class GraphToolBase {
    public static final DateTimeFormatter BACKUP_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss");
    public static final String DEFAULT_GRAPH_BACKUP_EXT = ".ge";
    @Parameter(names={"-c", "--config"}, description="Configuration file name")
    private List<String> configFileNames = new ArrayList<String>();
    @Parameter(names={"-a", "--auth"}, description="Comma separated string of Authorizations")
    private String authString = "administrator";
    @Parameter(names={"-cd"}, description="Configuration directories (all files ending in .properties)")
    private List<String> configDirectories = new ArrayList<String>();
    @Parameter(names={"-cp"}, description="Configuration property prefix")
    private String configPropertyPrefix = null;
    private Graph graph;
    protected String rootDir = System.getProperty("user.dir");

    public GraphToolBase() {
    }

    public GraphToolBase(String rootDir) {
        this.rootDir = rootDir;
    }

    protected void run(String[] args) throws Exception {
        new JCommander((Object)this, args);
        this.addConfigDirectoriesToConfigFileNames(this.configDirectories, this.configFileNames);
        Map<String, String> config = ConfigurationUtils.loadConfig(this.configFileNames, this.configPropertyPrefix);
        this.graph = new GraphFactory().createGraph(config);
    }

    private void addConfigDirectoriesToConfigFileNames(List<String> configDirectories, List<String> configFileNames) {
        for (String configDirectory : configDirectories) {
            this.addConfigDirectoryToConfigFileNames(configDirectory, configFileNames);
        }
    }

    private void addConfigDirectoryToConfigFileNames(String configDirectory, List<String> configFileNames) {
        File dir = new File(configDirectory);
        if (!dir.exists()) {
            throw new GeException("Directory does not exist: " + dir.getAbsolutePath());
        }
        List files = Lists.newArrayList((Object[])dir.listFiles()).stream().filter(File::isFile).map(File::getName).filter(f -> f.endsWith(".properties")).collect(Collectors.toList());
        Collections.sort(files);
        files = files.stream().map(f -> new File(dir, (String)f).getAbsolutePath()).collect(Collectors.toList());
        configFileNames.addAll(files);
    }

    protected Authorizations getAuthorizations() {
        String[] split = this.authString.split(",");
        if (split.length == 1 && split[0].length() == 0) {
            split = new String[]{};
        }
        return new Authorizations(split);
    }

    protected Graph getGraph() {
        return this.graph;
    }

    public String getAbsoluteFilePath(String filename) {
        return new File(this.rootDir, filename).getAbsolutePath();
    }
}

