/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.traversal;

import com.google.common.collect.ImmutableList;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.Path;
import com.mware.ge.collection.Iterables;
import com.mware.ge.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class GeTraverser {
    private final Graph graph;
    private final Authorizations authorizations;
    public static final long DEFAULT_CAPACITY = 10000000L;
    public static final long DEFAULT_DEGREE = 10000L;
    public static final long DEFAULT_SKIP_DEGREE = 100000L;
    public static final int DEFAULT_MAX_DEPTH = 50;
    public static final long NO_LIMIT = -1L;

    public GeTraverser(Graph graph, Authorizations authorizations) {
        this.graph = graph;
        this.authorizations = authorizations;
    }

    protected void checkVertexExist(String vertexId) {
        if (!this.graph.doesVertexExist(vertexId, this.authorizations)) {
            throw new GeException(String.format("Vertex %s does not exist", vertexId));
        }
    }

    protected Iterator<Edge> edgesOfVertex(String source, Direction dir, String label, long limit) {
        return Iterables.limit((int)limit, this.graph.getVertex(source, this.authorizations).getEdges(dir, label, this.authorizations)).iterator();
    }

    public static void checkCapacity(long capacity, long access, String traverse) {
        if (capacity != -1L && access > capacity) {
            throw new GeException(String.format("Exceed capacity '%s' while finding %s", capacity, traverse));
        }
    }

    public static Iterator<Edge> skipSuperNodeIfNeeded(Iterator<Edge> edges, long degree, long skipDegree) {
        if (skipDegree <= 0L) {
            return edges;
        }
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        int i = 1;
        while (edges.hasNext()) {
            Edge edge = edges.next();
            if ((long)i <= degree) {
                edgeList.add(edge);
            }
            if ((long)i >= skipDegree) {
                return Collections.emptyIterator();
            }
            ++i;
        }
        return edgeList.iterator();
    }

    protected static <V> Set<V> newSet() {
        return new HashSet();
    }

    protected static <K, V> Map<K, V> newMap() {
        return new HashMap();
    }

    public static class PathSet
    extends HashSet<Path> {
        private static final long serialVersionUID = -8237531948776524872L;

        public Set<String> vertices() {
            HashSet<String> vertices = new HashSet<String>();
            for (Path path : this) {
                vertices.addAll(path.vertices());
            }
            return vertices;
        }
    }

    public static class Node {
        private String id;
        private Node parent;

        public Node(String id) {
            this(id, null);
        }

        public Node(String id, Node parent) {
            Preconditions.checkNotNull(id);
            this.id = id;
            this.parent = parent;
        }

        public String id() {
            return this.id;
        }

        public Node parent() {
            return this.parent;
        }

        public List<String> path() {
            ArrayList<String> ids = new ArrayList<String>();
            Node current = this;
            do {
                ids.add(current.id);
            } while ((current = current.parent) != null);
            Collections.reverse(ids);
            return ids;
        }

        public List<String> joinPath(Node back) {
            List<String> path = this.path();
            List<String> backPath = back.path();
            Collections.reverse(backPath);
            if (CollectionUtils.containsAny(path, backPath)) {
                return ImmutableList.of();
            }
            path.addAll(backPath);
            return path;
        }

        public boolean contains(String id) {
            Node node = this;
            do {
                if (!node.id.equals(id)) continue;
                return true;
            } while ((node = node.parent) != null);
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Node)) {
                return false;
            }
            Node other = (Node)object;
            return Objects.equals(this.id, other.id) && Objects.equals(this.parent, other.parent);
        }
    }
}

