/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.traversal;

import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.Graph;
import com.mware.ge.Path;
import com.mware.ge.collection.Iterators;
import com.mware.ge.traversal.GeTraverser;
import com.mware.ge.util.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class ShortestPathGeTraverser
extends GeTraverser {
    public ShortestPathGeTraverser(Graph graph, Authorizations authorizations) {
        super(graph, authorizations);
    }

    public Path shortestPath(String sourceV, String targetV) {
        return this.shortestPath(sourceV, targetV, Direction.BOTH, null, 50, 10000L, 100000L, 10000000L);
    }

    public Path shortestPath(String sourceV, String targetV, Direction dir, String label, int depth, long degree, long skipDegree, long capacity) {
        GeTraverser.PathSet paths;
        Preconditions.checkNotNull(sourceV);
        Preconditions.checkNotNull(targetV);
        this.checkVertexExist(sourceV);
        this.checkVertexExist(targetV);
        Preconditions.checkNotNull(dir);
        if (sourceV.equals(targetV)) {
            return new Path(sourceV);
        }
        InnerSpTraverser traverser = new InnerSpTraverser(sourceV, targetV, dir, label, degree, skipDegree, capacity);
        while ((paths = traverser.forward(false)).isEmpty() && --depth > 0) {
            ShortestPathGeTraverser.checkCapacity(traverser.capacity, traverser.size, "shortest path");
            paths = traverser.backward(false);
            if (!paths.isEmpty() || --depth <= 0) {
                if (paths.isEmpty()) break;
                Path path = (Path)paths.iterator().next();
                Collections.reverse(path.vertices());
                break;
            }
            ShortestPathGeTraverser.checkCapacity(traverser.capacity, traverser.size, "shortest path");
        }
        return paths.isEmpty() ? Path.EMPTY_PATH : (Path)paths.iterator().next();
    }

    private class InnerSpTraverser {
        private Map<String, GeTraverser.Node> sources = GeTraverser.newMap();
        private Map<String, GeTraverser.Node> targets = GeTraverser.newMap();
        private final Direction direction;
        private final String label;
        private final long degree;
        private final long skipDegree;
        private final long capacity;
        private long size;

        public InnerSpTraverser(String sourceV, String targetV, Direction dir, String label, long degree, long skipDegree, long capacity) {
            this.sources.put(sourceV, new GeTraverser.Node(sourceV));
            this.targets.put(targetV, new GeTraverser.Node(targetV));
            this.direction = dir;
            this.label = label;
            this.degree = degree;
            this.skipDegree = skipDegree;
            this.capacity = capacity;
            this.size = 0L;
        }

        public GeTraverser.PathSet forward(boolean all) {
            GeTraverser.PathSet paths = new GeTraverser.PathSet();
            Map<String, GeTraverser.Node> newVertices = GeTraverser.newMap();
            long degree = this.skipDegree > 0L ? this.skipDegree : this.degree;
            for (GeTraverser.Node v : this.sources.values()) {
                Iterator<Edge> edges = ShortestPathGeTraverser.this.edgesOfVertex(v.id(), this.direction, this.label, degree);
                edges = GeTraverser.skipSuperNodeIfNeeded(edges, this.degree, this.skipDegree);
                while (edges.hasNext()) {
                    Edge edge = edges.next();
                    String target = edge.getOtherVertexId(v.id());
                    if (this.targets.containsKey(target)) {
                        if (this.superNode(target, this.direction)) continue;
                        paths.add(new Path(v.joinPath(this.targets.get(target)).toArray(new String[0])));
                        if (!all) {
                            return paths;
                        }
                    }
                    if (newVertices.containsKey(target) || this.sources.containsKey(target) || v.contains(target)) continue;
                    newVertices.put(target, new GeTraverser.Node(target, v));
                }
            }
            this.sources = newVertices;
            this.size += (long)newVertices.size();
            return paths;
        }

        public GeTraverser.PathSet backward(boolean all) {
            GeTraverser.PathSet paths = new GeTraverser.PathSet();
            Map<String, GeTraverser.Node> newVertices = GeTraverser.newMap();
            long degree = this.skipDegree > 0L ? this.skipDegree : this.degree;
            Direction opposite = this.direction.reverse();
            for (GeTraverser.Node v : this.targets.values()) {
                Iterator<Edge> edges = ShortestPathGeTraverser.this.edgesOfVertex(v.id(), opposite, this.label, degree);
                edges = GeTraverser.skipSuperNodeIfNeeded(edges, this.degree, this.skipDegree);
                while (edges.hasNext()) {
                    Edge edge = edges.next();
                    String target = edge.getOtherVertexId(v.id());
                    if (this.sources.containsKey(target)) {
                        if (this.superNode(target, opposite)) continue;
                        paths.add(new Path(v.joinPath(this.sources.get(target)).toArray(new String[0])));
                        if (!all) {
                            return paths;
                        }
                    }
                    if (newVertices.containsKey(target) || this.targets.containsKey(target) || v.contains(target)) continue;
                    newVertices.put(target, new GeTraverser.Node(target, v));
                }
            }
            this.targets = newVertices;
            this.size += (long)newVertices.size();
            return paths;
        }

        private boolean superNode(String vertex, Direction direction) {
            if (this.skipDegree <= 0L) {
                return false;
            }
            Iterator<Edge> edges = ShortestPathGeTraverser.this.edgesOfVertex(vertex, direction, this.label, this.skipDegree);
            return Iterators.count(edges) >= this.skipDegree;
        }
    }
}

