/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.type;

import com.mware.ge.GeException;
import com.mware.ge.type.GeoShape;
import com.mware.ge.type.GeoShapeBase;
import java.util.ArrayList;
import java.util.List;

public class GeoCollection
extends GeoShapeBase {
    private List<GeoShape> geoShapes = new ArrayList<GeoShape>();

    public GeoCollection() {
    }

    public GeoCollection(List<GeoShape> geoShapes) {
        this.geoShapes.addAll(geoShapes);
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        return this.geoShapes.stream().anyMatch(shape -> shape.intersects(geoShape));
    }

    @Override
    public boolean within(GeoShape geoShape) {
        return this.geoShapes.stream().allMatch(shape -> shape.within(geoShape));
    }

    public GeoCollection addShape(GeoShape geoShape) {
        this.geoShapes.add(geoShape);
        return this;
    }

    public GeoCollection addShapes(List<GeoShape> geoShapes) {
        this.geoShapes.addAll(geoShapes);
        return this;
    }

    public List<GeoShape> getGeoShapes() {
        return this.geoShapes;
    }

    @Override
    public void validate() {
        if (this.geoShapes.size() < 1) {
            throw new GeException("A GeoCollection must contain at least one shape.");
        }
        this.geoShapes.forEach(GeoShape::validate);
    }

    public int hashCode() {
        return this.geoShapes.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.geoShapes.equals(((GeoCollection)obj).geoShapes);
    }
}

