/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.type;

import com.mware.ge.GeException;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.type.GeoShapeBase;
import com.mware.ge.util.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class GeoLine
extends GeoShapeBase {
    private static final long serialVersionUID = 5523982042809683074L;
    private GeoPoint[] geoPoints;

    public GeoLine(List<GeoPoint> geoPoints) {
        this(geoPoints.toArray(new GeoPoint[0]));
    }

    public GeoLine(GeoPoint[] value) {
        assert (value != null);
        this.geoPoints = value;
        this.validate();
    }

    public GeoLine(GeoPoint start, GeoPoint end) {
        Preconditions.checkNotNull(start, "start is required");
        Preconditions.checkNotNull(end, "end is required");
        this.geoPoints = new GeoPoint[2];
        this.geoPoints[0] = start;
        this.geoPoints[1] = end;
    }

    @Override
    public void validate() {
        if (this.geoPoints.length < 2) {
            throw new GeException("A GeoLine must have at least two points.");
        }
    }

    public GeoLine addGeoPoint(GeoPoint point) {
        this.geoPoints = new GeoPoint[this.geoPoints.length + 1];
        this.geoPoints[this.geoPoints.length - 1] = point;
        return this;
    }

    public GeoLine addGeoPoints(List<GeoPoint> points) {
        int position = this.geoPoints.length;
        this.geoPoints = new GeoPoint[position + points.size()];
        GeoPoint[] geoPointToAdd = new GeoPoint[points.size()];
        points.toArray(geoPointToAdd);
        System.arraycopy(geoPointToAdd, 0, this.geoPoints, position, geoPointToAdd.length);
        return this;
    }

    public void setGeoPoints(List<GeoPoint> geoPoints) {
        this.geoPoints = geoPoints.toArray(new GeoPoint[0]);
    }

    public List<GeoPoint> getGeoPoints() {
        return Arrays.asList(this.geoPoints);
    }

    public GeoPoint[] points() {
        return this.geoPoints;
    }

    public int hashCode() {
        return Arrays.hashCode(this.geoPoints);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals(this.geoPoints, ((GeoLine)obj).geoPoints);
    }

    public String toString() {
        return "GeoLine[" + Arrays.stream(this.geoPoints).map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }
}

