/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.type;

import com.mware.ge.type.GeInvalidShapeException;
import com.mware.ge.type.GeoShape;
import com.mware.ge.type.GeoShapeBase;
import com.mware.ge.type.GeoUtils;
import com.mware.ge.util.Preconditions;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GeoPoint
extends GeoShapeBase
implements Comparable<GeoPoint> {
    private static final long serialVersionUID = 1L;
    private static final double COMPARE_TOLERANCE = 1.0E-4;
    private static final Pattern HOUR_MIN_SECOND_PATTERN = Pattern.compile("\\s*(-)?([0-9\\.]+)\u00b0(\\s*([0-9\\.]+)'(\\s*([0-9\\.]+)\")?)?");
    public static final double EQUALS_TOLERANCE_KM = 0.001;
    private final double latitude;
    private final double longitude;
    private double altitude = 0.0;
    private double accuracy = 0.0;

    protected GeoPoint() {
        this(0.0, 0.0);
    }

    public GeoPoint(double latitude, double longitude, double altitude, double accuracy) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.accuracy = accuracy;
    }

    public GeoPoint(double latitude, double longitude, double altitude) {
        this(latitude, longitude, altitude, 0.0);
    }

    public GeoPoint(double latitude, double longitude) {
        this(latitude, longitude, 0.0);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public Double getAccuracy() {
        return this.accuracy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.getLatitude()).append(", ").append(this.getLongitude());
        if (this.getAltitude() != null) {
            sb.append(", ").append(this.getAltitude());
        }
        if (this.getAccuracy() != null) {
            sb.append(", ~").append(this.getAccuracy());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        if (geoShape instanceof GeoPoint) {
            return this.equals(geoShape);
        }
        return geoShape.intersects(this);
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.latitude) ^ Double.doubleToLongBits(this.latitude) >>> 32);
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.longitude) ^ Double.doubleToLongBits(this.longitude) >>> 32);
        hash = 47 * hash + Double.hashCode(this.altitude);
        hash = 47 * hash + Double.hashCode(this.accuracy);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoPoint other = (GeoPoint)obj;
        double distanceBetween = GeoPoint.distanceBetween(this, other);
        if (Double.isNaN(distanceBetween)) {
            return false;
        }
        if (Math.abs(distanceBetween) > 0.001) {
            return false;
        }
        if (Math.abs(this.altitude - other.altitude) > 0.001) {
            return false;
        }
        return !(Math.abs(this.accuracy - other.accuracy) > 0.001);
    }

    public static double distanceBetween(GeoPoint geoPoint1, GeoPoint geoPoint2) {
        return geoPoint1.distanceFrom(geoPoint2);
    }

    public double distanceFrom(GeoPoint geoPoint) {
        return GeoUtils.distanceBetween(this.getLatitude(), this.getLongitude(), geoPoint.getLatitude(), geoPoint.getLongitude());
    }

    @Override
    public int compareTo(GeoPoint other) {
        int i = GeoPoint.compare(this.getLatitude(), other.getLatitude());
        if (i != 0) {
            return i;
        }
        i = GeoPoint.compare(this.getLongitude(), other.getLongitude());
        if (i != 0) {
            return i;
        }
        if (this.getAltitude() != null && other.getAltitude() != null) {
            return GeoPoint.compare(this.getAltitude(), other.getAltitude());
        }
        if (this.getAltitude() != null) {
            return 1;
        }
        if (other.getAltitude() != null) {
            return -1;
        }
        return 0;
    }

    private static int compare(double d1, double d2) {
        if (Math.abs(d1 - d2) < 1.0E-4) {
            return 0;
        }
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        return 0;
    }

    public static GeoPoint parse(String str) {
        String[] parts = str.split(",");
        if (parts.length < 2) {
            throw new GeInvalidShapeException("Too few parts to GeoPoint string. Expected at least 2 found " + parts.length + " for string: " + str);
        }
        if (parts.length >= 5) {
            throw new GeInvalidShapeException("Too many parts to GeoPoint string. Expected less than or equal to 4 found " + parts.length + " for string: " + str);
        }
        int part = 0;
        double latitude = GeoPoint.parsePart(parts[part++]);
        double longitude = GeoPoint.parsePart(parts[part++]);
        Double altitude = null;
        Double accuracy = null;
        while (part < parts.length) {
            String p = parts[part].trim();
            if (p.startsWith("~")) {
                if (accuracy != null) {
                    throw new GeInvalidShapeException("Cannot specify two accuracies (~) in GeoPoint string.");
                }
                accuracy = Double.parseDouble(p.substring(1));
            } else {
                if (altitude != null) {
                    throw new GeInvalidShapeException("Cannot specify two altitudes in GeoPoint string.");
                }
                altitude = Double.parseDouble(p);
            }
            ++part;
        }
        return new GeoPoint(latitude, longitude, altitude == null ? 0.0 : altitude, accuracy == null ? 0.0 : accuracy);
    }

    private static double parsePart(String part) {
        Matcher m = HOUR_MIN_SECOND_PATTERN.matcher(part);
        if (m.matches()) {
            String deg = m.group(2);
            double result = Double.parseDouble(deg);
            if (m.groupCount() >= 4) {
                String minutes = m.group(4);
                result += Double.parseDouble(minutes) / 60.0;
                if (m.groupCount() >= 6) {
                    String seconds = m.group(6);
                    result += Double.parseDouble(seconds) / 3600.0;
                }
            }
            if (m.group(1) != null && m.group(1).equals("-")) {
                result = -result;
            }
            return result;
        }
        return Double.parseDouble(part);
    }

    public boolean isSouthEastOf(GeoPoint pt) {
        return this.isSouthOf(pt) && this.isEastOf(pt);
    }

    private boolean isEastOf(GeoPoint pt) {
        return this.longitudinalDistanceTo(pt) > 0.0;
    }

    public boolean isSouthOf(GeoPoint pt) {
        return this.getLatitude() < pt.getLatitude();
    }

    public boolean isNorthWestOf(GeoPoint pt) {
        return this.isNorthOf(pt) && this.isWestOf(pt);
    }

    private boolean isWestOf(GeoPoint pt) {
        return this.longitudinalDistanceTo(pt) < 0.0;
    }

    public double longitudinalDistanceTo(GeoPoint pt) {
        double them;
        double result;
        double me = this.getLongitude();
        double d = result = Math.abs(me - (them = pt.getLongitude())) > 180.0 ? them - me : me - them;
        if (result > 180.0) {
            result -= 360.0;
        }
        if (result < -180.0) {
            result += 360.0;
        }
        return result;
    }

    public boolean isNorthOf(GeoPoint pt) {
        return this.getLatitude() > pt.getLatitude();
    }

    public static GeoPoint calculateCenter(List<GeoPoint> geoPoints) {
        Preconditions.checkNotNull(geoPoints, "geoPoints cannot be null");
        Preconditions.checkArgument(geoPoints.size() > 0, "must have at least 1 geoPoints");
        if (geoPoints.size() == 1) {
            return geoPoints.get(0);
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double totalAlt = 0.0;
        int altitudeCount = 0;
        for (GeoPoint geoPoint : geoPoints) {
            double latRad = Math.toRadians(geoPoint.getLatitude());
            double lonRad = Math.toRadians(geoPoint.getLongitude());
            x += Math.cos(latRad) * Math.cos(lonRad);
            y += Math.cos(latRad) * Math.sin(lonRad);
            z += Math.sin(latRad);
            if (geoPoint.getAltitude() == null) continue;
            totalAlt += geoPoint.getAltitude().doubleValue();
            ++altitudeCount;
        }
        return new GeoPoint(Math.toDegrees(Math.atan2(z /= (double)geoPoints.size(), Math.sqrt((x /= (double)geoPoints.size()) * x + (y /= (double)geoPoints.size()) * y))), Math.toDegrees(Math.atan2(y, x)), altitudeCount == geoPoints.size() ? Double.valueOf(totalAlt / (double)altitudeCount) : null);
    }
}

