/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.type;

import com.mware.ge.type.GeInvalidShapeException;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.type.GeoShape;
import com.mware.ge.type.GeoShapeBase;
import com.mware.ge.type.GeoUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class GeoPolygon
extends GeoShapeBase {
    private List<GeoPoint> outerBoundary = new ArrayList<GeoPoint>();
    private List<List<GeoPoint>> holeBoundaries = new ArrayList<List<GeoPoint>>();

    public GeoPolygon(List<GeoPoint> outerBoundary) {
        this.outerBoundary.addAll(outerBoundary);
        this.validate();
    }

    public GeoPolygon(List<GeoPoint> outerBoundary, List<List<GeoPoint>> holeBoundaries) {
        this.outerBoundary.addAll(outerBoundary);
        this.holeBoundaries.addAll(this.toArrayLists(holeBoundaries));
        this.validate();
    }

    @Override
    public void validate() {
        GeoUtils.toJtsPolygon(this.outerBoundary, this.holeBoundaries, false);
    }

    public static GeoShape createLenient(List<GeoPoint> outerBoundary) {
        return GeoPolygon.createLenient(outerBoundary, null);
    }

    public static GeoShape createLenient(List<GeoPoint> outerBoundary, List<List<GeoPoint>> holeBoundaries) {
        try {
            return new GeoPolygon(outerBoundary, holeBoundaries);
        }
        catch (GeInvalidShapeException ve) {
            return GeoUtils.toGeoShape(GeoUtils.toJtsPolygon(outerBoundary, holeBoundaries, true));
        }
    }

    public List<GeoPoint> getOuterBoundary() {
        return this.outerBoundary;
    }

    public GeoPolygon addHole(List<GeoPoint> geoPoints) {
        this.holeBoundaries.add(this.toArrayList(geoPoints));
        return this;
    }

    public List<List<GeoPoint>> getHoles() {
        return this.holeBoundaries;
    }

    public int hashCode() {
        int hash = 19;
        hash = 61 * hash + this.outerBoundary.hashCode();
        hash = 61 * hash + this.holeBoundaries.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoPolygon other = (GeoPolygon)obj;
        return this.outerBoundary.equals(other.outerBoundary) && this.holeBoundaries.equals(other.holeBoundaries);
    }

    public String toString() {
        return "GeoPolygon[outerBoundary: [" + this.outerBoundary.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]holes: [" + this.holeBoundaries.stream().map(hole -> "[" + hole.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]").collect(Collectors.joining(", ")) + "]]";
    }
}

