/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.type;

import com.mware.ge.GeException;
import com.mware.ge.type.GeInvalidShapeException;
import com.mware.ge.type.GeoCircle;
import com.mware.ge.type.GeoCollection;
import com.mware.ge.type.GeoHash;
import com.mware.ge.type.GeoLine;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.type.GeoPolygon;
import com.mware.ge.type.GeoRect;
import com.mware.ge.type.GeoShape;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.locationtech.jts.operation.valid.TopologyValidationError;

public class GeoUtils {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(GeoUtils.class);
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    public static double EARTH_RADIUS = 6371.0;
    public static double EARTH_CIRCUMFERENCE = Math.PI * 2 * EARTH_RADIUS;
    public static final double MIN_LAT = Math.toRadians(-90.0);
    public static final double MAX_LAT = Math.toRadians(90.0);
    public static final double MIN_LON = Math.toRadians(-180.0);
    public static final double MAX_LON = Math.toRadians(180.0);

    public static boolean intersects(GeoShape left, GeoShape right) {
        if (left instanceof GeoCircle) {
            GeoCircle geoCircle = (GeoCircle)left;
            if (right instanceof GeoPoint) {
                return GeoUtils.within(right, geoCircle);
            }
            if (right instanceof GeoCircle) {
                GeoCircle circle = (GeoCircle)right;
                double centerDistance = GeoUtils.distanceBetween(geoCircle.getLatitude(), geoCircle.getLongitude(), circle.getLatitude(), circle.getLongitude());
                return centerDistance < geoCircle.getRadius() + circle.getRadius();
            }
        } else if (right instanceof GeoCircle) {
            return GeoUtils.intersects(right, left);
        }
        return GeoUtils.toJtsGeometry(left, false).intersects(GeoUtils.toJtsGeometry(right, false));
    }

    public static boolean within(GeoShape left, GeoShape right) {
        if (right instanceof GeoCircle) {
            GeoCircle geoCircle = (GeoCircle)right;
            if (left instanceof GeoPoint) {
                GeoPoint pt = (GeoPoint)left;
                return GeoUtils.distanceBetween(geoCircle.getLatitude(), geoCircle.getLongitude(), pt.getLatitude(), pt.getLongitude()) <= geoCircle.getRadius();
            }
            if (left instanceof GeoCircle) {
                GeoCircle circle = (GeoCircle)left;
                double distance = GeoUtils.distanceBetween(geoCircle.getLatitude(), geoCircle.getLongitude(), circle.getLatitude(), circle.getLongitude());
                return distance + circle.getRadius() <= geoCircle.getRadius();
            }
            if (left instanceof GeoRect) {
                GeoRect rect = (GeoRect)left;
                return GeoUtils.within(rect.getNorthWest(), geoCircle) && GeoUtils.within(rect.getSouthEast(), geoCircle);
            }
            if (left instanceof GeoHash) {
                return GeoUtils.within(((GeoHash)left).toGeoRect(), geoCircle);
            }
            if (left instanceof GeoLine) {
                return ((GeoLine)left).getGeoPoints().stream().allMatch(linePoint -> GeoUtils.within(linePoint, geoCircle));
            }
            throw new GeException("Not implemented for argument type " + left.getClass().getName());
        }
        if (left instanceof GeoCircle) {
            throw new GeException("Not implemented for argument type " + left.getClass().getName());
        }
        return GeoUtils.toJtsGeometry(left, false).within(GeoUtils.toJtsGeometry(right, false));
    }

    public static GeoShape getEnvelope(GeoShape geoShape) {
        if (geoShape instanceof GeoCircle) {
            double maxLon;
            double minLon;
            GeoCircle geoCircle = (GeoCircle)geoShape;
            double radDist = geoCircle.getRadius() / EARTH_RADIUS;
            double radLat = Math.toRadians(geoCircle.getLatitude());
            double radLon = Math.toRadians(geoCircle.getLongitude());
            double minLat = radLat - radDist;
            double maxLat = radLat + radDist;
            if (minLat > MIN_LAT && maxLat < MAX_LAT) {
                double deltaLon = Math.asin(Math.sin(radDist) / Math.cos(radLat));
                minLon = radLon - deltaLon;
                if (minLon < MIN_LON) {
                    minLon += Math.PI * 2;
                }
                if ((maxLon = radLon + deltaLon) > MAX_LON) {
                    maxLon -= Math.PI * 2;
                }
            } else {
                minLat = Math.max(minLat, MIN_LAT);
                maxLat = Math.min(maxLat, MAX_LAT);
                minLon = MIN_LON;
                maxLon = MAX_LON;
            }
            return new GeoRect(new GeoPoint(Math.toDegrees(maxLat), Math.toDegrees(minLon)), new GeoPoint(Math.toDegrees(minLat), Math.toDegrees(maxLon)));
        }
        return GeoUtils.toGeoShape(GeoUtils.toJtsGeometry(geoShape, false).getEnvelope());
    }

    public static GeoShape repair(GeoShape geoShape) {
        return GeoUtils.toGeoShape(GeoUtils.toJtsGeometry(geoShape, true));
    }

    public static GeoShape toGeoShape(Geometry geometry) {
        if (geometry instanceof GeometryCollection) {
            GeoCollection geoCollection = new GeoCollection();
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                geoCollection.addShape(GeoUtils.toGeoShape(geometryCollection.getGeometryN(i)));
            }
            return geoCollection;
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            List<GeoPoint> outerRing = GeoUtils.toGeoPoints(polygon.getExteriorRing().getCoordinates());
            ArrayList<List<GeoPoint>> holes = new ArrayList<List<GeoPoint>>();
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                holes.add(GeoUtils.toGeoPoints(polygon.getInteriorRingN(i).getCoordinates()));
            }
            return new GeoPolygon(outerRing, holes);
        }
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            return new GeoPoint(point.getY(), point.getX());
        }
        if (geometry instanceof LineString) {
            LineString lineString = (LineString)geometry;
            return new GeoLine(GeoUtils.toGeoPoints(lineString.getCoordinates()));
        }
        throw new GeInvalidShapeException("Unknown geometry type: " + geometry.toString());
    }

    public static double distanceBetween(double latitude1, double longitude1, double latitude2, double longitude2) {
        latitude1 = Math.toRadians(latitude1);
        longitude1 = Math.toRadians(longitude1);
        latitude2 = Math.toRadians(latitude2);
        longitude2 = Math.toRadians(longitude2);
        double cosLat1 = Math.cos(latitude1);
        double cosLat2 = Math.cos(latitude2);
        double sinLat1 = Math.sin(latitude1);
        double sinLat2 = Math.sin(latitude2);
        double deltaLon = longitude2 - longitude1;
        double cosDeltaLon = Math.cos(deltaLon);
        double sinDeltaLon = Math.sin(deltaLon);
        double a = cosLat2 * sinDeltaLon;
        double b = cosLat1 * sinLat2 - sinLat1 * cosLat2 * cosDeltaLon;
        double c = sinLat1 * sinLat2 + cosLat1 * cosLat2 * cosDeltaLon;
        double rads = Math.atan2(Math.sqrt(a * a + b * b), c);
        double percent = rads / (Math.PI * 2);
        return percent * EARTH_CIRCUMFERENCE;
    }

    private static Geometry toJtsGeometry(GeoShape geoShape, boolean lenient) {
        if (geoShape instanceof GeoCollection) {
            GeoCollection geoCollection = (GeoCollection)geoShape;
            Geometry[] geometries = (Geometry[])geoCollection.getGeoShapes().stream().map(shape -> GeoUtils.toJtsGeometry(shape, lenient)).toArray(Geometry[]::new);
            return GEOMETRY_FACTORY.createGeometryCollection(geometries);
        }
        if (geoShape instanceof GeoPolygon) {
            GeoPolygon geoPolygon = (GeoPolygon)geoShape;
            return GeoUtils.toJtsPolygon(geoPolygon.getOuterBoundary(), geoPolygon.getHoles(), lenient);
        }
        if (geoShape instanceof GeoRect) {
            GeoRect geoRect = (GeoRect)geoShape;
            Coordinate[] coordinates = new Coordinate[]{new Coordinate(geoRect.getNorthWest().getLongitude(), geoRect.getNorthWest().getLatitude()), new Coordinate(geoRect.getNorthWest().getLongitude(), geoRect.getSouthEast().getLatitude()), new Coordinate(geoRect.getSouthEast().getLongitude(), geoRect.getSouthEast().getLatitude()), new Coordinate(geoRect.getSouthEast().getLongitude(), geoRect.getNorthWest().getLatitude()), new Coordinate(geoRect.getNorthWest().getLongitude(), geoRect.getNorthWest().getLatitude())};
            return GEOMETRY_FACTORY.createPolygon(coordinates);
        }
        if (geoShape instanceof GeoPoint) {
            GeoPoint geoPoint = (GeoPoint)geoShape;
            return GEOMETRY_FACTORY.createPoint(new Coordinate(geoPoint.getLongitude(), geoPoint.getLatitude()));
        }
        if (geoShape instanceof GeoLine) {
            GeoLine geoLine = (GeoLine)geoShape;
            Coordinate[] coordinates = (Coordinate[])geoLine.getGeoPoints().stream().map(point -> new Coordinate(point.getLongitude(), point.getLatitude())).toArray(Coordinate[]::new);
            return GEOMETRY_FACTORY.createLineString(coordinates);
        }
        if (geoShape instanceof GeoHash) {
            return GeoUtils.toJtsGeometry(((GeoHash)geoShape).toGeoRect(), lenient);
        }
        throw new GeInvalidShapeException("Unsupported shape type: " + geoShape.getClass());
    }

    private static List<GeoPoint> toGeoPoints(Coordinate[] coordinates) {
        ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>(coordinates.length);
        for (Coordinate coordinate : coordinates) {
            geoPoints.add(new GeoPoint(coordinate.y, coordinate.x));
        }
        return geoPoints;
    }

    public static Geometry toJtsPolygon(List<GeoPoint> outerBoundary, List<List<GeoPoint>> holeBoundaries, boolean lenient) {
        LinearRing[] holes;
        LinearRing shell = GeoUtils.toJtsLinearRing(outerBoundary, true, lenient);
        Polygon polygon = GEOMETRY_FACTORY.createPolygon(shell, holes = holeBoundaries == null ? new LinearRing[]{} : (LinearRing[])holeBoundaries.stream().map(holeBoundary -> GeoUtils.toJtsLinearRing(holeBoundary, false, lenient)).toArray(LinearRing[]::new));
        TopologyValidationError validationError = new IsValidOp((Geometry)polygon).getValidationError();
        if (validationError != null) {
            if (lenient) {
                LOGGER.info("Attempting to repair and normalize an invalid polygon.", new Object[0]);
                polygon = polygon.buffer(0.0).norm().reverse();
            } else {
                throw new GeInvalidShapeException(validationError.toString());
            }
        }
        return polygon;
    }

    private static LinearRing toJtsLinearRing(List<GeoPoint> geoPoints, boolean counterClockwise, boolean lenient) {
        if (geoPoints.size() < 4) {
            throw new GeInvalidShapeException("A polygon must specify at least 4 points for each boundary and hole.");
        }
        Object[] shellCoordinates = (Coordinate[])geoPoints.stream().map(geoPoint -> new Coordinate(geoPoint.getLongitude(), geoPoint.getLatitude())).toArray(Coordinate[]::new);
        if (!shellCoordinates[0].equals((Object)shellCoordinates[shellCoordinates.length - 1])) {
            if (lenient) {
                LOGGER.info("Closing an unclosed GeoShape by appending the beginning coordinate", new Object[0]);
                shellCoordinates = (Coordinate[])ArrayUtils.add((Object[])shellCoordinates, (Object)shellCoordinates[0].copy());
            } else {
                throw new GeInvalidShapeException("All polygon boundaries and holes must begin and end at the same point.");
            }
        }
        if (Orientation.isCCW((Coordinate[])shellCoordinates) != counterClockwise) {
            if (lenient) {
                LOGGER.info("Reversing the coordinates of a ring that has a backwards orientation", new Object[0]);
                ArrayUtils.reverse((Object[])shellCoordinates);
            } else {
                throw new GeInvalidShapeException("The outer shell of a polygon must be specified in counter-clockwise orientation and all holes must be specified in the clockwise direction.");
            }
        }
        return GEOMETRY_FACTORY.createLinearRing((Coordinate[])shellCoordinates);
    }
}

