/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class AutoDeleteFileInputStream
extends FileInputStream {
    private final File file;

    public AutoDeleteFileInputStream(File file) throws FileNotFoundException {
        super(file);
        this.file = file;
    }

    public AutoDeleteFileInputStream(InputStream copyFromStream) throws IOException {
        this(AutoDeleteFileInputStream.copyToTempFile(copyFromStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File copyToTempFile(InputStream inputStream) throws IOException {
        try {
            Path tempPath = Files.createTempFile(AutoDeleteFileInputStream.class.getSimpleName(), null, new FileAttribute[0]);
            Files.copy(inputStream, tempPath, StandardCopyOption.REPLACE_EXISTING);
            File tempFile = tempPath.toFile();
            tempFile.deleteOnExit();
            File file = tempFile;
            return file;
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.file.exists()) {
                this.file.delete();
            }
        }
    }

    public long getFileLength() {
        return this.file.length();
    }

    @VisibleForTesting
    File getFile() {
        return this.file;
    }
}

