/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.mware.ge.util.Preconditions;

public class ByteRingBuffer {
    private byte[] buffer;
    private int position;
    private int used;

    public ByteRingBuffer(int size) {
        Preconditions.checkArgument(size > 0, "size must be greater than 0");
        this.buffer = new byte[size];
    }

    public void resize(int newSize) {
        Preconditions.checkArgument(newSize >= this.getUsed(), "cannot resize smaller than data used");
        byte[] newBuffer = new byte[newSize];
        int newUsed = this.read(newBuffer, 0, newSize);
        this.buffer = newBuffer;
        this.position = 0;
        this.used = newUsed;
    }

    public int getSize() {
        return this.buffer.length;
    }

    public int getFree() {
        return this.getSize() - this.getUsed();
    }

    public int getUsed() {
        return this.used;
    }

    public void clear() {
        this.position = 0;
        this.used = 0;
    }

    public int write(byte[] buf, int pos, int len) {
        int p1;
        Preconditions.checkArgument(len >= 0, "len must be >= 0");
        Preconditions.checkArgument(len <= this.getFree(), "out of free space");
        if (this.used == 0) {
            this.position = 0;
        }
        if ((p1 = this.position + this.used) < this.buffer.length) {
            int part1Len = Math.min(len, this.buffer.length - p1);
            this.append(buf, pos, part1Len);
            int part2Len = Math.min(len - part1Len, this.position);
            this.append(buf, pos + part1Len, part2Len);
            return part1Len + part2Len;
        }
        this.append(buf, pos, len);
        return len;
    }

    public int write(byte[] buf) {
        return this.write(buf, 0, buf.length);
    }

    private void append(byte[] buf, int pos, int len) {
        Preconditions.checkArgument(len >= 0, "len must be >= 0");
        if (len == 0) {
            return;
        }
        int p = this.clip(this.position + this.used);
        System.arraycopy(buf, pos, this.buffer, p, len);
        this.used += len;
    }

    public int read(byte[] buf, int pos, int len) {
        Preconditions.checkArgument(len >= 0, "len must be >=0");
        if (this.getUsed() == 0) {
            return -1;
        }
        int part1Length = Math.min(len, Math.min(this.used, this.buffer.length - this.position));
        this.remove(buf, pos, part1Length);
        int part2Length = Math.min(len - part1Length, this.used);
        this.remove(buf, pos + part1Length, part2Length);
        return part1Length + part2Length;
    }

    public int read(byte[] buf) {
        return this.read(buf, 0, buf.length);
    }

    public int read() {
        if (this.getUsed() < 1) {
            return -1;
        }
        byte[] buffer = new byte[1];
        this.read(buffer);
        return buffer[0];
    }

    private void remove(byte[] buf, int pos, int len) {
        Preconditions.checkArgument(len >= 0, "len must be >= 0");
        if (len == 0) {
            return;
        }
        System.arraycopy(this.buffer, this.position, buf, pos, len);
        this.position = this.clip(this.position + len);
        this.used -= len;
    }

    private int clip(int p) {
        return p < this.buffer.length ? p : p - this.buffer.length;
    }
}

