/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import java.io.Closeable;
import java.io.IOException;

public class CloseableUtils {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(CloseableUtils.class);

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to close", ex);
        }
    }

    public static void closeQuietly(Object ... objects) {
        for (Object object : objects) {
            if (!(object instanceof Closeable)) continue;
            CloseableUtils.closeQuietly((Closeable)object);
        }
    }
}

