/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.GraphConfiguration;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.util.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;

public class ConfigurationUtils {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(ConfigurationUtils.class);

    public static <T> T createProvider(Graph graph, GraphConfiguration config, String propPrefix, String defaultProvider) throws GeException {
        String implClass = config.getString(propPrefix, defaultProvider);
        Preconditions.checkNotNull(implClass, "createProvider could not find " + propPrefix + " configuration item");
        return ConfigurationUtils.createProvider(implClass, graph, config);
    }

    public static <T> T createProvider(String className, Graph graph, GraphConfiguration config) throws GeException {
        Preconditions.checkNotNull(className, "className is required");
        className = className.trim();
        LOGGER.debug("creating provider '%s'", className);
        Class<Graph> graphClass = Graph.class;
        Class<GraphConfiguration> graphConfigurationClass = GraphConfiguration.class;
        try {
            Class<?> clazz = Class.forName(className);
            try {
                try {
                    Constructor<?> constructor = clazz.getConstructor(graphClass);
                    return (T)constructor.newInstance(graph);
                }
                catch (NoSuchMethodException ignore1) {
                    try {
                        Constructor<?> constructor = clazz.getConstructor(graphClass, graphConfigurationClass);
                        return (T)constructor.newInstance(graph, config);
                    }
                    catch (NoSuchMethodException ignore2) {
                        try {
                            Constructor<?> constructor = clazz.getConstructor(graphConfigurationClass);
                            return (T)constructor.newInstance(config);
                        }
                        catch (NoSuchMethodException ignore3) {
                            try {
                                Constructor<?> constructor = clazz.getConstructor(Map.class);
                                return (T)constructor.newInstance(config.getConfig());
                            }
                            catch (NoSuchMethodException ignoreInner) {
                                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                                return (T)constructor.newInstance(new Object[0]);
                            }
                        }
                    }
                }
            }
            catch (IllegalArgumentException e) {
                StringBuilder possibleMatches = new StringBuilder();
                for (Constructor<?> s : clazz.getConstructors()) {
                    possibleMatches.append(s.toGenericString());
                    possibleMatches.append(", ");
                }
                throw new GeException("Invalid constructor for " + className + ". Expected <init>(" + graphConfigurationClass.getName() + "). Found: " + possibleMatches, e);
            }
        }
        catch (NoSuchMethodException e) {
            throw new GeException("Provider must have a single argument constructor taking a " + graphConfigurationClass.getName(), e);
        }
        catch (ClassNotFoundException e) {
            throw new GeException("No provider found with class name " + className, e);
        }
        catch (Exception e) {
            throw new GeException(e);
        }
    }

    public static Map<String, String> loadConfig(List<String> configFileNames, String configPropertyPrefix) throws IOException {
        Map<String, String> props = ConfigurationUtils.loadFiles(configFileNames);
        props.putAll(System.getenv());
        ConfigurationUtils.resolvePropertyReferences(props);
        return ConfigurationUtils.stripPrefix(props, configPropertyPrefix);
    }

    private static Map<String, String> loadFiles(List<String> configFileNames) throws IOException {
        Properties props = new Properties();
        for (String configFileName : configFileNames) {
            File configFile = new File(configFileName);
            if (!configFile.exists()) {
                throw new RuntimeException("Could not load config file: " + configFile.getAbsolutePath());
            }
            FileInputStream in = new FileInputStream(configFile);
            Throwable throwable = null;
            try {
                props.load(in);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)in).close();
            }
        }
        return ConfigurationUtils.propertiesToMap(props);
    }

    public static Map<String, String> stripPrefix(Map<String, String> propsMap, String configPropertyPrefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (configPropertyPrefix == null) {
            result.putAll(propsMap);
        } else {
            for (Map.Entry<String, String> p : propsMap.entrySet()) {
                if (p.getKey().startsWith(configPropertyPrefix + ".")) {
                    result.put(p.getKey().substring((configPropertyPrefix + ".").length()), p.getValue());
                    continue;
                }
                if (!p.getKey().startsWith(configPropertyPrefix)) continue;
                result.put(p.getKey().substring(configPropertyPrefix.length()), p.getValue());
            }
        }
        return result;
    }

    private static Map<String, String> propertiesToMap(Properties props) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            results.put("" + entry.getKey(), "" + entry.getValue());
        }
        return results;
    }

    private static void resolvePropertyReferences(Map<String, String> config) {
        for (Map.Entry<String, String> entry : config.entrySet()) {
            String entryValue = entry.getValue();
            if (StringUtils.isBlank((CharSequence)entryValue)) continue;
            entry.setValue(StrSubstitutor.replace((Object)entryValue, config));
        }
    }

    public static String getString(Map<String, Object> config, String configKey, String defaultValue) {
        Object str = config.get(configKey);
        if (str == null) {
            return defaultValue;
        }
        if (str instanceof String) {
            return ((String)str).trim();
        }
        return str.toString().trim();
    }

    public static long getConfigLong(Map<String, Object> config, String key, long defaultValue) {
        Object obj = config.get(key);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return Long.parseLong(obj.toString());
    }

    public static Duration getDuration(Map<String, Object> config, String key, Duration defaultValue) {
        return ConfigurationUtils.getDuration(config, key, defaultValue.toMillis() + "ms");
    }

    public static Duration getDuration(Map<String, Object> config, String key, String defaultValue) {
        String value = ConfigurationUtils.getString(config, key, defaultValue);
        try {
            return Duration.parse(value);
        }
        catch (DateTimeParseException ex) {
            String units;
            Matcher m = Pattern.compile("(\\d+)(\\D+)").matcher(value);
            if (!m.matches()) {
                throw ex;
            }
            long digits = Long.parseLong(m.group(1));
            switch (units = m.group(2)) {
                case "ms": {
                    return Duration.ofMillis(digits);
                }
                case "s": {
                    return Duration.ofSeconds(digits);
                }
                case "m": {
                    return Duration.ofMinutes(digits);
                }
                case "h": {
                    return Duration.ofHours(digits);
                }
            }
            throw new GeException("unhandled duration units: " + value);
        }
    }

    public static Integer getInteger(Map<String, Object> config, String configKey, Integer defaultValue) {
        Object obj = config.get(configKey);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        if (obj instanceof Integer) {
            return (int)((Integer)obj);
        }
        return Integer.valueOf(obj.toString());
    }

    public static int getInt(Map<String, Object> config, String configKey, int defaultValue) {
        Object obj = config.get(configKey);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return Integer.parseInt(obj.toString());
    }

    public static double getDouble(Map<String, Object> config, String configKey, double defaultValue) {
        Object obj = config.get(configKey);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof String) {
            return Double.parseDouble((String)obj);
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        return Double.parseDouble(obj.toString());
    }

    public static boolean getBoolean(Map<String, Object> config, String configKey, boolean defaultValue) {
        Object obj = config.get(configKey);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof String) {
            return Boolean.parseBoolean((String)obj);
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return Boolean.parseBoolean(obj.toString());
    }
}

