/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.mware.ge.util.CloseableIterator;
import com.mware.ge.util.CloseableUtils;
import java.util.Iterator;

public abstract class ConvertingIterable<TSource, TDest>
implements Iterable<TDest> {
    private Iterable<? extends TSource> iterable;
    private Iterator<? extends TSource> iterator;

    public ConvertingIterable(Iterable<? extends TSource> iterable) {
        this.iterable = iterable;
    }

    public ConvertingIterable(Iterator<? extends TSource> iterator) {
        this.iterator = iterator;
    }

    @Override
    public Iterator<TDest> iterator() {
        final Iterator<? extends TSource> it = this.iterator == null ? this.iterable.iterator() : this.iterator;
        return new CloseableIterator<TDest>(){

            @Override
            public boolean hasNext() {
                boolean hasNext = it.hasNext();
                if (!hasNext) {
                    this.close();
                }
                return hasNext;
            }

            @Override
            public TDest next() {
                return ConvertingIterable.this.convert(it.next());
            }

            @Override
            public void remove() {
                it.remove();
            }

            @Override
            public void close() {
                CloseableUtils.closeQuietly(it);
            }
        };
    }

    protected abstract TDest convert(TSource var1);
}

