/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.mware.ge.util.Preconditions;
import com.mware.ge.util.WrappedIterator;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;

public class ExtendableIterator<T>
extends WrappedIterator<T> {
    private final Deque<Iterator<T>> itors = new ConcurrentLinkedDeque<Iterator<T>>();
    private final List<Iterator<T>> removedItors = new ArrayList<Iterator<T>>();
    private Iterator<T> currentIterator = null;

    public ExtendableIterator() {
    }

    public ExtendableIterator(Iterator<T> itor) {
        this();
        this.extend(itor);
    }

    public ExtendableIterator(Iterator<T> itor1, Iterator<T> itor2) {
        this();
        this.extend(itor1);
        this.extend(itor2);
    }

    public ExtendableIterator<T> extend(Iterator<T> itor) {
        Preconditions.checkState(this.currentIterator == null, "Can't extend iterator after iterating");
        if (itor != null) {
            this.itors.addLast(itor);
        }
        return this;
    }

    @Override
    public void close() throws Exception {
        for (Iterator<T> itor : this.removedItors) {
            if (!(itor instanceof AutoCloseable)) continue;
            ((AutoCloseable)((Object)itor)).close();
        }
        for (Iterator<T> itor : this.itors) {
            if (!(itor instanceof AutoCloseable)) continue;
            ((AutoCloseable)((Object)itor)).close();
        }
    }

    @Override
    protected Iterator<?> originIterator() {
        return this.currentIterator;
    }

    @Override
    protected boolean fetch() {
        assert (this.current == ExtendableIterator.none());
        if (this.itors.isEmpty()) {
            return false;
        }
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            this.current = this.currentIterator.next();
            return true;
        }
        Iterator<T> first = null;
        while ((first = this.itors.peekFirst()) != null && !first.hasNext()) {
            if (first == this.itors.peekLast() && this.itors.size() == 1) {
                return false;
            }
            this.removedItors.add(this.itors.removeFirst());
        }
        assert (first != null && first.hasNext());
        this.currentIterator = first;
        this.current = this.currentIterator.next();
        return true;
    }
}

