/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.ElementId;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.GeException;
import com.mware.ge.GeObject;
import com.mware.ge.Vertex;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.metric.StackTraceTracker;
import com.mware.ge.query.IterableWithTotalHits;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.util.GraphTestContext;
import com.mware.ge.util.StreamUtils;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import junit.framework.AssertionFailedError;
import org.junit.Assert;

public class GeAssert {
    protected static final List<GraphEvent> graphEvents = new ArrayList<GraphEvent>();

    public static void assertEquals(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            Assert.assertEquals((Object)o1, (Object)o2);
            return;
        }
        if (GraphTestContext.proxiesEnabled() && Proxy.isProxyClass(o1.getClass()) && Proxy.isProxyClass(o2.getClass())) {
            if (o1 instanceof Element && o2 instanceof Element) {
                Assert.assertEquals((Object)((Element)o1).getId(), (Object)((Element)o2).getId());
                return;
            }
            throw new UnsupportedOperationException("The provided proxy is unrecognized.");
        }
        Assert.assertEquals((Object)o1, (Object)o2);
    }

    public static void assertNotEquals(Object o1, Object o2) {
        if (GraphTestContext.proxiesEnabled() && Proxy.isProxyClass(o1.getClass()) && Proxy.isProxyClass(o2.getClass())) {
            if (o1 instanceof Element && o2 instanceof Element) {
                Assert.assertNotEquals((Object)((Element)o1).getId(), (Object)((Element)o2).getId());
                return;
            }
            throw new UnsupportedOperationException("The provided proxy is unrecognized.");
        }
        Assert.assertNotEquals((Object)o1, (Object)o2);
    }

    public static void assertEquals(double d1, double d2, double d3) {
        Assert.assertEquals((double)d1, (double)d2, (double)d3);
    }

    public static void assertEquals(long l1, long l2) {
        Assert.assertEquals((long)l1, (long)l2);
    }

    public static void assertEquals(String msg, Object o1, Object o2) {
        Assert.assertEquals((String)msg, (Object)o1, (Object)o2);
    }

    public static void assertEquals(String msg, long o1, long o2) {
        Assert.assertEquals((String)msg, (long)o1, (long)o2);
    }

    public static void assertNotNull(Object o) {
        Assert.assertNotNull((Object)o);
    }

    public static void assertNotNull(String msg, Object o) {
        Assert.assertNotNull((String)msg, (Object)o);
    }

    public static void assertNull(Object o) {
        Assert.assertNull((Object)o);
    }

    public static void assertNull(String msg, Object o) {
        Assert.assertNull((String)msg, (Object)o);
    }

    public static void assertTrue(boolean o) {
        Assert.assertTrue((boolean)o);
    }

    public static void assertFalse(boolean o) {
        Assert.assertFalse((boolean)o);
    }

    public static void assertTrue(String msg, boolean o) {
        Assert.assertTrue((String)msg, (boolean)o);
    }

    public static void assertFalse(String msg, boolean o) {
        Assert.assertFalse((String)msg, (boolean)o);
    }

    public static void fail(String msg) {
        Assert.fail((String)msg);
    }

    public static void assertArrayEquals(String msg, Object[] expecteds, Object[] actuals) {
        Assert.assertArrayEquals((String)msg, (Object[])expecteds, (Object[])actuals);
    }

    public static void assertArrayEquals(Object[] expecteds, Object[] actuals) {
        Assert.assertArrayEquals((Object[])expecteds, (Object[])actuals);
    }

    public static void assertIdsAnyOrder(Iterable<String> ids, String ... expectedIds) {
        List<String> sortedIds = StreamUtils.stream(ids).sorted().collect(Collectors.toList());
        Arrays.sort(expectedIds);
        String idsString = GeAssert.idsToString(sortedIds.toArray(new String[sortedIds.size()]));
        String expectedIdsString = GeAssert.idsToString(expectedIds);
        GeAssert.assertEquals("ids length mismatch found:[" + idsString + "] expected:[" + expectedIdsString + "]", expectedIds.length, sortedIds.size());
        for (int i = 0; i < expectedIds.length; ++i) {
            GeAssert.assertEquals("at offset: " + i + " found:[" + idsString + "] expected:[" + expectedIdsString + "]", expectedIds[i], sortedIds.get(i));
        }
    }

    public static void assertVertexIdsAnyOrder(Iterable<Vertex> vertices, String ... expectedIds) {
        if (vertices instanceof QueryResultsIterable) {
            GeAssert.assertEquals(expectedIds.length, ((QueryResultsIterable)vertices).getTotalHits());
        }
        GeAssert.assertElementIdsAnyOrder(vertices, expectedIds);
    }

    public static void assertVertexIds(Iterable<Vertex> vertices, String ... expectedIds) {
        GeAssert.assertElementIds(vertices, expectedIds);
    }

    public static String idsToString(String[] ids) {
        return Joiner.on((String)", ").join((Object[])ids);
    }

    public static String idsToStringSorted(Iterable<String> ids) {
        ArrayList idsList = Lists.newArrayList(ids);
        Collections.sort(idsList);
        return Joiner.on((String)", ").join((Iterable)idsList);
    }

    public static void assertEvents(GraphEvent ... expectedEvents) {
        if (GraphTestContext.eventsEnabled()) {
            Assert.assertEquals((String)"Different number of events occurred than were asserted", (long)expectedEvents.length, (long)graphEvents.size());
            for (int i = 0; i < expectedEvents.length; ++i) {
                Assert.assertEquals((Object)expectedEvents[i], (Object)graphEvents.get(i));
            }
        }
    }

    public static void assertEdgeIdsAnyOrder(Iterable<Edge> edges, String ... expectedIds) {
        GeAssert.assertElementIdsAnyOrder(edges, expectedIds);
    }

    public static void assertEdgeIds(Iterable<Edge> edges, String ... ids) {
        GeAssert.assertElementIds(edges, ids);
    }

    public static void assertElementIdsAnyOrder(Iterable<? extends Element> elements, String ... expectedIds) {
        List sortedElements = StreamUtils.stream(elements).sorted(Comparator.comparing(ElementId::getId)).collect(Collectors.toList());
        Arrays.sort(expectedIds);
        GeAssert.assertElementIds(sortedElements, expectedIds);
    }

    public static void assertElementIds(Iterable<? extends Element> elements, String ... ids) {
        String found = StreamUtils.stream(elements).map(ElementId::getId).collect(Collectors.joining(", "));
        String expected = Joiner.on((String)", ").join((Object[])ids);
        GeAssert.assertEquals(expected, found);
    }

    public static void assertResultsCount(int expectedCountAndTotalHits, QueryResultsIterable<? extends Element> results) {
        Assert.assertEquals((long)expectedCountAndTotalHits, (long)results.getTotalHits());
        GeAssert.assertCount(expectedCountAndTotalHits, results);
    }

    public static void assertResultsCount(int expectedCount, int expectedTotalHits, IterableWithTotalHits<?> results) {
        Assert.assertEquals((long)expectedTotalHits, (long)results.getTotalHits());
        GeAssert.assertCount(expectedCount, results);
    }

    private static void assertCount(int expectedCount, Iterable<?> results) {
        int count = 0;
        Iterator<?> it = results.iterator();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        Assert.assertEquals((long)expectedCount, (long)count);
        Assert.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            throw new GeException("Should throw NoSuchElementException: " + it.getClass().getName());
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public static void addGraphEvent(GraphEvent graphEvent) {
        graphEvents.add(graphEvent);
    }

    public static void clearGraphEvents() {
        graphEvents.clear();
    }

    public static void assertRowIdsAnyOrder(Iterable<ExtendedDataRow> rows, String ... expectedRowIds) {
        List<String> foundRowIds = GeAssert.getRowIds(rows);
        GeAssert.assertEquals(GeAssert.idsToStringSorted(Lists.newArrayList((Object[])expectedRowIds)), GeAssert.idsToStringSorted(foundRowIds));
        if (rows instanceof QueryResultsIterable) {
            GeAssert.assertEquals("search index total hits mismatch", expectedRowIds.length, ((QueryResultsIterable)rows).getTotalHits());
        }
    }

    public static void assertRowIdsAnyOrder(Iterable<String> expectedRowIds, Iterable<? extends GeObject> searchResults) {
        List<String> foundRowIds = GeAssert.getRowIds(searchResults);
        Assert.assertEquals((Object)GeAssert.idsToStringSorted(expectedRowIds), (Object)GeAssert.idsToStringSorted(foundRowIds));
    }

    public static void assertRowIds(Iterable<String> expectedRowIds, Iterable<? extends GeObject> searchResults) {
        List<String> foundRowIds = GeAssert.getRowIds(searchResults);
        Assert.assertEquals(expectedRowIds, foundRowIds);
    }

    private static List<String> getRowIds(Iterable<? extends GeObject> searchResults) {
        return StreamUtils.stream(searchResults).filter(sr -> sr instanceof ExtendedDataRow).map(sr -> ((ExtendedDataRow)sr).getId().getRowId()).collect(Collectors.toList());
    }

    public static void assertThrowsException(Runnable fn) {
        try {
            fn.run();
        }
        catch (Throwable ex) {
            return;
        }
        GeAssert.fail("Should have thrown an exception");
    }

    public static <T extends Throwable> T assertThrowsException(Class expectedType, Executable fn) {
        try {
            fn.execute();
        }
        catch (Throwable ex) {
            if (expectedType.isInstance(ex)) {
                return (T)ex;
            }
            GeAssert.fail("Unexpected exception type thrown");
        }
        GeAssert.fail(String.format("Expected %s to be thrown, but nothing was thrown.", expectedType.getName()));
        throw new AssertionFailedError();
    }

    public static void assertStackTraceTrackerCount(StackTraceTracker tracker, Consumer<List<StackTraceTracker.StackTraceItem>> validate) {
        GeAssert.assertStackTraceTrackerCount(tracker.getRoots(), new ArrayList<StackTraceTracker.StackTraceItem>(), validate);
    }

    public static void assertStackTraceTrackerCount(Set<StackTraceTracker.StackTraceItem> roots, List<StackTraceTracker.StackTraceItem> path, Consumer<List<StackTraceTracker.StackTraceItem>> validate) {
        for (StackTraceTracker.StackTraceItem item : roots) {
            ArrayList<StackTraceTracker.StackTraceItem> newPath = new ArrayList<StackTraceTracker.StackTraceItem>(path);
            newPath.add(item);
            validate.accept(newPath);
            GeAssert.assertStackTraceTrackerCount(item.getChildren(), newPath, validate);
        }
    }

    public static interface Executable {
        public void execute() throws Throwable;
    }
}

