/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.mware.ge.util.GeReadWriteLock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public class GeReentrantReadWriteLock
implements GeReadWriteLock {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public ReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public <T> T executeInReadLock(Supplier<T> fn) {
        this.lock.readLock().lock();
        try {
            T t = fn.get();
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void executeInReadLock(Runnable fn) {
        this.lock.readLock().lock();
        try {
            fn.run();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <T> T executeInWriteLock(Supplier<T> fn) {
        this.lock.writeLock().lock();
        try {
            T t = fn.get();
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void executeInWriteLock(Runnable fn) {
        this.lock.writeLock().lock();
        try {
            fn.run();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

