/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.mware.ge.util.CloseableIterable;
import com.mware.ge.util.CloseableIterator;
import com.mware.ge.util.CloseableUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class GroupingIterable<TSource, TGroup>
implements CloseableIterable<TGroup> {
    private boolean doneCalled;
    private final Iterable<TSource> source;

    public GroupingIterable(Iterable<TSource> source) {
        this.source = source;
    }

    @Override
    public Iterator<TGroup> iterator() {
        final Iterator<TSource> it = this.source.iterator();
        return new CloseableIterator<TGroup>(){
            private TGroup next;
            private TGroup current;
            private TSource lastItem;

            @Override
            public boolean hasNext() {
                this.loadNext();
                if (this.next == null) {
                    this.close();
                }
                return this.next != null;
            }

            @Override
            public TGroup next() {
                this.loadNext();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.current = this.next;
                this.next = null;
                return this.current;
            }

            @Override
            public void close() {
                CloseableUtils.closeQuietly(it);
                GroupingIterable.this.callClose();
            }

            private void loadNext() {
                if (this.next != null) {
                    return;
                }
                if (this.lastItem != null) {
                    this.next = GroupingIterable.this.createGroup(this.lastItem);
                    this.lastItem = null;
                }
                while (it.hasNext()) {
                    Object item = it.next();
                    if (!GroupingIterable.this.isIncluded(item)) continue;
                    if (this.next == null) {
                        this.next = GroupingIterable.this.createGroup(item);
                        continue;
                    }
                    if (GroupingIterable.this.isPartOfGroup(this.next, item)) {
                        GroupingIterable.this.addToGroup(this.next, item);
                        continue;
                    }
                    this.lastItem = item;
                    break;
                }
            }
        };
    }

    protected boolean isIncluded(TSource item) {
        return true;
    }

    protected abstract TGroup createGroup(TSource var1);

    protected abstract boolean isPartOfGroup(TGroup var1, TSource var2);

    protected abstract void addToGroup(TGroup var1, TSource var2);

    private void callClose() {
        if (!this.doneCalled) {
            this.doneCalled = true;
            this.close();
        }
    }

    @Override
    public void close() {
    }
}

