/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.BiFunction;

public class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copy(input, output, 0L, Long.MAX_VALUE);
    }

    public static long copy(InputStream input, OutputStream output, long offset, long limit) throws IOException {
        int n;
        long skipResult;
        byte[] buffer = new byte[4096];
        long count = 0L;
        if (offset > 0L && (skipResult = input.skip(offset)) < offset) {
            return 0L;
        }
        long len = limit;
        while (-1 != (n = input.read(buffer, 0, (int)Math.min((long)buffer.length, len)))) {
            output.write(buffer, 0, n);
            count += (long)n;
            if ((len -= (long)n) != 0L) continue;
            break;
        }
        return count;
    }

    public static byte[] toBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy(in, out);
        return out.toByteArray();
    }

    public static byte[] toBytes(InputStream in, long offset, long limit) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy(in, out, offset, limit);
        return out.toByteArray();
    }

    public static String toString(InputStream in) throws IOException {
        return new String(IOUtils.toBytes(in));
    }

    public static String toString(InputStream in, long offset, long limit) throws IOException {
        return new String(IOUtils.toBytes(in, offset, limit));
    }

    @SafeVarargs
    public static <T extends AutoCloseable> void closeAll(T ... closeables) throws IOException {
        IOUtils.close(IOException::new, closeables);
    }

    @SafeVarargs
    public static <T extends AutoCloseable, E extends Throwable> void close(BiFunction<String, Throwable, E> constructor, T ... closeables) throws E {
        Throwable closeThrowable = null;
        for (T closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Exception e) {
                if (closeThrowable == null) {
                    closeThrowable = (Throwable)constructor.apply("Exception closing multiple resources.", e);
                    continue;
                }
                closeThrowable.addSuppressed(e);
            }
        }
        if (closeThrowable != null) {
            throw closeThrowable;
        }
    }
}

