/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.mware.ge.Element;
import com.mware.ge.util.CloseableUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.Assert;

public class IterableUtils {
    public static <T> List<T> toList(Iterable<? extends T> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<T> results = new ArrayList<T>();
        for (T o : iterable) {
            results.add(o);
        }
        CloseableUtils.closeQuietly(iterable);
        return results;
    }

    public static <T> List<T> toList(Iterator<T> iterator) {
        ArrayList<T> results = new ArrayList<T>();
        while (iterator.hasNext()) {
            T o = iterator.next();
            results.add(o);
        }
        return results;
    }

    public static <T> Set<T> toSet(Iterable<? extends T> iterable) {
        if (iterable instanceof Set) {
            return (Set)iterable;
        }
        HashSet<T> results = new HashSet<T>();
        for (T o : iterable) {
            results.add(o);
        }
        CloseableUtils.closeQuietly(iterable);
        return results;
    }

    public static <T> Set<T> toSet(T[] iterable) {
        HashSet results = new HashSet();
        Collections.addAll(results, iterable);
        return results;
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> type) {
        if (iterable instanceof Collection) {
            Object[] array = (Object[])Array.newInstance(type, ((Collection)iterable).size());
            return ((Collection)iterable).toArray(array);
        }
        List<Object> list = IterableUtils.toList(iterable);
        Object[] array = (Object[])Array.newInstance(type, list.size());
        return list.toArray(array);
    }

    public static <T> int count(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        int count = 0;
        for (T ignore : iterable) {
            ++count;
        }
        CloseableUtils.closeQuietly(iterable);
        return count;
    }

    public static <T> int count(Iterator<T> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        CloseableUtils.closeQuietly(iterator);
        return count;
    }

    public static <T> boolean isEmpty(Iterable<T> iterable) {
        boolean bl;
        Iterator<T> iterator = iterable.iterator();
        try {
            bl = !iterator.hasNext();
        }
        catch (Throwable throwable) {
            CloseableUtils.closeQuietly(iterator);
            throw throwable;
        }
        CloseableUtils.closeQuietly(iterator);
        return bl;
    }

    public static <T> Iterable<T> toIterable(final T[] arr) {
        return () -> new Iterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < arr.length;
            }

            @Override
            public T next() {
                return arr[this.index++];
            }

            @Override
            public void remove() {
                throw new RuntimeException("Not supported");
            }
        };
    }

    public static <T> Iterator<T> toSingleValueIterator(final T obj) {
        return new Iterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < 1;
            }

            @Override
            public T next() {
                return obj;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Not supported");
            }
        };
    }

    public static <T> T single(Iterable<? extends T> it) {
        Iterator<T> i = it.iterator();
        if (!i.hasNext()) {
            CloseableUtils.closeQuietly(i, it);
            throw new IllegalStateException("No items found.");
        }
        T result = i.next();
        if (i.hasNext()) {
            CloseableUtils.closeQuietly(i, it);
            throw new IllegalStateException("More than 1 item found.");
        }
        CloseableUtils.closeQuietly(i, it);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T anyOrDefault(Iterable<? extends T> it, T defaultValue) {
        T t;
        Iterator<T> i = it.iterator();
        if (!i.hasNext()) {
            CloseableUtils.closeQuietly(i, it);
            return defaultValue;
        }
        try {
            t = i.next();
        }
        catch (Throwable throwable) {
            CloseableUtils.closeQuietly(i, it);
            throw throwable;
        }
        CloseableUtils.closeQuietly(i, it);
        return t;
    }

    public static <T> T singleOrDefault(Iterable<? extends T> it, T defaultValue) {
        Iterator<T> i = it.iterator();
        if (!i.hasNext()) {
            CloseableUtils.closeQuietly(i, it);
            return defaultValue;
        }
        T result = i.next();
        if (i.hasNext()) {
            T nextValue = i.next();
            CloseableUtils.closeQuietly(i, it);
            throw new IllegalStateException("More than 1 item found. [" + result + ", " + nextValue + "...]");
        }
        CloseableUtils.closeQuietly(i, it);
        return result;
    }

    public static <T> T singleOrDefault(Iterator<? extends T> it, T defaultValue) {
        if (!it.hasNext()) {
            CloseableUtils.closeQuietly(it);
            return defaultValue;
        }
        T result = it.next();
        if (it.hasNext()) {
            T nextValue = it.next();
            CloseableUtils.closeQuietly(it, it);
            throw new IllegalStateException("More than 1 item found. [" + result + ", " + nextValue + "...]");
        }
        CloseableUtils.closeQuietly(it);
        return result;
    }

    public static String join(Iterable items, String sep) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (Object o : items) {
            if (!first) {
                sb.append(sep);
            }
            sb.append(o);
            first = false;
        }
        return sb.toString();
    }

    public static Iterable<Element> toElementIterable(Iterable<? extends Element> elements) {
        return elements;
    }

    public static <T extends Element> Map<String, T> toMapById(Iterable<T> elements) {
        HashMap<Object, Element> result = new HashMap<Object, Element>();
        for (Element element : elements) {
            if (element == null) continue;
            result.put(element.getId(), element);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static <T> void assertContains(Object expected, Iterable<T> iterable) {
        Iterator<T> iterator;
        StringBuilder found;
        block6: {
            found = new StringBuilder();
            boolean first = true;
            iterator = iterable.iterator();
            while (true) {
                T o;
                block5: {
                    if (!iterator.hasNext()) break;
                    o = iterator.next();
                    if (!expected.equals(o)) break block5;
                    CloseableUtils.closeQuietly(iterator);
                    return;
                }
                if (!first) {
                    found.append(", ");
                }
                found.append(o);
                first = false;
                continue;
                break;
            }
            break block6;
            catch (Throwable throwable) {
                CloseableUtils.closeQuietly(iterator);
                throw throwable;
            }
        }
        CloseableUtils.closeQuietly(iterator);
        Assert.assertTrue((String)("Iterable does not contain [" + expected + "], found [" + found + "]"), (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T last(Iterable<T> iterable) {
        T t;
        Iterator<T> iterator = iterable.iterator();
        try {
            T last = null;
            while (iterator.hasNext()) {
                last = iterator.next();
            }
            t = last;
        }
        catch (Throwable throwable) {
            CloseableUtils.closeQuietly(iterator);
            throw throwable;
        }
        CloseableUtils.closeQuietly(iterator);
        return t;
    }

    public static <T> List<T> fastIterableToList(Iterable<T> iterable) {
        return ((Stream)StreamSupport.stream(iterable.spliterator(), true).parallel()).collect(Collectors.toList());
    }
}

